/*
 * Decompiled with CFR 0.152.
 */
package imhotep.layer;

import core.swing.CommandManager;
import core.swing.ResourceManager;
import imhotep.layer.LayerModel;
import imhotep.model.SVGModel;
import imhotep.util.SVGLayerUtilities;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.DefaultCellEditor;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.table.DefaultTableColumnModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.svg.SVGSVGElement;

public class LayerTable
extends JTable {
    private static String RESOURCES = "imhotep.layer.resources.LayerTable";
    private static ResourceManager resource = ResourceManager.getBundle(RESOURCES);
    private static CommandManager commands = CommandManager.getSystemBundle();
    private SVGModel svgModel;
    private LayerModel layerModel = new LayerModel();
    private Icon visibleOn;
    private Icon visibleOff;
    private String visibleTip;
    private Icon lockOn;
    private Icon lockOff;
    private String lockTip;
    private String title;

    public LayerTable() {
        super.setModel(this.layerModel);
        super.setColumnModel(this.createTableColumnModel());
        super.setTableHeader(null);
        super.setSelectionMode(0);
        super.setRowHeight(20);
        this.visibleOn = resource.getIcon("Layer.viewOnIcon");
        this.visibleOff = resource.getIcon("Layer.viewOffIcon");
        this.visibleTip = resource.getString("Layer.viewTip");
        this.lockOn = resource.getIcon("Layer.lockOnIcon");
        this.lockOff = resource.getIcon("Layer.lockOffIcon");
        this.lockTip = resource.getString("Layer.lockTip");
        this.title = resource.getString("Layer.title");
    }

    protected TableColumnModel createTableColumnModel() {
        DefaultTableColumnModel tcm = new DefaultTableColumnModel();
        TableColumn c0 = new TableColumn(0, 20, new VisibleRenderer(), new VisibleEditor());
        TableColumn c1 = new TableColumn(1, 20, new LockRenderer(), new LockEditor());
        TableColumn c2 = new TableColumn(2, 140, new NameRenderer(), new NameEditor());
        c0.setPreferredWidth(20);
        c0.setMaxWidth(20);
        c0.setMinWidth(20);
        c1.setPreferredWidth(20);
        c1.setMaxWidth(20);
        c1.setMinWidth(20);
        tcm.addColumn(c0);
        tcm.addColumn(c1);
        tcm.addColumn(c2);
        return tcm;
    }

    public void setSVGModel(SVGModel model) {
        this.svgModel = model;
        if (this.svgModel != null) {
            int state = model.getState();
            this.layerModel.setData(model.getSVGDocument());
            int selected = this.layerModel.indexOf((Node)model.getSelectedLayer());
            super.getSelectionModel().setSelectionInterval(selected, selected);
            super.setEnabled(state == 0);
        } else {
            this.layerModel.setData(null);
            super.setEnabled(false);
        }
        super.revalidate();
        super.repaint();
    }

    public SVGModel getSVGModel() {
        return this.svgModel;
    }

    public String getTitle() {
        return this.title;
    }

    private void visibleActionPerformed() {
        SVGSVGElement layer = (SVGSVGElement)this.getValueAt(this.getEditingRow(), 0);
        if (layer == null) {
            return;
        }
        commands.getCommand("imhotep.layer.action.Visible").actionPerformed(layer);
    }

    private void lockActionPerformed() {
        SVGSVGElement layer = (SVGSVGElement)this.getValueAt(this.getEditingRow(), 0);
        if (layer == null) {
            return;
        }
        commands.getCommand("imhotep.layer.action.Lock").actionPerformed(layer);
    }

    private void nameActionPerformed() {
        SVGSVGElement layer = (SVGSVGElement)this.getValueAt(this.getEditingRow(), 0);
        if (layer == null) {
            return;
        }
        commands.getCommand("imhotep.layer.action.Name").actionPerformed(layer);
    }

    public void valueChanged(ListSelectionEvent e) {
        if (e.getValueIsAdjusting()) {
            int i = super.getSelectedRow();
            SVGSVGElement layer = (SVGSVGElement)this.layerModel.getValueAt(i, 0);
            this.svgModel.setSelectedLayer(layer);
        }
        super.valueChanged(e);
    }

    public void changeSelection(int rowIndex, int columnIndex, boolean toggle, boolean extend) {
        if (columnIndex > 1) {
            super.changeSelection(rowIndex, columnIndex, toggle, extend);
        }
    }

    public class VisibleEditor
    extends DefaultCellEditor
    implements ActionListener {
        private boolean isPushed;
        private JButton button = new JButton();

        public VisibleEditor() {
            super(new JCheckBox());
            this.button.setOpaque(true);
            this.button.setBorderPainted(false);
            this.button.addActionListener(this);
        }

        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            LayerTable comp = (LayerTable)table;
            Element layer = (Element)value;
            boolean isVisible = SVGLayerUtilities.getLayerVisible(layer);
            this.button.setIcon(isVisible ? LayerTable.this.visibleOn : LayerTable.this.visibleOff);
            this.isPushed = true;
            return this.button;
        }

        public Object getCellEditorValue() {
            this.isPushed = false;
            return super.getCellEditorValue();
        }

        public void actionPerformed(ActionEvent e) {
            LayerTable.this.visibleActionPerformed();
            this.fireEditingStopped();
        }

        public boolean stopCellEditing() {
            this.isPushed = false;
            return super.stopCellEditing();
        }
    }

    public class LockEditor
    extends DefaultCellEditor
    implements ActionListener {
        private boolean isPushed;
        private JButton button = new JButton();

        public LockEditor() {
            super(new JCheckBox());
            this.button.setOpaque(true);
            this.button.setBorderPainted(false);
            this.button.addActionListener(this);
        }

        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            LayerTable comp = (LayerTable)table;
            Element layer = (Element)value;
            boolean isLock = SVGLayerUtilities.getLayerLock(layer);
            this.button.setIcon(isLock ? LayerTable.this.lockOn : LayerTable.this.lockOff);
            this.isPushed = true;
            return this.button;
        }

        public Object getCellEditorValue() {
            this.isPushed = false;
            return super.getCellEditorValue();
        }

        public void actionPerformed(ActionEvent e) {
            LayerTable.this.lockActionPerformed();
            this.fireEditingStopped();
        }

        public boolean stopCellEditing() {
            this.isPushed = false;
            return super.stopCellEditing();
        }
    }

    public class NameEditor
    extends DefaultCellEditor
    implements ActionListener {
        private boolean isPushed;
        private JButton button;

        public NameEditor() {
            super(new JCheckBox());
            this.clickCountToStart = 2;
            this.button = new JButton();
            this.button.setOpaque(true);
            this.button.setBorderPainted(false);
            this.button.addActionListener(this);
        }

        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            LayerTable comp = (LayerTable)table;
            Element layer = (Element)value;
            String name = SVGLayerUtilities.getLayerName(layer);
            this.button.setText(name);
            this.isPushed = true;
            return this.button;
        }

        public Object getCellEditorValue() {
            this.isPushed = false;
            return super.getCellEditorValue();
        }

        public void actionPerformed(ActionEvent e) {
            LayerTable.this.nameActionPerformed();
            this.fireEditingStopped();
        }

        public boolean stopCellEditing() {
            this.isPushed = false;
            return super.stopCellEditing();
        }
    }

    public class VisibleRenderer
    extends JButton
    implements TableCellRenderer {
        public VisibleRenderer() {
            super.setOpaque(true);
        }

        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            Element layer = (Element)value;
            boolean isVisible = SVGLayerUtilities.getLayerVisible(layer);
            super.setFont(table.getFont());
            super.setIcon(isVisible ? LayerTable.this.visibleOn : LayerTable.this.visibleOff);
            super.setToolTipText(LayerTable.this.visibleTip);
            super.setEnabled(table.isEnabled());
            return this;
        }
    }

    public class LockRenderer
    extends JButton
    implements TableCellRenderer {
        public LockRenderer() {
            super.setOpaque(true);
        }

        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            Element layer = (Element)value;
            boolean isLock = SVGLayerUtilities.getLayerLock(layer);
            super.setIcon(isLock ? LayerTable.this.lockOn : LayerTable.this.lockOff);
            super.setEnabled(table.isEnabled());
            super.setToolTipText(LayerTable.this.lockTip);
            return this;
        }
    }

    public class NameRenderer
    extends JLabel
    implements TableCellRenderer {
        public NameRenderer() {
            super.setOpaque(true);
            super.setBorder(new EmptyBorder(1, 1, 1, 1));
        }

        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            Element layer = (Element)value;
            String name = SVGLayerUtilities.getLayerName(layer);
            super.setForeground(isSelected ? table.getSelectionForeground() : table.getForeground());
            super.setBackground(isSelected ? table.getSelectionBackground() : table.getBackground());
            super.setFont(table.getFont());
            super.setText(name);
            super.setEnabled(table.isEnabled());
            return this;
        }
    }
}

