/*
 * Decompiled with CFR 0.152.
 */
package imhotep.layer;

import imhotep.util.SVGLayerUtilities;
import java.util.List;
import java.util.Vector;
import javax.swing.table.AbstractTableModel;
import org.w3c.dom.Node;
import org.w3c.dom.svg.SVGDocument;
import org.w3c.dom.svg.SVGSVGElement;

public class LayerModel
extends AbstractTableModel {
    private List layers = new Vector();

    public void setData(SVGDocument doc) {
        this.layers.clear();
        if (doc != null) {
            SVGSVGElement root = doc.getRootElement();
            this.layers.add(root);
            Node n = root.getFirstChild();
            while (n != null) {
                if (SVGLayerUtilities.isLayer(n)) {
                    this.layers.add(n);
                }
                n = n.getNextSibling();
            }
        }
    }

    public int indexOf(Node node) {
        return this.layers.indexOf(node);
    }

    public Object getValueAt(int rowIndex, int columnIndex) {
        if (this.layers == null) {
            return null;
        }
        try {
            return this.layers.get(rowIndex);
        }
        catch (Exception e) {
            return null;
        }
    }

    public int getRowCount() {
        if (this.layers == null) {
            return 0;
        }
        return this.layers.size();
    }

    public int getColumnCount() {
        return 3;
    }

    public boolean isCellEditable(int r, int c) {
        return r != 0;
    }
}

