/*
 * Decompiled with CFR 0.152.
 */
package imhotep.editor.canvas.tool;

import imhotep.editor.canvas.Canvas;
import imhotep.editor.canvas.tool.AbstractTool;
import imhotep.model.SVGModel;
import imhotep.util.NodeSelection;
import java.awt.Cursor;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Shape;
import java.awt.event.MouseEvent;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;

public class ShearTool
extends AbstractTool {
    private Shape outline;
    private Shape shape;
    private int mode;
    private static Cursor shearXCursor = AbstractTool.createCurser("imhotep/menu/resources/draw_shear_x.png");
    private static Cursor shearYCursor = AbstractTool.createCurser("imhotep/menu/resources/draw_shear_y.png");

    public ShearTool(Canvas canvas) {
        super(canvas);
    }

    public void startTool() {
    }

    public void endTool() {
    }

    public void paint(Graphics2D g2) {
        g2.fill(this.svgCanvas.getHandleBounds(2));
        g2.fill(this.svgCanvas.getHandleBounds(4));
        g2.fill(this.svgCanvas.getHandleBounds(6));
        g2.fill(this.svgCanvas.getHandleBounds(8));
        if (this.shape != null) {
            g2.draw(this.shape);
        }
    }

    public void mousePressed(MouseEvent e) {
        this.pressPoint = e.getPoint();
        this.mode = this.svgCanvas.getHandleNumber(this.pressPoint);
        if (this.mode > 0) {
            SVGModel m = this.svgCanvas.getSVGModel();
            AffineTransform t = this.svgCanvas.getRenderingTransform();
            this.outline = m.getSelectedOutline(t);
        }
    }

    public void mouseDragged(MouseEvent e) {
        this.dragPoint = e.getPoint();
        if (this.mode == 2 || this.mode == 4 || this.mode == 6 || this.mode == 8) {
            Rectangle2D r = this.svgCanvas.getHandleBounds(0);
            double[] d = new double[]{this.pressPoint.getX(), this.pressPoint.getY(), this.dragPoint.getX(), this.dragPoint.getY(), r.getX(), r.getY()};
            double shx = 0.0;
            double shy = 0.0;
            if (this.mode == 2 || this.mode == 8) {
                shx = (d[2] - d[0]) * 0.01;
                shy = 0.0;
            } else if (this.mode == 4 || this.mode == 6) {
                shx = 0.0;
                shy = (d[3] - d[1]) * 0.01;
            }
            AffineTransform at = new AffineTransform();
            at.translate(d[4], d[5]);
            at.shear(shx, shy);
            at.translate(-d[4], -d[5]);
            this.shape = at.createTransformedShape(this.outline);
            this.svgCanvas.repaint();
        }
    }

    public void mouseReleased(MouseEvent e) {
        this.releasePoint = e.getPoint();
        if (this.mode == 2 || this.mode == 4 || this.mode == 6 || this.mode == 8) {
            try {
                Rectangle2D r = this.svgCanvas.getHandleBounds(0);
                double[] d = new double[]{this.pressPoint.getX(), this.pressPoint.getY(), this.dragPoint.getX(), this.dragPoint.getY(), r.getX(), r.getY()};
                AffineTransform vt = this.svgCanvas.getViewBoxTransform().createInverse();
                vt.transform(d, 0, d, 0, 3);
                double shx = 0.0;
                double shy = 0.0;
                if (this.mode == 2 || this.mode == 8) {
                    shx = (d[2] - d[0]) * 0.01;
                    shy = 0.0;
                } else if (this.mode == 4 || this.mode == 6) {
                    shx = 0.0;
                    shy = (d[3] - d[1]) * 0.01;
                }
                AffineTransform at = new AffineTransform();
                at.translate(d[4], d[5]);
                at.shear(shx, shy);
                at.translate(-d[4], -d[5]);
                SVGModel m = this.svgCanvas.getSVGModel();
                NodeSelection ns = m.getSelectedNodes();
                m.transformEntities(ns, at);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        this.outline = null;
        this.shape = null;
        this.svgCanvas.repaint();
    }

    public void mouseMoved(MouseEvent e) {
        Point movePoint = e.getPoint();
        int num = this.svgCanvas.getHandleNumber(movePoint);
        if (num == 2) {
            this.svgCanvas.setCursor(shearYCursor);
        } else if (num == 4) {
            this.svgCanvas.setCursor(shearXCursor);
        } else if (num == 6) {
            this.svgCanvas.setCursor(shearXCursor);
        } else if (num == 8) {
            this.svgCanvas.setCursor(shearYCursor);
        } else {
            this.svgCanvas.setCursor(Cursor.getPredefinedCursor(0));
        }
    }
}

