/*
 * Decompiled with CFR 0.152.
 */
package imhotep.editor.canvas.tool;

import imhotep.editor.canvas.Canvas;
import imhotep.editor.canvas.tool.AbstractTool;
import imhotep.model.SVGModel;
import imhotep.util.NodeSelection;
import java.awt.Cursor;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Shape;
import java.awt.event.MouseEvent;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;

public class ScaleTool
extends AbstractTool {
    protected Shape outline;
    protected Shape shape;
    protected int mode;

    public ScaleTool(Canvas canvas) {
        super(canvas);
    }

    public void startTool() {
    }

    public void endTool() {
    }

    public void paint(Graphics2D g2) {
        g2.fill(this.svgCanvas.getHandleBounds(1));
        g2.fill(this.svgCanvas.getHandleBounds(2));
        g2.fill(this.svgCanvas.getHandleBounds(3));
        g2.fill(this.svgCanvas.getHandleBounds(4));
        g2.fill(this.svgCanvas.getHandleBounds(6));
        g2.fill(this.svgCanvas.getHandleBounds(7));
        g2.fill(this.svgCanvas.getHandleBounds(8));
        g2.fill(this.svgCanvas.getHandleBounds(9));
        if (this.shape != null) {
            g2.draw(this.shape);
        }
    }

    public void mousePressed(MouseEvent e) {
        this.pressPoint = e.getPoint();
        this.mode = this.svgCanvas.getHandleNumber(this.pressPoint);
        if (this.mode > 0) {
            SVGModel m = this.svgCanvas.getSVGModel();
            AffineTransform t = this.svgCanvas.getRenderingTransform();
            this.outline = m.getSelectedOutline(t);
        }
    }

    public void mouseDragged(MouseEvent e) {
        this.dragPoint = e.getPoint();
        if (this.mode > 0) {
            Point2D resizeBasis = this.svgCanvas.getHandlePoint(10 - this.mode);
            Point2D resizeStart = this.svgCanvas.getHandlePoint(this.mode);
            double[] d = new double[]{resizeBasis.getX(), resizeBasis.getY(), resizeStart.getX(), resizeStart.getY(), this.dragPoint.getX(), this.dragPoint.getY()};
            double sx = d[0] == d[2] ? 1.0 : (d[4] - d[0]) / (d[2] - d[0]);
            double sy = d[1] == d[3] ? 1.0 : (d[5] - d[1]) / (d[3] - d[1]);
            AffineTransform at = new AffineTransform();
            at.translate(d[0], d[1]);
            at.scale(sx, sy);
            at.translate(-d[0], -d[1]);
            this.shape = at.createTransformedShape(this.outline);
            this.svgCanvas.repaint();
        }
    }

    public void mouseReleased(MouseEvent e) {
        this.releasePoint = e.getPoint();
        if (this.mode > 0 && this.isValidateShape()) {
            try {
                Point2D resizeBasis = this.svgCanvas.getHandlePoint(10 - this.mode);
                Point2D resizeStart = this.svgCanvas.getHandlePoint(this.mode);
                double[] d = new double[]{resizeBasis.getX(), resizeBasis.getY(), resizeStart.getX(), resizeStart.getY(), this.releasePoint.getX(), this.releasePoint.getY()};
                AffineTransform vt = this.svgCanvas.getViewBoxTransform().createInverse();
                vt.transform(d, 0, d, 0, 3);
                double sx = d[0] == d[2] ? 1.0 : (d[4] - d[0]) / (d[2] - d[0]);
                double sy = d[1] == d[3] ? 1.0 : (d[5] - d[1]) / (d[3] - d[1]);
                AffineTransform at = new AffineTransform();
                at.translate(d[0], d[1]);
                at.scale(sx, sy);
                at.translate(-d[0], -d[1]);
                SVGModel m = this.svgCanvas.getSVGModel();
                NodeSelection ns = m.getSelectedNodes();
                m.transformEntities(ns, at);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        this.outline = null;
        this.shape = null;
        this.svgCanvas.repaint();
    }

    private boolean isValidateShape() {
        if (this.shape.getBounds().isEmpty()) {
            return this.outline.getBounds2D().isEmpty();
        }
        return true;
    }

    public void mouseMoved(MouseEvent e) {
        Point movePoint = e.getPoint();
        int num = this.svgCanvas.getHandleNumber(movePoint);
        if (num == 1) {
            this.svgCanvas.setCursor(Cursor.getPredefinedCursor(6));
        } else if (num == 2) {
            this.svgCanvas.setCursor(Cursor.getPredefinedCursor(8));
        } else if (num == 3) {
            this.svgCanvas.setCursor(Cursor.getPredefinedCursor(7));
        } else if (num == 4) {
            this.svgCanvas.setCursor(Cursor.getPredefinedCursor(10));
        } else if (num == 6) {
            this.svgCanvas.setCursor(Cursor.getPredefinedCursor(11));
        } else if (num == 7) {
            this.svgCanvas.setCursor(Cursor.getPredefinedCursor(4));
        } else if (num == 8) {
            this.svgCanvas.setCursor(Cursor.getPredefinedCursor(9));
        } else if (num == 9) {
            this.svgCanvas.setCursor(Cursor.getPredefinedCursor(5));
        } else {
            this.svgCanvas.setCursor(Cursor.getPredefinedCursor(0));
        }
    }
}

