/*
 * Decompiled with CFR 0.152.
 */
package imhotep.editor.canvas.tool;

import imhotep.editor.canvas.Canvas;
import imhotep.editor.canvas.tool.AbstractTool;
import imhotep.model.SVGModel;
import imhotep.util.NodeSelection;
import imhotep.util.SVGGeomUtilities;
import imhotep.util.SVGRendererUtilities;
import java.awt.Cursor;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.event.MouseEvent;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import org.w3c.dom.Element;
import org.w3c.dom.svg.SVGDocument;

public class RectTool
extends AbstractTool {
    protected Rectangle2D shape;

    public RectTool(Canvas canvas) {
        super(canvas);
    }

    public void startTool() {
    }

    public void endTool() {
    }

    public void paint(Graphics2D g2) {
        if (this.shape != null) {
            g2.draw(this.shape);
        }
    }

    public void mousePressed(MouseEvent e) {
        this.pressPoint = e.getPoint();
        if (this.shape == null) {
            this.shape = new Rectangle2D.Double();
        }
    }

    public void mouseDragged(MouseEvent e) {
        this.dragPoint = e.getPoint();
        if (this.shape != null) {
            double x1 = this.pressPoint.getX();
            double y1 = this.pressPoint.getY();
            double x2 = this.dragPoint.getX();
            double y2 = this.dragPoint.getY();
            double tx = x2 - x1;
            double ty = y2 - y1;
            double tm = Math.max(tx, ty);
            if (e.isShiftDown() && e.isControlDown()) {
                this.shape.setFrameFromCenter(x1, y1, x1 + tm, y1 + tm);
            } else if (e.isShiftDown()) {
                this.shape.setFrameFromDiagonal(x1, y1, x1 + tm, y1 + tm);
            } else if (e.isControlDown()) {
                this.shape.setFrameFromCenter(x1, y1, x2, y2);
            } else {
                this.shape.setFrameFromDiagonal(x1, y1, x2, y2);
            }
            this.svgCanvas.repaint();
        }
    }

    public void mouseReleased(MouseEvent e) {
        this.releasePoint = e.getPoint();
        if (this.shape != null && this.isValidateShape(this.shape)) {
            try {
                AffineTransform vt = this.svgCanvas.getViewBoxTransform().createInverse();
                Shape svgShape = vt.createTransformedShape(this.shape);
                Rectangle2D.Double rect = new Rectangle2D.Double();
                rect.setFrame(svgShape.getBounds2D());
                SVGModel model = this.svgCanvas.getSVGModel();
                SVGDocument doc = model.getSVGDocument();
                Element ele = doc.createElementNS("http://www.w3.org/2000/svg", "rect");
                ele.setAttributeNS(null, "x", SVGGeomUtilities.doubleString(((RectangularShape)rect).getX()));
                ele.setAttributeNS(null, "y", SVGGeomUtilities.doubleString(((RectangularShape)rect).getY()));
                ele.setAttributeNS(null, "width", SVGGeomUtilities.doubleString(((RectangularShape)rect).getWidth()));
                ele.setAttributeNS(null, "height", SVGGeomUtilities.doubleString(((RectangularShape)rect).getHeight()));
                ele.setAttributeNS(null, "style", SVGRendererUtilities.SHAPE_DEFAULT_STYLE);
                model.addEntities(new NodeSelection(ele));
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        this.shape = null;
        this.svgCanvas.repaint();
    }

    public void mouseMoved(MouseEvent e) {
        this.svgCanvas.setCursor(Cursor.getPredefinedCursor(1));
    }
}

