/*
 * Decompiled with CFR 0.152.
 */
package imhotep.editor.canvas.tool;

import imhotep.editor.canvas.Canvas;
import imhotep.editor.canvas.tool.AbstractTool;
import imhotep.model.SVGModel;
import imhotep.util.NodeSelection;
import imhotep.util.SVGGeomUtilities;
import imhotep.util.SVGRendererUtilities;
import java.awt.Cursor;
import java.awt.Graphics2D;
import java.awt.event.MouseEvent;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.PathIterator;
import org.w3c.dom.Element;
import org.w3c.dom.svg.SVGDocument;

public class PathTool
extends AbstractTool {
    private GeneralPath shape;

    public PathTool(Canvas canvas) {
        super(canvas);
    }

    public void startTool() {
    }

    public void endTool() {
    }

    public void paint(Graphics2D g2) {
        if (this.shape != null) {
            g2.draw(this.shape);
        }
    }

    public void mousePressed(MouseEvent e) {
        this.pressPoint = e.getPoint();
        if (this.shape == null) {
            this.shape = new GeneralPath();
            this.shape.moveTo((float)this.pressPoint.getX(), (float)this.pressPoint.getY());
        }
    }

    public void mouseDragged(MouseEvent e) {
        this.dragPoint = e.getPoint();
        if (this.shape != null) {
            this.shape.lineTo((float)this.dragPoint.getX(), (float)this.dragPoint.getY());
            this.svgCanvas.repaint();
        }
    }

    public void mouseReleased(MouseEvent e) {
        this.releasePoint = e.getPoint();
        if (this.shape != null && this.isValidateShape(this.shape)) {
            try {
                AffineTransform vt = this.svgCanvas.getViewBoxTransform().createInverse();
                PathIterator pi = this.shape.getPathIterator(vt);
                SVGModel model = this.svgCanvas.getSVGModel();
                SVGDocument doc = model.getSVGDocument();
                Element ele = doc.createElementNS("http://www.w3.org/2000/svg", "path");
                ele.setAttributeNS(null, "d", SVGGeomUtilities.toSVGPathData(pi));
                ele.setAttributeNS(null, "style", SVGRendererUtilities.LINE_DEFAULT_STYLE);
                model.addEntities(new NodeSelection(ele));
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        this.shape = null;
        this.svgCanvas.repaint();
    }

    public void mouseMoved(MouseEvent e) {
        this.svgCanvas.setCursor(Cursor.getPredefinedCursor(1));
    }
}

