/*
 * Decompiled with CFR 0.152.
 */
package imhotep.editor.canvas.tool;

import core.swing.JFileListChooser;
import imhotep.editor.canvas.Canvas;
import imhotep.editor.canvas.tool.RectTool;
import imhotep.model.SVGModel;
import imhotep.util.FileFilter;
import imhotep.util.NodeSelection;
import imhotep.util.SVGGeomUtilities;
import java.awt.Shape;
import java.awt.event.MouseEvent;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import org.w3c.dom.Element;
import org.w3c.dom.svg.SVGDocument;

public class ImageTool
extends RectTool {
    private JFileListChooser dialog;

    private void initDialog() {
        this.dialog = new JFileListChooser();
        this.dialog.setExtension(FileFilter.LINKABLE_IMAGES);
    }

    public ImageTool(Canvas canvas) {
        super(canvas);
    }

    public void mouseReleased(MouseEvent e) {
        this.releasePoint = e.getPoint();
        if (this.shape != null && this.isValidateShape(this.shape)) {
            try {
                int i;
                if (this.dialog == null) {
                    this.initDialog();
                }
                if ((i = this.dialog.showOpenDialog(this.svgCanvas)) == 0) {
                    String imgFile = this.dialog.getSelectedFile().toURI().toASCIIString();
                    AffineTransform vt = this.svgCanvas.getViewBoxTransform().createInverse();
                    Shape svgShape = vt.createTransformedShape(this.shape);
                    Rectangle2D.Double rect = new Rectangle2D.Double();
                    rect.setFrame(svgShape.getBounds2D());
                    SVGModel model = this.svgCanvas.getSVGModel();
                    SVGDocument doc = model.getSVGDocument();
                    Element ele = doc.createElementNS("http://www.w3.org/2000/svg", "image");
                    ele.setAttributeNS(null, "x", SVGGeomUtilities.doubleString(((RectangularShape)rect).getX()));
                    ele.setAttributeNS(null, "y", SVGGeomUtilities.doubleString(((RectangularShape)rect).getY()));
                    ele.setAttributeNS(null, "width", SVGGeomUtilities.doubleString(((RectangularShape)rect).getWidth()));
                    ele.setAttributeNS(null, "height", SVGGeomUtilities.doubleString(((RectangularShape)rect).getHeight()));
                    ele.setAttributeNS("http://www.w3.org/1999/xlink", "xlink:href", imgFile);
                    model.addEntities(new NodeSelection(ele));
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        this.shape = null;
        this.svgCanvas.repaint();
    }
}

