/*
 * Decompiled with CFR 0.152.
 */
package imhotep.editor.canvas.tool;

import imhotep.editor.canvas.Canvas;
import imhotep.editor.canvas.tool.AbstractTool;
import imhotep.model.SVGModel;
import imhotep.util.NodeSelection;
import imhotep.util.SVGGeomUtilities;
import imhotep.util.SVGRendererUtilities;
import java.awt.Cursor;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.event.MouseEvent;
import java.awt.geom.AffineTransform;
import java.awt.geom.Ellipse2D;
import java.awt.geom.RectangularShape;
import org.w3c.dom.Element;
import org.w3c.dom.svg.SVGDocument;

public class EllipseTool
extends AbstractTool {
    private Ellipse2D shape;

    public EllipseTool(Canvas canvas) {
        super(canvas);
    }

    public void startTool() {
    }

    public void endTool() {
    }

    public void paint(Graphics2D g2) {
        if (this.shape != null) {
            g2.draw(this.shape);
        }
    }

    public void mousePressed(MouseEvent e) {
        this.pressPoint = e.getPoint();
        if (this.shape == null) {
            this.shape = new Ellipse2D.Double();
        }
    }

    public void mouseDragged(MouseEvent e) {
        this.dragPoint = e.getPoint();
        if (this.shape != null) {
            double x1 = this.pressPoint.getX();
            double y1 = this.pressPoint.getY();
            double x2 = this.dragPoint.getX();
            double y2 = this.dragPoint.getY();
            double tx = x2 - x1;
            double ty = y2 - y1;
            double tm = Math.max(tx, ty);
            if (e.isShiftDown() && e.isControlDown()) {
                this.shape.setFrameFromCenter(x1, y1, x1 + tm, y1 + tm);
            } else if (e.isShiftDown()) {
                this.shape.setFrameFromDiagonal(x1, y1, x1 + tm, y1 + tm);
            } else if (e.isControlDown()) {
                this.shape.setFrameFromCenter(x1, y1, x2, y2);
            } else {
                this.shape.setFrameFromDiagonal(x1, y1, x2, y2);
            }
            this.svgCanvas.repaint();
        }
    }

    public void mouseReleased(MouseEvent e) {
        this.releasePoint = e.getPoint();
        if (this.shape != null && this.isValidateShape(this.shape)) {
            try {
                AffineTransform vt = this.svgCanvas.getViewBoxTransform().createInverse();
                Shape svgShape = vt.createTransformedShape(this.shape);
                Ellipse2D.Double elllipse = new Ellipse2D.Double();
                elllipse.setFrame(svgShape.getBounds2D());
                SVGModel model = this.svgCanvas.getSVGModel();
                SVGDocument doc = model.getSVGDocument();
                Element ele = doc.createElementNS("http://www.w3.org/2000/svg", "ellipse");
                ele.setAttributeNS(null, "cx", SVGGeomUtilities.doubleString(elllipse.getCenterX()));
                ele.setAttributeNS(null, "cy", SVGGeomUtilities.doubleString(elllipse.getCenterY()));
                ele.setAttributeNS(null, "rx", SVGGeomUtilities.doubleString(((RectangularShape)elllipse).getWidth() / 2.0));
                ele.setAttributeNS(null, "ry", SVGGeomUtilities.doubleString(((RectangularShape)elllipse).getHeight() / 2.0));
                ele.setAttributeNS(null, "style", SVGRendererUtilities.SHAPE_DEFAULT_STYLE);
                model.addEntities(new NodeSelection(ele));
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        this.shape = null;
        this.svgCanvas.repaint();
    }

    public void mouseMoved(MouseEvent e) {
        this.svgCanvas.setCursor(Cursor.getPredefinedCursor(1));
    }
}

