/*
 * Decompiled with CFR 0.152.
 */
package imhotep.editor.canvas;

import imhotep.editor.canvas.Canvas;
import imhotep.model.SVGModel;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.HashMap;
import java.util.Map;

public class OverlaySelection {
    private Canvas canvas;
    private boolean isVisible;
    private double insets = 3.0;
    private Stroke stroke;
    private Paint paint;
    private Map border;
    private Map handle;

    public OverlaySelection(Canvas canvas) {
        this.canvas = canvas;
        this.stroke = this.createStroke();
        this.paint = this.createPaint();
        this.border = this.createBorder();
        this.handle = this.createHandle();
        this.isVisible = true;
    }

    public boolean isVisible() {
        return this.isVisible;
    }

    public void setVisible(boolean isVisible) {
        this.isVisible = isVisible;
    }

    private Map createHandle() {
        HashMap<String, Point2D.Double> m = new HashMap<String, Point2D.Double>();
        int i = 0;
        while (i <= 9) {
            Point2D.Double r = new Point2D.Double();
            m.put(Integer.toString(i), r);
            ++i;
        }
        return m;
    }

    private Map createBorder() {
        HashMap<String, Rectangle2D.Double> m = new HashMap<String, Rectangle2D.Double>();
        int i = 0;
        while (i <= 9) {
            Rectangle2D.Double r = new Rectangle2D.Double();
            m.put(Integer.toString(i), r);
            ++i;
        }
        return m;
    }

    private Stroke createStroke() {
        return new BasicStroke(1.0f, 0, 0, 10.0f, new float[]{4.0f}, 0.0f);
    }

    private Paint createPaint() {
        return Color.BLACK;
    }

    public void update() {
        if (!this.isVisible) {
            return;
        }
        SVGModel model = this.canvas.getSVGModel();
        AffineTransform at = this.canvas.getRenderingTransform();
        Rectangle2D area = model.getSelectedOutline(at).getBounds2D();
        Point2D p1 = (Point2D)this.handle.get(Integer.toString(1));
        Point2D p2 = (Point2D)this.handle.get(Integer.toString(2));
        Point2D p3 = (Point2D)this.handle.get(Integer.toString(3));
        Point2D p4 = (Point2D)this.handle.get(Integer.toString(4));
        Point2D p5 = (Point2D)this.handle.get(Integer.toString(5));
        Point2D p6 = (Point2D)this.handle.get(Integer.toString(6));
        Point2D p7 = (Point2D)this.handle.get(Integer.toString(7));
        Point2D p8 = (Point2D)this.handle.get(Integer.toString(8));
        Point2D p9 = (Point2D)this.handle.get(Integer.toString(9));
        Rectangle2D b0 = (Rectangle2D)this.border.get(Integer.toString(0));
        Rectangle2D b1 = (Rectangle2D)this.border.get(Integer.toString(1));
        Rectangle2D b2 = (Rectangle2D)this.border.get(Integer.toString(2));
        Rectangle2D b3 = (Rectangle2D)this.border.get(Integer.toString(3));
        Rectangle2D b4 = (Rectangle2D)this.border.get(Integer.toString(4));
        Rectangle2D b5 = (Rectangle2D)this.border.get(Integer.toString(5));
        Rectangle2D b6 = (Rectangle2D)this.border.get(Integer.toString(6));
        Rectangle2D b7 = (Rectangle2D)this.border.get(Integer.toString(7));
        Rectangle2D b8 = (Rectangle2D)this.border.get(Integer.toString(8));
        Rectangle2D b9 = (Rectangle2D)this.border.get(Integer.toString(9));
        double cx = area.getCenterX();
        double cy = area.getCenterY();
        double mx = area.getMaxX();
        double my = area.getMaxY();
        double nx = area.getMinX();
        double ny = area.getMinY();
        double w = area.getWidth();
        double h = area.getHeight();
        if (w == 0.0 && h == 0.0) {
            p1.setLocation(0.0, 0.0);
            p2.setLocation(0.0, 0.0);
            p3.setLocation(0.0, 0.0);
            p4.setLocation(0.0, 0.0);
            p5.setLocation(0.0, 0.0);
            p6.setLocation(0.0, 0.0);
            p7.setLocation(0.0, 0.0);
            p8.setLocation(0.0, 0.0);
            p9.setLocation(0.0, 0.0);
            b0.setFrame(0.0, 0.0, 0.0, 0.0);
            b1.setFrame(0.0, 0.0, 0.0, 0.0);
            b2.setFrame(0.0, 0.0, 0.0, 0.0);
            b3.setFrame(0.0, 0.0, 0.0, 0.0);
            b4.setFrame(0.0, 0.0, 0.0, 0.0);
            b5.setFrame(0.0, 0.0, 0.0, 0.0);
            b6.setFrame(0.0, 0.0, 0.0, 0.0);
            b7.setFrame(0.0, 0.0, 0.0, 0.0);
            b8.setFrame(0.0, 0.0, 0.0, 0.0);
            b9.setFrame(0.0, 0.0, 0.0, 0.0);
        } else {
            p1.setLocation(nx, ny);
            p2.setLocation(cx, ny);
            p3.setLocation(mx, ny);
            p4.setLocation(nx, cy);
            p5.setLocation(cx, cy);
            p6.setLocation(mx, cy);
            p7.setLocation(nx, my);
            p8.setLocation(cx, my);
            p9.setLocation(mx, my);
            b0.setRect(area.getX() - this.insets, area.getY() - this.insets, area.getWidth() + this.insets * 2.0, area.getHeight() + this.insets * 2.0);
            b1.setFrameFromCenter(nx - this.insets, ny - this.insets, nx, ny);
            b2.setFrameFromCenter(cx, ny - this.insets, cx - this.insets, ny);
            b3.setFrameFromCenter(mx + this.insets, ny - this.insets, mx, ny);
            b4.setFrameFromCenter(nx - this.insets, cy, nx, cy + this.insets);
            b5.setFrameFromCenter(cx, cy, cx + this.insets, cy + this.insets);
            b6.setFrameFromCenter(mx + this.insets, cy, mx, cy + this.insets);
            b7.setFrameFromCenter(nx - this.insets, my + this.insets, nx, my);
            b8.setFrameFromCenter(cx, my + this.insets, cx + this.insets, my);
            b9.setFrameFromCenter(mx + this.insets, my + this.insets, mx, my);
        }
    }

    public void paint(Graphics2D g2) {
        if (!this.isVisible) {
            return;
        }
        Paint orgPaint = g2.getPaint();
        Stroke orgStroke = g2.getStroke();
        g2.setPaint(this.paint);
        g2.setStroke(this.stroke);
        Rectangle2D b = (Rectangle2D)this.border.get(Integer.toString(0));
        g2.draw(b);
        g2.setStroke(orgStroke);
        g2.setPaint(orgPaint);
    }

    public int getHandleNumber(Point2D p) {
        int i = 0;
        while (i <= 9) {
            Rectangle2D r = (Rectangle2D)this.border.get(Integer.toString(i));
            if (r.contains(p)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    private int getHandleNumber(Point2D p, boolean includeArea) {
        if (includeArea) {
            int i = 0;
            while (i <= 9) {
                Rectangle2D r = (Rectangle2D)this.border.get(Integer.toString(i));
                if (r.contains(p)) {
                    return i;
                }
                ++i;
            }
        } else {
            int i = 9;
            while (i >= 0) {
                Rectangle2D r = (Rectangle2D)this.border.get(Integer.toString(i));
                if (r.contains(p)) {
                    return i;
                }
                --i;
            }
        }
        return -1;
    }

    public Point2D getHandlePoint(int num) {
        try {
            Point2D p = (Point2D)this.handle.get(Integer.toString(num));
            return p;
        }
        catch (Exception e) {
            return null;
        }
    }

    public Rectangle2D getHandleBounds(int num) {
        try {
            Rectangle2D r = (Rectangle2D)this.border.get(Integer.toString(num));
            return r;
        }
        catch (Exception e) {
            return null;
        }
    }
}

