/*
 * Decompiled with CFR 0.152.
 */
package imhotep.editor.canvas;

import core.xml.DOMWriterWrapper;
import imhotep.editor.canvas.Canvas;
import imhotep.model.SVGModel;
import imhotep.util.NodeSelection;
import imhotep.util.SVGBuilderWrapper;
import imhotep.util.SVGTransformSupport;
import java.awt.Point;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.event.ActionEvent;
import java.awt.event.InputEvent;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.io.File;
import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.TransferHandler;
import org.w3c.dom.Node;
import org.w3c.dom.svg.SVGDocument;

public class DnDHandler
extends TransferHandler
implements DropTargetListener {
    private Point importPoint;
    private NodeSelection importNodes;
    public int PASTE = 555;
    private static Action cutAction = new CutAction();
    private static Action copyAction = new CopyAction();
    private static Action deleteAction = new DeleteAction();
    private static Action pasteAction = new PasteAction();
    private static Action undoAction = new UndoAction();
    private static Action redoAction = new RedoAction();
    private static Action selectAllAction = new SelectAllAction();

    public boolean canImport(JComponent comp, DataFlavor[] transferFlavors) {
        int i = 0;
        while (i < transferFlavors.length) {
            if (DataFlavor.stringFlavor.equals(transferFlavors[i])) {
                return true;
            }
            if (DataFlavor.javaFileListFlavor.equals(transferFlavors[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public boolean importData(JComponent comp, Transferable t) {
        Canvas canvas = (Canvas)comp;
        SVGModel model = canvas.getSVGModel();
        try {
            SVGDocument importDoc = this.toDocument(t);
            this.importNodes = model.importDocument(importDoc);
            if (this.importNodes.getLength() == 0) {
                return false;
            }
            int tx = 5;
            int ty = 5;
            if (this.importPoint != null) {
                Point2D.Float p = new Point2D.Float();
                AffineTransform at = canvas.getRenderingTransform();
                at.inverseTransform(this.importPoint, p);
                tx = (int)((Point2D)p).getX();
                ty = (int)((Point2D)p).getY();
            }
            AffineTransform translate = AffineTransform.getTranslateInstance(tx, ty);
            int i = 0;
            while (i < this.importNodes.getLength()) {
                SVGTransformSupport.setTransform(this.importNodes.item(i), translate);
                ++i;
            }
            this.exportDone(comp, t, this.PASTE);
            this.exportToClipboard(comp, comp.getToolkit().getSystemClipboard(), 1);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public void exportAsDrag(JComponent comp, InputEvent e, int action) {
        super.exportAsDrag(comp, e, action);
    }

    public void exportToClipboard(JComponent comp, Clipboard clip, int action) {
        super.exportToClipboard(comp, clip, action);
    }

    public void exportDone(JComponent source, Transferable data, int action) {
        try {
            Canvas c = (Canvas)source;
            SVGModel model = c.getSVGModel();
            NodeSelection nodes = model.getSelectedNodes();
            if (action == 2) {
                model.removeEntities(nodes);
            } else if (action != 1 && action == this.PASTE) {
                model.addEntities(this.importNodes);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public int getSourceActions(JComponent comp) {
        return 3;
    }

    protected Transferable createTransferable(JComponent c) {
        Canvas canvas = (Canvas)c;
        SVGModel model = canvas.getSVGModel();
        NodeSelection nodes = model.getSelectedNodes();
        try {
            SVGDocument exportDoc = model.exportDocument(nodes);
            Transferable t = this.toTransferable(exportDoc);
            return t;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private Transferable toTransferable(SVGDocument doc) throws IOException {
        StringWriter w = new StringWriter();
        DOMWriterWrapper.write((Node)doc, w);
        w.flush();
        w.close();
        return new StringSelection(w.toString());
    }

    private SVGDocument toDocument(Transferable t) throws UnsupportedFlavorException, IOException {
        SVGDocument importDoc = null;
        if (t.isDataFlavorSupported(DataFlavor.stringFlavor)) {
            String data = (String)t.getTransferData(DataFlavor.stringFlavor);
            StringReader reader = new StringReader(data);
            importDoc = SVGBuilderWrapper.parse(reader);
        } else if (t.isDataFlavorSupported(DataFlavor.javaFileListFlavor)) {
            List data = (List)t.getTransferData(DataFlavor.javaFileListFlavor);
            File file = (File)data.get(0);
            importDoc = SVGBuilderWrapper.parse(file);
        }
        return importDoc;
    }

    private void convertDocument(SVGDocument importDoc) {
    }

    public void dragEnter(DropTargetDragEvent dtde) {
        this.importPoint = dtde.getLocation();
    }

    public void dragOver(DropTargetDragEvent dtde) {
        this.importPoint = dtde.getLocation();
    }

    public void drop(DropTargetDropEvent dtde) {
        this.importPoint = null;
    }

    public void dragExit(DropTargetEvent dte) {
        this.importPoint = null;
    }

    public void dropActionChanged(DropTargetDragEvent dtde) {
    }

    public static Action getCutAction() {
        return cutAction;
    }

    public static Action getCopyAction() {
        return copyAction;
    }

    public static Action getDeleteAction() {
        return deleteAction;
    }

    public static Action getPasteAction() {
        return pasteAction;
    }

    public static Action getUndoAction() {
        return undoAction;
    }

    public static Action getRedoAction() {
        return redoAction;
    }

    public static Action getSelectAllAction() {
        return selectAllAction;
    }

    private static class CutAction
    extends AbstractAction {
        CutAction() {
        }

        public void actionPerformed(ActionEvent e) {
            if (!(e.getSource() instanceof Canvas)) {
                return;
            }
            JComponent c = (JComponent)e.getSource();
            DnDHandler th = (DnDHandler)c.getTransferHandler();
            Clipboard clipboard = c.getToolkit().getSystemClipboard();
            th.exportToClipboard(c, clipboard, 2);
        }
    }

    private static class CopyAction
    extends AbstractAction {
        CopyAction() {
        }

        public void actionPerformed(ActionEvent e) {
            if (!(e.getSource() instanceof Canvas)) {
                return;
            }
            JComponent c = (JComponent)e.getSource();
            DnDHandler th = (DnDHandler)c.getTransferHandler();
            Clipboard clipboard = c.getToolkit().getSystemClipboard();
            th.exportToClipboard(c, clipboard, 1);
        }
    }

    private static class DeleteAction
    extends AbstractAction {
        DeleteAction() {
        }

        public void actionPerformed(ActionEvent e) {
            if (!(e.getSource() instanceof Canvas)) {
                return;
            }
            JComponent c = (JComponent)e.getSource();
            DnDHandler th = (DnDHandler)c.getTransferHandler();
            th.exportDone(c, null, 2);
        }
    }

    private static class PasteAction
    extends AbstractAction {
        PasteAction() {
        }

        public void actionPerformed(ActionEvent e) {
            if (!(e.getSource() instanceof Canvas)) {
                return;
            }
            JComponent c = (JComponent)e.getSource();
            DnDHandler th = (DnDHandler)c.getTransferHandler();
            Clipboard clipboard = c.getToolkit().getSystemClipboard();
            Transferable trans = clipboard.getContents(null);
            th.importData(c, trans);
        }
    }

    private static class UndoAction
    extends AbstractAction {
        UndoAction() {
        }

        public void actionPerformed(ActionEvent e) {
            if (!(e.getSource() instanceof Canvas)) {
                return;
            }
            Canvas c = (Canvas)e.getSource();
            SVGModel model = c.getSVGModel();
            model.getCanvasUndoManager().undo();
        }
    }

    private static class RedoAction
    extends AbstractAction {
        RedoAction() {
        }

        public void actionPerformed(ActionEvent e) {
            if (!(e.getSource() instanceof Canvas)) {
                return;
            }
            Canvas c = (Canvas)e.getSource();
            SVGModel model = c.getSVGModel();
            model.getCanvasUndoManager().redo();
        }
    }

    private static class SelectAllAction
    extends AbstractAction {
        SelectAllAction() {
        }

        public void actionPerformed(ActionEvent e) {
            if (!(e.getSource() instanceof Canvas)) {
                return;
            }
            Canvas c = (Canvas)e.getSource();
            SVGModel model = c.getSVGModel();
            NodeSelection nodes = model.getNodesAt(c.getRenderingTransform());
            if (nodes != null) {
                model.setSelectedNodes(nodes);
            }
        }
    }
}

