/*
 * Decompiled with CFR 0.152.
 */
package imhotep.editor;

import core.swing.CommandManager;
import core.swing.JMDIDesktopPane;
import core.swing.ResourceManager;
import imhotep.editor.SVGEditor;
import imhotep.editor.SVGEditorEvent;
import imhotep.editor.SVGEditorListener;
import imhotep.model.SVGModel;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.event.InputEvent;
import java.beans.PropertyVetoException;
import java.io.File;
import java.util.AbstractList;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.swing.JComponent;
import javax.swing.JInternalFrame;
import javax.swing.TransferHandler;
import javax.swing.event.EventListenerList;
import javax.swing.event.InternalFrameEvent;
import javax.swing.event.InternalFrameListener;

public class SVGEditorDesktop
extends JMDIDesktopPane
implements InternalFrameListener {
    protected SVGModel selectedModel;
    protected Vector frames;
    protected EventListenerList listenerList = new EventListenerList();
    public static int CASCADE_RESET_TYPE = 0;
    public static int VERTICALLY_TYPE = 1;
    public static int HORIZONTALLY_TYPE = 2;
    static /* synthetic */ Class class$0;

    public SVGEditorDesktop() {
        this.frames = new Vector();
    }

    public ResourceManager resource() {
        return null;
    }

    public CommandManager commands() {
        return null;
    }

    public SVGEditor[] editors() {
        Object[] editors = new SVGEditor[this.frames.size()];
        this.frames.copyInto(editors);
        return editors;
    }

    public SVGEditor editor() {
        return (SVGEditor)super.getSelectedFrame();
    }

    public void tool(int index) {
        int i = 0;
        while (i < this.frames.size()) {
            ((SVGEditor)this.frames.get(i)).tool(index);
            ++i;
        }
    }

    public void addModel(SVGModel model) {
        SVGEditor pane = new SVGEditor();
        pane.setSVGModel(model);
        pane.addInternalFrameListener(this);
        super.add(pane);
    }

    public void removeModel() {
        SVGEditor pane = (SVGEditor)super.getSelectedFrame();
        pane.dispose();
        super.remove(pane);
        this.updateSelectedFrame();
        super.revalidate();
        super.repaint();
    }

    public void removeModel(SVGModel model) {
        this.removeModel();
    }

    public boolean contains(SVGModel model) {
        Iterator it = ((AbstractList)this.frames).iterator();
        String newName = model.getName();
        String name = null;
        while (it.hasNext()) {
            name = ((SVGEditor)it.next()).getSVGModel().getName();
            if (!newName.equals(name)) continue;
            return true;
        }
        return false;
    }

    public int count() {
        return this.frames.size();
    }

    public void reset(int type) {
        if (type == CASCADE_RESET_TYPE) {
            super.cascadeFrames();
        } else if (type == VERTICALLY_TYPE) {
            super.verticalTileFrames();
        } else if (type == HORIZONTALLY_TYPE) {
            super.horizontalTileFrames();
        }
    }

    public void setSelectedModel(SVGModel model) {
        Iterator it = ((AbstractList)this.frames).iterator();
        SVGEditor f = null;
        while (it.hasNext()) {
            f = (SVGEditor)it.next();
            if (!f.getSVGModel().equals(model)) continue;
            try {
                f.setSelected(true);
            }
            catch (PropertyVetoException e) {
                e.printStackTrace();
            }
            break;
        }
    }

    public SVGModel getSelectedModel() {
        return this.selectedModel;
    }

    public void dropFile(File f) {
    }

    public void addSVGEditorListener(SVGEditorListener l) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("imhotep.editor.SVGEditorListener");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.listenerList.add(clazz, l);
    }

    public void removeSVGEditorListener(SVGEditorListener l) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("imhotep.editor.SVGEditorListener");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.listenerList.remove(clazz, l);
    }

    public JInternalFrame[] getAllFrames() {
        try {
            Object[] results = new JInternalFrame[this.frames.size()];
            this.frames.copyInto(results);
            return results;
        }
        catch (Exception e) {
            return super.getAllFrames();
        }
    }

    protected void updateSelectedFrame() {
        try {
            SVGEditor selected = (SVGEditor)this.frames.lastElement();
            selected.setSelected(true);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void internalFrameActivated(InternalFrameEvent e) {
        SVGEditor pane = (SVGEditor)e.getInternalFrame();
        if (!this.frames.contains(pane)) {
            this.frames.add(pane);
            this.fireEditorAdded(pane);
        }
        SVGModel model = pane.getSVGModel();
        model.setState(pane.state());
        this.selectedModel = model;
    }

    public void internalFrameDeactivated(InternalFrameEvent e) {
        SVGEditor pane = (SVGEditor)e.getInternalFrame();
        SVGModel model = pane.getSVGModel();
        model.setState(-1);
        this.selectedModel = null;
    }

    public void internalFrameOpened(InternalFrameEvent e) {
    }

    public void internalFrameClosed(InternalFrameEvent e) {
        SVGEditor pane = (SVGEditor)e.getInternalFrame();
        if (this.frames.contains(pane)) {
            this.frames.remove(pane);
            this.fireEditorRemoved(pane);
        }
    }

    public void internalFrameClosing(InternalFrameEvent e) {
    }

    public void internalFrameIconified(InternalFrameEvent e) {
    }

    public void internalFrameDeiconified(InternalFrameEvent e) {
    }

    protected void fireEditorAdded(SVGEditor editor) {
        System.out.println("\n\t\t### fireEditorAdded");
        SVGEditorEvent evt = null;
        Object[] listeners = this.listenerList.getListenerList();
        int i = listeners.length - 2;
        while (i >= 0) {
            Object object = listeners[i];
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = Class.forName("imhotep.editor.SVGEditorListener");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if (object == clazz) {
                if (evt == null) {
                    evt = new SVGEditorEvent(this, editor);
                }
                ((SVGEditorListener)listeners[i + 1]).editorAdded(evt);
            }
            i -= 2;
        }
    }

    protected void fireEditorRemoved(SVGEditor editor) {
        System.out.println("\n\t\t### fireEditorRemoved");
        SVGEditorEvent evt = null;
        Object[] listeners = this.listenerList.getListenerList();
        int i = listeners.length - 2;
        while (i >= 0) {
            Object object = listeners[i];
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = Class.forName("imhotep.editor.SVGEditorListener");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if (object == clazz) {
                if (evt == null) {
                    evt = new SVGEditorEvent(this, editor);
                }
                ((SVGEditorListener)listeners[i + 1]).editorRemoved(evt);
            }
            i -= 2;
        }
    }

    public class DnDHandler
    extends TransferHandler {
        public boolean canImport(JComponent comp, DataFlavor[] transferFlavors) {
            int i = 0;
            while (i < transferFlavors.length) {
                if (DataFlavor.javaFileListFlavor.equals(transferFlavors[i])) {
                    return true;
                }
                ++i;
            }
            return false;
        }

        public boolean importData(JComponent comp, Transferable t) {
            List files = null;
            try {
                files = (List)t.getTransferData(DataFlavor.javaFileListFlavor);
                Iterator it = files.iterator();
                File f = null;
                while (it.hasNext()) {
                    f = (File)it.next();
                    SVGEditorDesktop.this.dropFile(f);
                }
                return true;
            }
            catch (Exception e) {
                e.printStackTrace();
                return false;
            }
        }

        public void exportAsDrag(JComponent comp, InputEvent e, int action) {
        }

        public void exportToClipboard(JComponent comp, Clipboard clip, int action) {
        }

        public int getSourceActions(JComponent c) {
            return 1;
        }

        protected Transferable createTransferable(JComponent comp) {
            return null;
        }

        protected void exportDone(JComponent comp, Transferable data, int action) {
        }
    }
}

