/*
 * Decompiled with CFR 0.152.
 */
package imhotep.editor;

import core.swing.CommandManager;
import core.swing.ResourceManager;
import imhotep.editor.canvas.Canvas;
import imhotep.editor.preview.Preview;
import imhotep.editor.source.Source;
import imhotep.menu.MenuBar;
import imhotep.model.SVGModel;
import imhotep.model.SVGModelEvent;
import imhotep.model.SVGModelListener;
import imhotep.util.SVGBuilderWrapper;
import java.awt.BorderLayout;
import java.awt.Component;
import java.beans.PropertyVetoException;
import java.io.StringReader;
import javax.swing.JComponent;
import javax.swing.JInternalFrame;
import javax.swing.JPopupMenu;
import javax.swing.JTabbedPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.w3c.dom.svg.SVGDocument;

public class SVGEditor
extends JInternalFrame
implements ChangeListener,
SVGModelListener {
    private static String RESOURCES = "imhotep.editor.resources.SVGEditor";
    private static ResourceManager bundle = ResourceManager.getBundle(RESOURCES);
    private static CommandManager commands = CommandManager.getSystemBundle();
    protected SVGModel svgModel;
    protected JTabbedPane tab;
    protected Canvas canvas;
    protected Source source;
    protected Preview preview;

    public SVGEditor() {
        this.initializeComponent();
    }

    public ResourceManager resource() {
        return bundle;
    }

    public CommandManager commands() {
        return commands;
    }

    protected void initializeComponent() {
        JComponent contents = this.createContentsComponent();
        super.setResizable(true);
        super.setClosable(true);
        super.setMaximizable(true);
        super.setIconifiable(true);
        super.getContentPane().setLayout(new BorderLayout());
        super.getContentPane().add((Component)contents, "Center");
    }

    protected JComponent createContentsComponent() {
        String canvasLabel = bundle.getString("CanvasTab.title");
        String sourceLabel = bundle.getString("SourceTab.title");
        String previewLabel = bundle.getString("PreviewTab.title");
        this.canvas = new Canvas();
        this.source = new Source();
        this.preview = new Preview();
        this.tab = new JTabbedPane(){

            public void setSelectedIndex(int i) {
                if (SVGEditor.this.updateDocument()) {
                    super.setSelectedIndex(i);
                }
            }
        };
        this.tab.putClientProperty("jgoodies.noContentBorder", Boolean.TRUE);
        this.tab.addTab(canvasLabel, this.canvas.getExtComponent());
        this.tab.addTab(sourceLabel, this.source.getExtComponent());
        this.tab.addTab(previewLabel, this.preview.getExtComponent());
        this.tab.setSelectedIndex(0);
        this.tab.addChangeListener(this);
        return this.tab;
    }

    public void doDefaultCloseAction() {
        try {
            super.setSelected(true);
            commands.getCommand("imhotep.menu.file.Close").actionPerformed(this);
        }
        catch (PropertyVetoException e) {
            e.printStackTrace();
        }
    }

    public void dispose() {
        this.canvas.dispose();
        this.source.dispose();
        this.preview.dispose();
        super.dispose();
    }

    public void setSVGModel(SVGModel model) {
        this.svgModel = model;
        this.canvas.setSVGModel(this.svgModel);
        this.source.setSVGModel(this.svgModel);
        this.preview.setSVGModel(this.svgModel);
        this.svgModel.addSVGModelListener(this);
        this.canvas.active();
    }

    public SVGModel getSVGModel() {
        return this.svgModel;
    }

    public JComponent getStateOwner() {
        int s = this.state();
        if (s == 0) {
            return this.canvas;
        }
        if (s == 1) {
            return this.source;
        }
        if (s == 2) {
            return this.preview;
        }
        return null;
    }

    public int state() {
        return this.tab.getSelectedIndex();
    }

    public int state(int i) {
        this.tab.setSelectedIndex(i);
        return this.tab.getSelectedIndex();
    }

    public void tool(int index) {
        this.canvas.setTool(index);
    }

    public void popup(MenuBar popup) {
        if (!(popup instanceof JPopupMenu)) {
            return;
        }
        JPopupMenu menu = (JPopupMenu)((Object)popup);
        String title = popup.getTitle();
        if (title.equals(bundle.getString("CanvasTab.title"))) {
            this.canvas.initPopup(menu);
        } else if (title.equals(bundle.getString("SourceTab.title"))) {
            this.source.initPopup(menu);
        } else if (title.equals(bundle.getString("PreviewTab.title"))) {
            this.preview.initPopup(menu);
        }
    }

    private boolean updateDocument() {
        if (this.tab.getSelectedIndex() == 1 && this.source.isSourceChanged()) {
            try {
                SVGDocument doc = SVGBuilderWrapper.parse(new StringReader(this.source.getText()));
                this.svgModel.changeDocument(doc);
                this.source.removeErrorMessage();
                return true;
            }
            catch (Exception e) {
                e.printStackTrace();
                this.source.setErrorMessage(e.getMessage());
                return false;
            }
        }
        return true;
    }

    public void stateChanged(ChangeEvent e) {
        int i = this.tab.getSelectedIndex();
        this.svgModel.setState(i);
        if (i == 0) {
            this.source.dispose();
            this.preview.dispose();
        } else if (i == 1) {
            this.source.active();
            this.preview.dispose();
        } else {
            this.source.dispose();
            this.preview.active();
        }
    }

    public void stateChanged(SVGModelEvent evt) {
        super.setTitle(this.svgModel.getTitle());
    }

    public void documentChanged(SVGModelEvent evt) {
        super.setTitle(this.svgModel.getTitle());
        this.canvas.active();
    }

    public void layerChanged(SVGModelEvent evt) {
    }

    public void selectionChanged(SVGModelEvent evt) {
        if (this.state() == 0) {
            this.canvas.overlay();
        }
    }

    public void zoomChanged(SVGModelEvent evt) {
        super.setTitle(this.svgModel.getTitle());
        this.canvas.zoom();
    }

    public void undoChanged(SVGModelEvent evt) {
        if (this.state() == 0) {
            this.canvas.refresh();
        }
    }
}

