/*
 * Decompiled with CFR 0.152.
 */
package imhotep.dom;

import core.swing.CommandManager;
import core.swing.ResourceManager;
import imhotep.dom.DomTool;
import imhotep.dom.DomTree;
import imhotep.editor.SVGEditorEvent;
import imhotep.editor.SVGPalette;
import imhotep.model.SVGModelEvent;
import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

public class DomPalette
extends SVGPalette {
    private static CommandManager commands = CommandManager.getSystemBundle();
    protected DomTree domTree;
    protected DomTool domTool;

    public DomPalette(JFrame f) {
        super(f);
        super.setTitle(this.domTree.getTitle());
    }

    public ResourceManager resource() {
        return null;
    }

    public CommandManager commands() {
        return commands;
    }

    public void doCloseAction() {
        commands.getCommand("imhotep.menu.view.ViewDom").actionPerformed(this);
    }

    protected JComponent createContentsComponent() {
        this.domTree = new DomTree();
        this.domTool = new DomTool(this.domTree.getActionMap());
        JPanel contents = new JPanel(new BorderLayout());
        contents.add((Component)this.domTool, "North");
        contents.add((Component)new JScrollPane(this.domTree), "Center");
        return contents;
    }

    public void editorAdded(SVGEditorEvent evt) {
        evt.getEditor().getSVGModel().addSVGModelListener(this);
    }

    public void editorRemoved(SVGEditorEvent evt) {
        evt.getEditor().getSVGModel().removeSVGModelListener(this);
        this.domTree.setSVGModel(null);
    }

    public void stateChanged(SVGModelEvent evt) {
        this.domTree.setSVGModel(evt.getSVGModel());
        this.domTree.processSelection();
    }

    public void documentChanged(SVGModelEvent evt) {
        this.domTree.setSVGModel(evt.getSVGModel());
        this.domTree.processSelection();
    }

    public void layerChanged(SVGModelEvent evt) {
        this.domTree.setSVGModel(evt.getSVGModel());
        this.domTree.processSelection();
    }

    public void selectionChanged(SVGModelEvent evt) {
        this.domTree.processSelection();
    }

    public void zoomChanged(SVGModelEvent evt) {
    }

    public void undoChanged(SVGModelEvent evt) {
        this.domTree.setSVGModel(evt.getSVGModel());
        this.domTree.processSelection();
    }
}

