/*
 * Decompiled with CFR 0.152.
 */
package core.swing;

import com.jgoodies.forms.factories.Borders;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;

public abstract class JFormDialog
extends JPanel {
    public static final int CANCEL_OPTION = 1;
    public static final int APPROVE_OPTION = 0;
    public static final int ERROR_OPTION = -1;
    protected JButton approveButton;
    protected JButton cancelButton;
    protected JDialog dialog;
    protected String dialogTitle;
    protected int returnValue = -1;
    static /* synthetic */ Class class$0;

    public JFormDialog() {
        JComponent contents = this.createContentsPanel();
        JComponent buttons = this.createButtonsPanel();
        FormLayout layout = new FormLayout("p", "p, 4dlu, p");
        CellConstraints cc = new CellConstraints();
        super.setLayout((LayoutManager)layout);
        super.setBorder(Borders.DIALOG_BORDER);
        super.add((Component)contents, cc.xy(1, 1));
        super.add((Component)buttons, cc.xy(1, 3));
        this.initializeContents();
    }

    protected abstract void initializeContents();

    protected abstract JComponent createContentsPanel();

    protected abstract void prepareContents();

    protected JComponent createButtonsPanel() {
        this.approveButton = new JButton();
        this.approveButton.setText(UIManager.getString((Object)"OptionPane.okButtonText", super.getLocale()));
        this.approveButton.setMnemonic(UIManager.getInt("OptionPane.okButtonMnemonic"));
        this.approveButton.setToolTipText(UIManager.getString((Object)"OptionPane.okButtonText", super.getLocale()));
        this.approveButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                JFormDialog.this.approveSelection();
            }
        });
        this.cancelButton = new JButton();
        this.cancelButton.setText(UIManager.getString((Object)"OptionPane.cancelButtonText", super.getLocale()));
        this.cancelButton.setMnemonic(UIManager.getInt("OptionPane.cancelButtonMnemonic"));
        this.cancelButton.setToolTipText(UIManager.getString((Object)"OptionPane.cancelButtonText", super.getLocale()));
        this.cancelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                JFormDialog.this.cancelSelection();
            }
        });
        JPanel buttonBar = new JPanel((LayoutManager)new FormLayout("0:grow, p, 4px, p", "p"));
        buttonBar.add((Component)this.approveButton, "2, 1");
        buttonBar.add((Component)this.cancelButton, "4, 1");
        return buttonBar;
    }

    public void addActionListener(ActionListener l) {
        this.approveButton.addActionListener(l);
        this.cancelButton.addActionListener(l);
    }

    public void removeActionListener(ActionListener l) {
        this.approveButton.removeActionListener(l);
        this.cancelButton.removeActionListener(l);
    }

    public void setApproveButtonMnemonic(char mnemonic) {
        this.approveButton.setMnemonic(mnemonic);
    }

    public void setApproveButtonMnemonic(int mnemonic) {
        this.approveButton.setMnemonic(mnemonic);
    }

    public void setApproveButtonText(String approveButtonText) {
        this.approveButton.setText(approveButtonText);
    }

    public void setApproveButtonToolTipText(String toolTipText) {
        this.approveButton.setToolTipText(toolTipText);
    }

    public int getApproveButtonMnemonic() {
        return this.approveButton.getMnemonic();
    }

    public String getApproveButtonText() {
        return this.approveButton.getText();
    }

    public String getApproveButtonToolTipText() {
        return this.approveButton.getToolTipText();
    }

    public void approveSelection() {
        this.returnValue = 0;
        if (this.dialog != null) {
            ((Component)this.dialog).setVisible(false);
        }
    }

    public void cancelSelection() {
        this.returnValue = 1;
        if (this.dialog != null) {
            ((Component)this.dialog).setVisible(false);
        }
    }

    public void setDialogTitle(String dialogTitle) {
        this.dialogTitle = dialogTitle;
    }

    public String getDialogTitle() {
        return this.dialogTitle;
    }

    protected JDialog createDialog(Component parent) {
        boolean supportsWindowDecorations;
        Frame frame;
        if (parent instanceof Frame) {
            frame = (Frame)parent;
        } else {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("java.awt.Frame");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            frame = (Frame)SwingUtilities.getAncestorOfClass(clazz, parent);
        }
        Frame frame2 = frame;
        JDialog dialog = new JDialog(frame2, this.dialogTitle, true);
        Container contentPane = dialog.getContentPane();
        contentPane.setLayout(new BorderLayout());
        contentPane.add((Component)this, "Center");
        if (JDialog.isDefaultLookAndFeelDecorated() && (supportsWindowDecorations = UIManager.getLookAndFeel().getSupportsWindowDecorations())) {
            dialog.getRootPane().setWindowDecorationStyle(6);
        }
        dialog.setResizable(false);
        dialog.pack();
        dialog.setLocationRelativeTo(parent);
        return dialog;
    }

    public int showDialog(Component parent) {
        this.prepareContents();
        this.dialog = this.createDialog(parent);
        this.dialog.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                JFormDialog.this.returnValue = 1;
            }
        });
        this.returnValue = -1;
        this.dialog.show();
        this.dialog.dispose();
        this.dialog = null;
        return this.returnValue;
    }
}

