/*
 * Decompiled with CFR 0.152.
 */
package core.swing;

import core.swing.ResourceManager;
import core.swing.chooser.ExampleFileFilter;
import java.io.File;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.filechooser.FileFilter;

public class JFileListChooser
extends JFileChooser {
    protected static String RESOURCES = "core.swing.resources.FileChooser";
    protected static ResourceManager bundle = ResourceManager.getBundle(RESOURCES);

    public JFileListChooser(File file) {
        super(file);
        super.removeChoosableFileFilter(super.getFileFilter());
    }

    public JFileListChooser() {
        super.removeChoosableFileFilter(super.getFileFilter());
    }

    public void setExtension(String extension, String discription) {
        ExampleFileFilter filter = new ExampleFileFilter(extension, discription);
        super.setFileFilter(filter);
    }

    public void setExtension(String[] extensions, String discription) {
        ExampleFileFilter filter = new ExampleFileFilter(extensions, discription);
        super.setFileFilter(filter);
    }

    public void setExtension(FileFilter filter) {
        super.setFileFilter(filter);
    }

    public void addExtension(String extension, String discription) {
        ExampleFileFilter filter = new ExampleFileFilter(extension, discription);
        super.addChoosableFileFilter(filter);
    }

    public void addExtension(String[] extensions, String discription) {
        ExampleFileFilter filter = new ExampleFileFilter(extensions, discription);
        super.addChoosableFileFilter(filter);
    }

    public void addExtension(FileFilter filter) {
        super.addChoosableFileFilter(filter);
    }

    public void clearExtension() {
        super.resetChoosableFileFilters();
    }

    public String getExtension(File f) {
        ExampleFileFilter filter = (ExampleFileFilter)super.getFileFilter();
        if (filter.accept(f)) {
            return filter.getExtension();
        }
        return null;
    }

    public void approveSelection() {
        File file = this.getSelectedFile();
        ExampleFileFilter filter = (ExampleFileFilter)super.getFileFilter();
        if (super.getFileSelectionMode() == 0 && filter != null && !filter.accept(file)) {
            file = new File(String.valueOf(file.toString()) + "." + filter.getExtension());
            this.setSelectedFile(file);
        }
        if (super.getDialogType() == 0) {
            if (file.exists()) {
                super.approveSelection();
            } else {
                String msg = bundle.getString("NoExistDialog.message", new Object[]{file});
                String title = this.getUI().getDialogTitle(this);
                JOptionPane.showMessageDialog(this, msg, title, 2);
            }
        } else if (file.exists()) {
            String title;
            String msg = bundle.getString("OverwriteDialog.message", new Object[]{file});
            int r = JOptionPane.showConfirmDialog(this, msg, title = this.getUI().getDialogTitle(this), 0);
            if (r == 0) {
                this.setSelectedFile(file);
                super.approveSelection();
            }
        } else {
            super.approveSelection();
        }
    }

    public static void main(String[] args) {
        JFrame f = new JFrame();
        f.setDefaultCloseOperation(3);
        f.pack();
        f.show();
        JFileListChooser d = new JFileListChooser(new File("D:/"));
        d.setCurrentDirectory(new File("D:/project-imhotep-rc1/user/library"));
        d.setExtension("svg", "svg");
        while (true) {
            int i = d.showOpenDialog(f);
            i = d.showSaveDialog(f);
            File file = d.getSelectedFile();
            if (file == null) continue;
            System.out.println(file + " : " + file.exists());
        }
    }
}

