/*
 * Decompiled with CFR 0.152.
 */
package core.swing;

import core.swing.ActionEventManager;
import core.swing.CommandListener;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.util.AbstractList;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.event.EventListenerList;

public abstract class Command
extends AbstractAction
implements Runnable {
    public static String OLD_PROPERTY_VALUE = "OLD_PROPERTY_VALUE";
    public static String NEW_PROPERTY_VALUE = "NEW_PROPERTY_VALUE";
    private Vector component = new Vector();
    private boolean executable = true;
    private EventListenerList listenerList = new EventListenerList();
    static /* synthetic */ Class class$0;

    protected Command() {
    }

    protected void beep() {
        Toolkit.getDefaultToolkit().beep();
    }

    public boolean isRunnable() {
        return false;
    }

    public void setExecutable(boolean b) {
        this.executable = b;
    }

    public boolean isExecutable() {
        return this.executable;
    }

    public void setSelected(boolean selected) {
        AbstractButton button = null;
        Iterator it = ((AbstractList)this.component).iterator();
        while (it.hasNext()) {
            button = (AbstractButton)it.next();
            button.setSelected(selected);
        }
    }

    public boolean isSelected() {
        AbstractButton button = null;
        Iterator it = ((AbstractList)this.component).iterator();
        button = (AbstractButton)it.next();
        return button.isSelected();
    }

    public void putValue(String key, Object newValue) {
        if (newValue instanceof AbstractButton) {
            this.component.add(newValue);
        } else {
            super.putValue(key, newValue);
        }
    }

    public void addCommandListener(CommandListener l) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("core.swing.CommandListener");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.listenerList.add(clazz, l);
    }

    public void removeCommandListener(CommandListener l) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("core.swing.CommandListener");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.listenerList.remove(clazz, l);
    }

    private void fireCommandStarted() {
        System.out.println("\n### fireCommandStarted : " + super.getClass().getName());
        Object[] listeners = this.listenerList.getListenerList();
        int i = listeners.length - 2;
        while (i >= 0) {
            Object object = listeners[i];
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = Class.forName("core.swing.CommandListener");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if (object == clazz) {
                ((CommandListener)listeners[i + 1]).commandStarted(this);
            }
            i -= 2;
        }
    }

    private void fireCommandCompleted() {
        System.out.println("\n### fireCommandCompleted : " + super.getClass().getName());
        Object[] listeners = this.listenerList.getListenerList();
        int i = listeners.length - 2;
        while (i >= 0) {
            Object object = listeners[i];
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = Class.forName("core.swing.CommandListener");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if (object == clazz) {
                ((CommandListener)listeners[i + 1]).commandCompleted(this);
            }
            i -= 2;
        }
    }

    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getPropertyName() == this.getClass().getName()) {
            boolean oldExecutable = this.isExecutable();
            if (!oldExecutable) {
                System.out.println("\n### Executable Change : " + super.getClass().getName());
                this.setExecutable(true);
            }
            super.putValue(OLD_PROPERTY_VALUE, evt.getOldValue());
            super.putValue(NEW_PROPERTY_VALUE, evt.getNewValue());
            this.actionPerformed(evt.getSource());
            super.putValue(OLD_PROPERTY_VALUE, null);
            super.putValue(NEW_PROPERTY_VALUE, null);
            if (!oldExecutable) {
                this.setExecutable(oldExecutable);
            }
        }
    }

    public void actionPerformed(Object source) {
        ActionEvent a = ActionEventManager.newActionEvent(source);
        this.actionPerformed(a);
    }

    public void actionPerformed(ActionEvent e) {
        if (this.executable) {
            int r = this.prepare();
            if (r == 0) {
                if (this.isRunnable()) {
                    new Thread(this).start();
                } else {
                    this.run();
                }
            }
        } else {
            System.out.println("\n### Cann't Fire : " + super.getClass().getName());
        }
    }

    public void run() {
        this.fireCommandStarted();
        try {
            Thread.sleep(100L);
            this.execute();
            this.fireCommandCompleted();
        }
        catch (Throwable e) {
            this.fireCommandCompleted();
            this.warning(e);
        }
    }

    public int prepare() {
        return 0;
    }

    public void warning(Throwable e) {
        e.printStackTrace();
    }

    public abstract void execute() throws Throwable;
}

