/*
 * Decompiled with CFR 0.152.
 */
package core.swing;

import com.jgoodies.plaf.HeaderStyle;
import core.swing.ActionBean;
import core.swing.JToolbarSeparator;
import core.xml.DOMBuilderException;
import core.xml.DOMBuilderWrapper;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Insets;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.HashMap;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JRadioButton;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.UIManager;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public class ActionToolBar
extends JToolBar
implements ActionBean {
    protected Document doc;
    protected HashMap groupMap = new HashMap();
    protected ActionMap actionMap;

    public ActionToolBar() {
        super.putClientProperty("JToolBar.isRollover", Boolean.TRUE);
    }

    public ActionToolBar(Document doc) {
        this();
        this.setDocumentModel(doc);
    }

    public ActionToolBar(ActionMap actionMap) {
        this();
        this.actionMap = actionMap;
    }

    public ActionToolBar(Document doc, ActionMap actionMap) {
        this();
        super.getActionMap().setParent(actionMap);
        this.setDocumentModel(doc);
    }

    public void setHeaderStyle() {
        super.putClientProperty("jgoodies.headerStyle", HeaderStyle.SINGLE);
    }

    public void setDocumentUri(URI uri) {
        try {
            this.setDocumentModel(DOMBuilderWrapper.parse(uri));
        }
        catch (DOMBuilderException e) {
            e.printStackTrace();
        }
    }

    public String getTitle() {
        return this.doc.getDocumentElement().getAttribute("title");
    }

    public Document getDocumentModel() {
        return this.doc;
    }

    public void setDocumentModel(Document doc) {
        this.doc = doc;
        if (doc != null) {
            this.initializeJToolBar(doc.getDocumentElement());
        }
    }

    protected void initializeJToolBar(Node node) {
        Node n = node.getFirstChild();
        while (n != null) {
            JComponent comp;
            if (n instanceof Element && (comp = this.createJComponent((Element)n)) != null) {
                this.add(comp);
            }
            n = n.getNextSibling();
        }
    }

    protected JComponent createJComponent(Element e) {
        String type = e.getAttribute("component");
        JComponent item = null;
        item = type.equalsIgnoreCase("button") ? this.createJButton(e) : (type.equalsIgnoreCase("toggle") ? this.createJToggleButton(e) : (type.equalsIgnoreCase("radio") ? this.createJRadioButton(e) : (type.equalsIgnoreCase("check") ? this.createJCheckBox(e) : (type.equalsIgnoreCase("separator") ? this.createJSeparator(e) : this.createNullComponent(e)))));
        return item;
    }

    protected JButton createJButton(Element e) {
        JButton comp = new JButton();
        this.initializeJComponent(comp, e);
        return comp;
    }

    protected JToggleButton createJToggleButton(Element e) {
        JToggleButton comp = new JToggleButton();
        this.initializeJComponent(comp, e);
        return comp;
    }

    protected JRadioButton createJRadioButton(Element e) {
        JRadioButton comp = new JRadioButton();
        this.initializeJComponent(comp, e);
        return comp;
    }

    protected JComponent createJSeparator(Element e) {
        return new JToolbarSeparator();
    }

    protected JCheckBox createJCheckBox(Element e) {
        JCheckBox comp = new JCheckBox();
        this.initializeJComponent(comp, e);
        return comp;
    }

    protected JComponent createNullComponent(Element e) {
        String action = e.getAttribute("action");
        Action a = this.findAction(action);
        return null;
    }

    protected void initializeJComponent(AbstractButton button, Element e) {
        String action = e.getAttribute("action");
        String enabled = e.getAttribute("enabled");
        String text = e.getAttribute("text");
        String mnemonic = e.getAttribute("mnemonic");
        String accelerator = e.getAttribute("action");
        String tip = e.getAttribute("tip");
        String icon = e.getAttribute("icon");
        String name = e.getAttribute("name");
        String group = e.getAttribute("group");
        if (!"".equals(action)) {
            Action a = this.findAction(action);
            if (a != null) {
                a.putValue(name, button);
                button.setAction(a);
                if (!"".equals(enabled)) {
                    a.setEnabled(Boolean.valueOf(enabled));
                } else {
                    a.setEnabled(false);
                }
            } else {
                button.setEnabled(false);
            }
        }
        if (!"".equals(name)) {
            button.setName(name);
        }
        if (!"".equals(text)) {
            button.setText(text);
        }
        if (!"".equals(tip)) {
            button.setToolTipText(tip);
        }
        if (!"".equals(icon)) {
            button.setIcon(this.findIcon(icon));
        }
        if (!"".equals(mnemonic)) {
            button.setMnemonic(mnemonic.charAt(0));
        }
        if (!"".equals(group)) {
            this.initializeButtonGroup(button, group);
        }
        button.setFocusable(false);
        button.setRequestFocusEnabled(false);
        button.setMargin(new Insets(0, 0, 0, 0));
    }

    protected void initializeButtonGroup(AbstractButton b, String groupName) {
        ButtonGroup group = null;
        if (this.groupMap.containsKey(groupName)) {
            group = (ButtonGroup)this.groupMap.get(groupName);
        } else {
            group = new ButtonGroup();
            this.groupMap.put(groupName, group);
        }
        if (group.getButtonCount() == 0) {
            b.setSelected(true);
        }
        group.add(b);
    }

    protected Icon findIcon(String key) {
        Icon icon = UIManager.getIcon(key);
        if (icon == null) {
            icon = new ImageIcon(ClassLoader.getSystemResource(key));
        }
        return icon;
    }

    protected Action findAction(String key) {
        return this.actionMap.get(key);
    }

    public static void main(String[] args) throws ParserConfigurationException, SAXException, IOException {
        File f = new File("src/imhotep/resource/PaletteBar_en_US.xml");
        ActionToolBar b = new ActionToolBar();
        Document doc = DOMBuilderWrapper.parse(f);
        b.setDocumentModel(doc);
        JFrame frame = new JFrame();
        frame.setDefaultCloseOperation(3);
        frame.getContentPane().setLayout(new BorderLayout());
        frame.getContentPane().add((Component)b, "North");
        frame.pack();
        frame.show();
    }
}

