/*
 * Decompiled with CFR 0.152.
 */
package core.swing;

import core.swing.ActionBean;
import core.xml.DOMBuilderException;
import core.xml.DOMBuilderWrapper;
import java.net.URI;
import java.util.HashMap;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JSeparator;
import javax.swing.KeyStroke;
import javax.swing.UIManager;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class ActionMenuBar
extends JMenuBar
implements ActionBean {
    protected Document doc;
    protected HashMap groupMap = new HashMap();
    protected ActionMap actionMap;

    public ActionMenuBar() {
    }

    public ActionMenuBar(Document doc) {
        this.setDocumentModel(doc);
    }

    public ActionMenuBar(ActionMap actionMap) {
        this.actionMap = actionMap;
    }

    public ActionMenuBar(Document doc, ActionMap actionMap) {
        super.getActionMap().setParent(actionMap);
        this.setDocumentModel(doc);
    }

    public void setDocumentUri(URI uri) {
        try {
            this.setDocumentModel(DOMBuilderWrapper.parse(uri));
        }
        catch (DOMBuilderException e) {
            e.printStackTrace();
        }
    }

    public String getTitle() {
        return this.doc.getDocumentElement().getAttribute("title");
    }

    public Document getDocumentModel() {
        return this.doc;
    }

    public void setDocumentModel(Document doc) {
        this.doc = doc;
        if (doc != null) {
            this.initializeJMenuBar(doc.getDocumentElement());
        }
    }

    protected void initializeJMenuBar(Node node) {
        Node n = node.getFirstChild();
        while (n != null) {
            JComponent comp;
            if (n instanceof Element && (comp = this.createJComponent((Element)n)) != null) {
                this.add(comp);
            }
            n = n.getNextSibling();
        }
    }

    protected JComponent createJComponent(Element e) {
        String type = e.getAttribute("component");
        JComponent item = null;
        item = type.equalsIgnoreCase("menu") ? this.createJMenu(e) : (type.equalsIgnoreCase("menuitem") ? this.createJMenuItem(e) : (type.equalsIgnoreCase("button") ? this.createJMenuItem(e) : (type.equalsIgnoreCase("toggle") ? this.createJMenuItem(e) : (type.equalsIgnoreCase("radio") ? this.createJRadioButtonMenuItem(e) : (type.equalsIgnoreCase("check") ? this.createJCheckBoxMenuItem(e) : (type.equalsIgnoreCase("separator") ? this.createJSeparator(e) : this.createNullComponent(e)))))));
        return item;
    }

    protected JMenu createJMenu(Element e) {
        JMenu comp = new JMenu();
        this.initializeJComponent(comp, e);
        Node n = e.getFirstChild();
        while (n != null) {
            JComponent child;
            if (n instanceof Element && (child = this.createJComponent((Element)n)) != null) {
                comp.add(child);
            }
            n = n.getNextSibling();
        }
        return comp;
    }

    protected JMenuItem createJMenuItem(Element e) {
        JMenuItem comp = new JMenuItem();
        this.initializeJComponent(comp, e);
        return comp;
    }

    protected JRadioButtonMenuItem createJRadioButtonMenuItem(Element e) {
        JRadioButtonMenuItem comp = new JRadioButtonMenuItem();
        this.initializeJComponent(comp, e);
        return comp;
    }

    protected JCheckBoxMenuItem createJCheckBoxMenuItem(Element e) {
        JCheckBoxMenuItem comp = new JCheckBoxMenuItem();
        this.initializeJComponent(comp, e);
        return comp;
    }

    protected JComponent createJSeparator(Element e) {
        return new JSeparator();
    }

    protected JComponent createNullComponent(Element e) {
        String action = e.getAttribute("action");
        Action a = this.findAction(action);
        return null;
    }

    protected void initializeJComponent(JMenuItem button, Element e) {
        String action = e.getAttribute("action");
        String enabled = e.getAttribute("enabled");
        String text = e.getAttribute("text");
        String mnemonic = e.getAttribute("mnemonic");
        String accelerator = e.getAttribute("accelerator");
        String tip = e.getAttribute("tip");
        String icon = e.getAttribute("icon");
        String name = e.getAttribute("name");
        String group = e.getAttribute("group");
        if (!"".equals(action)) {
            Action a = this.findAction(action);
            if (a != null) {
                a.putValue(name, button);
                button.setAction(a);
                if (!"".equals(enabled)) {
                    a.setEnabled(Boolean.valueOf(enabled));
                } else {
                    a.setEnabled(false);
                }
            } else {
                button.setEnabled(false);
            }
        }
        if (!"".equals(name)) {
            button.setName(name);
        }
        if (!"".equals(text)) {
            button.setText(text);
        }
        if (!"".equals(tip)) {
            button.setToolTipText(tip);
        }
        if (!"".equals(icon)) {
            button.setIcon(this.findIcon(icon));
        }
        if (!"".equals(mnemonic)) {
            button.setMnemonic(mnemonic.charAt(0));
        }
        if (!"".equals(accelerator)) {
            button.setAccelerator(KeyStroke.getKeyStroke(accelerator));
        }
        if (!"".equals(group)) {
            this.initializeButtonGroup(button, group);
        }
    }

    protected void initializeButtonGroup(AbstractButton b, String groupName) {
        ButtonGroup group = null;
        if (this.groupMap.containsKey(groupName)) {
            group = (ButtonGroup)this.groupMap.get(groupName);
        } else {
            group = new ButtonGroup();
            this.groupMap.put(groupName, group);
        }
        if (group.getButtonCount() == 0) {
            b.setSelected(true);
        }
        group.add(b);
    }

    protected Icon findIcon(String key) {
        Icon icon = UIManager.getIcon(key);
        if (icon == null) {
            icon = new ImageIcon(ClassLoader.getSystemResource(key));
        }
        return icon;
    }

    protected Action findAction(String key) {
        return super.getActionMap().get(key);
    }
}

