/*
 * Decompiled with CFR 0.152.
 */
package com.sun.medialib.codec.jpeg;

import com.sun.medialib.codec.jpeg.Constants;
import com.sun.medialib.mlib.mediaLibImage;
import java.io.IOException;
import java.io.InputStream;
import javax.imageio.stream.ImageInputStream;

public final class Decoder
implements Constants {
    private int decoder = 0;
    private ImageInputStream iistream = null;
    private long iioffset = 0L;

    public static String getVersion() {
        return "jpeg:0100:20040506:javawrapper";
    }

    public Decoder(InputStream inputStream) throws IOException {
        if (inputStream instanceof ImageInputStream) {
            this.iistream = (ImageInputStream)((Object)inputStream);
            this.iioffset = this.iistream.getStreamPosition();
        }
        this.decoder = this.njpeg_decode_init(inputStream);
    }

    public Decoder(ImageInputStream imageInputStream) throws IOException {
        this.iistream = imageInputStream;
        this.iioffset = this.iistream.getStreamPosition();
        this.decoder = this.njpeg_decode_init(imageInputStream);
    }

    public mediaLibImage decode(mediaLibImage mediaLibImage2) throws IOException {
        Object[] objectArray;
        int[] nArray = new int[9];
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        this.njpeg_decode(this.decoder, nArray);
        if (this.iistream != null) {
            this.iistream.seek(this.iioffset + (long)this.getLength());
        }
        if (nArray[1] == -1) {
            return null;
        }
        n2 = nArray[3];
        n = nArray[4];
        if (nArray[8] == 0) {
            n2 = nArray[7] == 2 ? nArray[3] + 7 & 0xFFFFFFF8 : nArray[3] + 15 & 0xFFFFFFF0;
        }
        n3 = n2 * n;
        if (nArray[0] == 1) {
            objectArray = new byte[n3];
        } else if (nArray[0] == 2) {
            n /= 2;
            objectArray = new short[n3 / 2];
        } else {
            return null;
        }
        if (mediaLibImage2 == null) {
            mediaLibImage2 = new mediaLibImage(nArray[0], nArray[1], nArray[2], nArray[3], n, 0, nArray[7], (Object)objectArray);
        }
        this.nSetData(mediaLibImage2, n3, this.decoder);
        if (nArray[7] != -1) {
            mediaLibImage2.setFormat(nArray[7]);
        }
        return mediaLibImage2;
    }

    public mediaLibImage getSize() {
        int[] nArray = new int[9];
        int n = 0;
        boolean bl = false;
        boolean bl2 = false;
        this.nGetSize(this.decoder, nArray);
        if (nArray[1] == -1) {
            return null;
        }
        n = nArray[4];
        if (nArray[0] == 2) {
            n >>= 1;
        }
        mediaLibImage mediaLibImage2 = new mediaLibImage(nArray[0], nArray[1], nArray[2], nArray[3], n, 0, nArray[7], null);
        return mediaLibImage2;
    }

    public void setFormat(int n) {
        this.nSetFormat(this.decoder, n);
    }

    public void setFilter(int n) {
        this.nSetFilter(this.decoder, n);
    }

    public int getDepth() {
        return this.nGetDepth(this.decoder);
    }

    public int getType() {
        return this.nGetType(this.decoder);
    }

    public int getMode() {
        return this.nGetMode(this.decoder);
    }

    public int getRate() {
        return this.nGetRate(this.decoder);
    }

    public int getLength() {
        return this.nGetLength(this.decoder);
    }

    protected void finalize() throws Throwable {
        this.njpeg_decode_free(this.decoder);
    }

    public void free() throws Throwable {
        this.njpeg_decode_free(this.decoder);
    }

    private native int njpeg_decode_init(Object var1);

    private native void njpeg_decode(int var1, int[] var2);

    private native void nSetData(Object var1, int var2, int var3);

    private native void nSetFormat(int var1, int var2);

    private native void nSetFilter(int var1, int var2);

    private native void nGetSize(int var1, int[] var2);

    private native int nGetDepth(int var1);

    private native int nGetType(int var1);

    private native int nGetMode(int var1);

    private native int nGetRate(int var1);

    private native int nGetLength(int var1);

    private native void njpeg_decode_free(int var1);

    static {
        System.loadLibrary("clib_jiio");
    }
}

