/*
 * Decompiled with CFR 0.152.
 */
package com.sun.medialib.codec.jp2k;

import com.sun.medialib.codec.jp2k.Box;
import com.sun.medialib.codec.jp2k.CompParams;
import com.sun.medialib.codec.jp2k.Constants;
import com.sun.medialib.codec.jp2k.Params;
import com.sun.medialib.codec.jp2k.Size;
import com.sun.medialib.mlib.mediaLibImage;
import java.io.IOException;
import javax.imageio.stream.ImageInputStream;

public final class Decoder
implements Constants {
    private Size size = null;
    private Params params = null;
    private CompParams compparams = null;
    private mediaLibImage image = null;
    private int mode = 0;
    private int decoder = 0;

    public Decoder(ImageInputStream imageInputStream) throws IOException {
        long l = imageInputStream.getStreamPosition();
        this.decoder = this.decode_init(imageInputStream, l);
    }

    public final mediaLibImage[] decode(mediaLibImage[] mediaLibImageArray, int n) throws IOException {
        int n2;
        if (mediaLibImageArray == null) {
            if (this.size == null) {
                this.size = this.decodeSize(null);
            }
            if (this.mode == 0 || this.mode == 2) {
                this.image = this.decodeCompSize(this.image, 0);
                mediaLibImageArray = new mediaLibImage[]{new mediaLibImage(this.image.getType(), this.image.getChannels(), this.image.getWidth(), this.image.getHeight())};
            } else {
                mediaLibImageArray = new mediaLibImage[this.size.csize];
                for (int i = 0; i < this.size.csize; ++i) {
                    this.image = this.decodeCompSize(this.image, i);
                    mediaLibImageArray[i] = new mediaLibImage(this.image.getType(), this.image.getChannels(), this.image.getWidth(), this.image.getHeight());
                }
            }
        }
        if ((n2 = this.decode(this.decoder, mediaLibImageArray, n)) == 0) {
            return mediaLibImageArray;
        }
        return null;
    }

    public final Size decodeSize(Size size) throws IOException {
        this.size = size == null ? new Size() : size;
        int n = this.decode_size(this.decoder, this.size);
        if (n == 0) {
            return this.size;
        }
        return null;
    }

    public final mediaLibImage decodeCompSize(mediaLibImage mediaLibImage2, int n) throws IOException {
        this.image = mediaLibImage2 == null ? new mediaLibImage(1, 1, 1, 1, 1, 0, null) : mediaLibImage2;
        int n2 = this.decode_comp_size(this.decoder, this.image, n);
        if (n2 == 0) {
            return this.image;
        }
        return null;
    }

    public final Params decodeParams(Params params) throws IOException {
        if (params == null) {
            this.params = new Params();
            int n = this.decode_nilrates(this.decoder, this.params);
            this.params.ilrates = new double[n];
        } else {
            this.params = params;
        }
        int n = this.decode_params(this.decoder, this.params);
        if (n == 0) {
            return this.params;
        }
        return null;
    }

    public final CompParams decodeCompParams(CompParams compParams, int n) throws IOException {
        this.compparams = compParams == null ? new CompParams() : compParams;
        int n2 = this.decode_comp_params(this.decoder, this.compparams, n);
        if (n2 == 0) {
            return this.compparams;
        }
        return null;
    }

    public final Box decodeBox() throws IOException {
        int n = this.decode_box_size(this.decoder);
        if (n < 0) {
            return null;
        }
        Box box = new Box();
        box.data = (byte[])(n == 0 ? null : new byte[n]);
        int n2 = this.decode_box(this.decoder, box);
        if (n2 == 0) {
            return box;
        }
        return null;
    }

    public final void setMode(int n) {
        this.mode = n;
        this.decode_set_mode(this.decoder, this.mode);
    }

    public final void setMaxLayers(int n) {
        this.decode_set_maxlyrs(this.decoder, n);
    }

    public final void setMaxLevels(int n) {
        this.decode_set_maxlvls(this.decoder, n);
    }

    public final void setMaxPackets(int n) {
        this.decode_set_maxpkts(this.decoder, n);
    }

    public final void setRate(double d, int n) {
        this.decode_set_rate(this.decoder, d, n);
    }

    protected void finalize() throws Throwable {
        this.decode_free(this.decoder);
        this.decoder = 0;
    }

    public static final String getVersion() {
        return Decoder.decode_get_version();
    }

    private static native String decode_get_version();

    private native int decode_init(ImageInputStream var1, long var2);

    private native void decode_free(int var1);

    private native void decode_set_mode(int var1, int var2);

    private native void decode_set_maxlyrs(int var1, int var2);

    private native void decode_set_maxlvls(int var1, int var2);

    private native void decode_set_maxpkts(int var1, int var2);

    private native void decode_set_rate(int var1, double var2, int var4);

    private native int decode_size(int var1, Size var2);

    private native int decode_comp_size(int var1, mediaLibImage var2, int var3);

    private native int decode_nilrates(int var1, Params var2);

    private native int decode_params(int var1, Params var2);

    private native int decode_comp_params(int var1, CompParams var2, int var3);

    private native int decode(int var1, mediaLibImage[] var2, int var3);

    private native int decode_box_size(int var1);

    private native int decode_box(int var1, Box var2);

    static {
        System.loadLibrary("clib_jiio");
    }
}

