/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.svg;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.io.IOException;
import org.apache.avalon.framework.configuration.Configurable;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.container.ContainerUtil;
import org.apache.batik.bridge.Bridge;
import org.apache.batik.bridge.BridgeContext;
import org.apache.batik.bridge.UserAgent;
import org.apache.batik.ext.awt.g2d.GraphicContext;
import org.apache.batik.gvt.TextPainter;
import org.apache.batik.gvt.renderer.StrokingTextPainter;
import org.apache.batik.transcoder.SVGAbstractTranscoder;
import org.apache.batik.transcoder.TranscoderException;
import org.apache.batik.transcoder.TranscoderOutput;
import org.apache.batik.transcoder.TranscoderSupport;
import org.apache.batik.transcoder.image.ImageTranscoder;
import org.apache.fop.svg.AbstractFOPTranscoder;
import org.apache.fop.svg.PDFAElementBridge;
import org.apache.fop.svg.PDFDocumentGraphics2D;
import org.apache.fop.svg.PDFImageElementBridge;
import org.apache.fop.svg.PDFTextElementBridge;
import org.w3c.dom.Document;

public class PDFTranscoder
extends AbstractFOPTranscoder
implements Configurable {
    private Configuration cfg = null;
    protected PDFDocumentGraphics2D graphics = null;

    public PDFTranscoder() {
        ((TranscoderSupport)this).handler = new AbstractFOPTranscoder.FOPErrorHandler();
    }

    public void configure(Configuration cfg) throws ConfigurationException {
        this.cfg = cfg;
    }

    protected BridgeContext createBridgeContext() {
        BridgeContext ctx = new BridgeContext(this.userAgent);
        StrokingTextPainter textPainter = null;
        textPainter = new StrokingTextPainter();
        ctx.setTextPainter((TextPainter)textPainter);
        PDFTextElementBridge pdfTextElementBridge = new PDFTextElementBridge(this.graphics.getFontInfo());
        ctx.putBridge((Bridge)pdfTextElementBridge);
        PDFAElementBridge pdfAElementBridge = new PDFAElementBridge();
        AffineTransform currentTransform = new AffineTransform(1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f);
        pdfAElementBridge.setCurrentTransform(currentTransform);
        ctx.putBridge((Bridge)pdfAElementBridge);
        ctx.putBridge((Bridge)new PDFImageElementBridge());
        return ctx;
    }

    protected UserAgent createUserAgent() {
        return new SVGAbstractTranscoder.SVGAbstractTranscoderUserAgent(this){

            public float getPixelUnitToMillimeter() {
                return 0.3427778f;
            }
        };
    }

    protected void transcode(Document document, String uri, TranscoderOutput output) throws TranscoderException {
        this.graphics = new PDFDocumentGraphics2D();
        ContainerUtil.enableLogging(this.graphics, this.getLogger());
        try {
            if (this.cfg != null) {
                ContainerUtil.configure(this.graphics, this.cfg);
            }
            ContainerUtil.initialize(this.graphics);
        }
        catch (Exception e) {
            throw new TranscoderException("Error while setting up PDFDocumentGraphics2D", e);
        }
        super.transcode(document, uri, output);
        int w = (int)((double)this.width + 0.5);
        int h = (int)((double)this.height + 0.5);
        try {
            this.graphics.setupDocument(output.getOutputStream(), w, h);
            this.graphics.setSVGDimension(w, h);
            if (((TranscoderSupport)this).hints.containsKey((Object)ImageTranscoder.KEY_BACKGROUND_COLOR)) {
                this.graphics.setBackgroundColor((Color)((TranscoderSupport)this).hints.get((Object)ImageTranscoder.KEY_BACKGROUND_COLOR));
            }
            this.graphics.setGraphicContext(new GraphicContext());
            this.graphics.setTransform(this.curTxf);
            this.root.paint((Graphics2D)((Object)this.graphics));
            this.graphics.finish();
        }
        catch (IOException ex) {
            throw new TranscoderException((Exception)ex);
        }
    }
}

