/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.svg;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Shape;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphVector;
import java.awt.geom.AffineTransform;
import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import org.apache.avalon.framework.CascadingRuntimeException;
import org.apache.avalon.framework.activity.Initializable;
import org.apache.avalon.framework.configuration.Configurable;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.container.ContainerUtil;
import org.apache.avalon.framework.logger.ConsoleLogger;
import org.apache.avalon.framework.logger.LogEnabled;
import org.apache.avalon.framework.logger.Logger;
import org.apache.fop.apps.Document;
import org.apache.fop.pdf.PDFAnnotList;
import org.apache.fop.pdf.PDFColor;
import org.apache.fop.pdf.PDFDocument;
import org.apache.fop.pdf.PDFFilterList;
import org.apache.fop.pdf.PDFNumber;
import org.apache.fop.pdf.PDFPage;
import org.apache.fop.pdf.PDFResources;
import org.apache.fop.pdf.PDFState;
import org.apache.fop.pdf.PDFStream;
import org.apache.fop.render.pdf.FontSetup;
import org.apache.fop.svg.PDFGraphics2D;

public class PDFDocumentGraphics2D
extends PDFGraphics2D
implements LogEnabled,
Configurable,
Initializable {
    private PDFPage currentPage;
    private PDFStream pdfStream;
    private int width;
    private int height;
    private List fontList;
    private Logger logger;
    private Configuration cfg;

    public PDFDocumentGraphics2D() {
        super(false);
    }

    public PDFDocumentGraphics2D(PDFDocumentGraphics2D g) {
        super(g);
    }

    public PDFDocumentGraphics2D(boolean textAsShapes) {
        super(textAsShapes);
        if (!textAsShapes) {
            this.fontInfo = new Document(null);
            FontSetup.setup(this.fontInfo, null);
        }
        try {
            this.initialize();
        }
        catch (Exception e) {
            throw new CascadingRuntimeException("Internal error", e);
        }
    }

    public PDFDocumentGraphics2D(boolean textAsShapes, OutputStream stream, int width, int height) throws IOException {
        this(textAsShapes);
        this.setupDocument(stream, width, height);
    }

    public void configure(Configuration cfg) throws ConfigurationException {
        this.cfg = cfg;
        this.fontList = FontSetup.buildFontListFromConfiguration(cfg);
    }

    public Graphics create() {
        return new PDFDocumentGraphics2D(this);
    }

    public void drawString(String s, float x, float y) {
        if (this.textAsShapes) {
            Font font = super.getFont();
            FontRenderContext frc = super.getFontRenderContext();
            GlyphVector gv = font.createGlyphVector(frc, s);
            Shape glyphOutline = gv.getOutline(x, y);
            super.fill(glyphOutline);
        } else {
            super.drawString(s, x, y);
        }
    }

    public void enableLogging(Logger logger) {
        this.logger = logger;
    }

    public void finish() throws IOException {
        this.pdfStream.add(this.getString());
        this.pdfDoc.registerObject(this.pdfStream);
        this.currentPage.setContents(this.pdfStream);
        PDFAnnotList annots = this.currentPage.getAnnotations();
        if (annots != null) {
            this.pdfDoc.addObject(annots);
        }
        this.pdfDoc.addObject(this.currentPage);
        if (this.fontInfo != null) {
            FontSetup.addToResources(this.pdfDoc, this.pdfDoc.getResources(), this.fontInfo);
        }
        this.pdfDoc.output(this.outputStream);
        this.pdfDoc.outputTrailer(this.outputStream);
        this.outputStream.flush();
    }

    public Document getFontInfo() {
        return this.fontInfo;
    }

    protected final Logger getLogger() {
        if (this.logger == null) {
            this.logger = new ConsoleLogger(1);
        }
        return this.logger;
    }

    public PDFDocument getPDFDocument() {
        return this.pdfDoc;
    }

    public void initialize() throws Exception {
        if (this.fontInfo == null) {
            this.fontInfo = new Document(null);
            FontSetup.setup(this.fontInfo, this.fontList);
        }
        this.pdfDoc = new PDFDocument("Apache FOP: SVG to PDF Transcoder");
        ContainerUtil.enableLogging(this.pdfDoc, this.getLogger().getChildLogger("pdf"));
        if (this.cfg != null) {
            this.pdfDoc.setFilterMap(PDFFilterList.buildFilterMapFromConfiguration(this.cfg));
        }
        this.graphicsState = new PDFState();
        this.currentFontName = "";
        this.currentFontSize = 0.0f;
        this.pdfStream = this.pdfDoc.getFactory().makeStream("content", false);
    }

    public void setBackgroundColor(Color col) {
        Color c = col;
        PDFColor currentColour = new PDFColor(c.getRed(), c.getGreen(), c.getBlue());
        this.currentStream.write("q\n");
        this.currentStream.write(currentColour.getColorSpaceOut(true));
        this.currentStream.write("0 0 " + this.width + " " + this.height + " re\n");
        this.currentStream.write("f\n");
        this.currentStream.write("Q\n");
    }

    public void setSVGDimension(float w, float h) {
        this.currentStream.write(PDFNumber.doubleOut((float)this.width / w) + " 0 0 " + PDFNumber.doubleOut((float)this.height / h) + " 0 0 cm\n");
    }

    public void setupDocument(OutputStream stream, int width, int height) throws IOException {
        this.width = width;
        this.height = height;
        PDFResources pdfResources = this.pdfDoc.getResources();
        this.currentPage = this.pdfDoc.getFactory().makePage(pdfResources, width, height);
        this.resourceContext = this.currentPage;
        this.pageRef = this.currentPage.referencePDF();
        this.currentStream.write("1 0 0 -1 0 " + height + " cm\n");
        this.graphicsState.setTransform(new AffineTransform(1.0, 0.0, 0.0, -1.0, 0.0, (double)height));
        this.pdfDoc.outputHeader(stream);
        this.setOutputStream(stream);
    }
}

