/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.pdf;

import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.fop.pdf.ASCII85Filter;
import org.apache.fop.pdf.ASCIIHexFilter;
import org.apache.fop.pdf.DCTFilter;
import org.apache.fop.pdf.FlateFilter;
import org.apache.fop.pdf.NullFilter;
import org.apache.fop.pdf.PDFFilter;

public class PDFFilterList {
    public static final String DEFAULT_FILTER = "default";
    public static final String CONTENT_FILTER = "content";
    public static final String IMAGE_FILTER = "image";
    public static final String JPEG_FILTER = "jpeg";
    public static final String FONT_FILTER = "font";
    private List filters = new ArrayList();
    private boolean ignoreASCIIFilters = false;

    public PDFFilterList() {
    }

    public PDFFilterList(boolean ignoreASCIIFilters) {
        this.ignoreASCIIFilters = ignoreASCIIFilters;
    }

    public void addDefaultFilters(Map filters, String type) {
        List filterset = null;
        if (filters != null && (filterset = (List)filters.get(type)) == null) {
            filterset = (List)filters.get(DEFAULT_FILTER);
        }
        if (filterset == null || filterset.size() == 0) {
            this.addFilter(new FlateFilter());
        } else {
            int i = 0;
            while (i < filterset.size()) {
                String v = (String)filterset.get(i);
                this.addFilter(v);
                ++i;
            }
        }
    }

    public void addFilter(String filterType) {
        if (filterType == null) {
            return;
        }
        if (filterType.equals("flate")) {
            this.addFilter(new FlateFilter());
        } else if (filterType.equals("null")) {
            this.addFilter(new NullFilter());
        } else if (filterType.equals("ascii-85")) {
            if (this.ignoreASCIIFilters) {
                return;
            }
            this.addFilter(new ASCII85Filter());
        } else if (filterType.equals("ascii-hex")) {
            if (this.ignoreASCIIFilters) {
                return;
            }
            this.addFilter(new ASCIIHexFilter());
        } else {
            if (filterType.equals("")) {
                return;
            }
            throw new IllegalArgumentException("Unsupported filter type in stream-filter-list: " + filterType);
        }
    }

    public void addFilter(PDFFilter filter) {
        if (filter != null) {
            if (this.ignoreASCIIFilters && filter.isASCIIFilter()) {
                return;
            }
            this.filters.add(filter);
        }
    }

    public OutputStream applyFilters(OutputStream stream) throws IOException {
        OutputStream out = stream;
        if (this.filters != null) {
            int count = this.filters.size() - 1;
            while (count >= 0) {
                PDFFilter filter = (PDFFilter)this.filters.get(count);
                out = filter.applyFilter(out);
                --count;
            }
        }
        return out;
    }

    private String buildDecodeParms(List parms) {
        StringBuffer sb = new StringBuffer();
        boolean needParmsEntry = false;
        sb.append("/DecodeParms ");
        if (parms.size() > 1) {
            sb.append("[ ");
        }
        int count = 0;
        while (count < parms.size()) {
            String s = (String)parms.get(count);
            if (s != null) {
                sb.append(s);
                needParmsEntry = true;
            } else {
                sb.append("null");
            }
            sb.append(" ");
            ++count;
        }
        if (parms.size() > 1) {
            sb.append("]");
        }
        if (needParmsEntry) {
            return sb.toString();
        }
        return "";
    }

    protected String buildFilterDictEntries() {
        if (this.filters != null && this.filters.size() > 0) {
            ArrayList<String> names = new ArrayList<String>();
            ArrayList<String> parms = new ArrayList<String>();
            int count = 0;
            while (count < this.filters.size()) {
                PDFFilter filter = (PDFFilter)this.filters.get(count);
                names.add(0, filter.getName());
                parms.add(0, filter.getDecodeParms());
                ++count;
            }
            return String.valueOf(this.buildFilterEntries(names)) + this.buildDecodeParms(parms);
        }
        return "";
    }

    private String buildFilterEntries(List names) {
        boolean needFilterEntry = false;
        StringBuffer sb = new StringBuffer(64);
        sb.append("/Filter [ ");
        int i = 0;
        while (i < names.size()) {
            String name = (String)names.get(i);
            if (name.length() > 0) {
                needFilterEntry = true;
                sb.append(name);
                sb.append(" ");
            }
            ++i;
        }
        if (needFilterEntry) {
            sb.append("]");
            return sb.toString();
        }
        return "";
    }

    public static Map buildFilterMapFromConfiguration(Configuration cfg) throws ConfigurationException {
        HashMap filterMap = new HashMap();
        Configuration[] filterLists = cfg.getChildren("filterList");
        int i = 0;
        while (i < filterLists.length) {
            Configuration filters = filterLists[i];
            String type = filters.getAttribute("type", null);
            Configuration[] filt = filters.getChildren("value");
            ArrayList<String> filterList = new ArrayList<String>();
            int j = 0;
            while (j < filt.length) {
                String name = filt[j].getValue();
                filterList.add(name);
                ++j;
            }
            if (type == null) {
                type = DEFAULT_FILTER;
            }
            if (filterMap.get(type) != null) {
                throw new ConfigurationException("A filterList of type '" + type + "' has already been defined");
            }
            filterMap.put(type, filterList);
            ++i;
        }
        return filterMap;
    }

    public void ensureDCTFilterInPlace() {
        if (this.filters.size() == 0) {
            this.addFilter(new DCTFilter());
        } else if (!(this.filters.get(0) instanceof DCTFilter)) {
            this.filters.add(0, new DCTFilter());
        }
    }

    public boolean isInitialized() {
        return this.filters.size() > 0;
    }
}

