/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.fonts.type1;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import org.apache.avalon.framework.logger.AbstractLogEnabled;
import org.apache.commons.io.IOUtil;
import org.apache.fop.fonts.Glyphs;
import org.apache.fop.fonts.type1.PFMInputStream;

public class PFMFile
extends AbstractLogEnabled {
    private String windowsName;
    private String postscriptName;
    private short dfItalic;
    private int dfWeight;
    private short dfCharSet;
    private short dfPitchAndFamily;
    private int dfAvgWidth;
    private int dfMaxWidth;
    private int dfMinWidth;
    private short dfFirstChar;
    private short dfLastChar;
    private int etmCapHeight;
    private int etmXHeight;
    private int etmLowerCaseAscent;
    private int etmLowerCaseDescent;
    private int[] extentTable;
    private Map kerningTab = new HashMap();

    public int getCapHeight() {
        return this.etmCapHeight;
    }

    public short getCharSet() {
        return this.dfCharSet;
    }

    public String getCharSetName() {
        switch (this.dfCharSet) {
            case 0: {
                return "WinAnsi";
            }
            case 128: {
                return "Shift-JIS (Japanese)";
            }
        }
        return "Unknown";
    }

    public int getCharWidth(short which) {
        return this.extentTable[which - this.dfFirstChar];
    }

    public short getFirstChar() {
        return this.dfFirstChar;
    }

    public int getFlags() {
        int flags = 0;
        if (!this.getIsProportional()) {
            flags |= 1;
        }
        if ((this.dfPitchAndFamily & 0x10) == 16) {
            flags |= 2;
        }
        if ((this.dfPitchAndFamily & 0x40) == 64) {
            flags |= 4;
        }
        if (this.dfCharSet == 0) {
            flags |= 6;
        }
        if (this.dfItalic != 0) {
            flags |= 7;
        }
        return flags;
    }

    public int[] getFontBBox() {
        int[] bbox = new int[]{!this.getIsProportional() && this.dfAvgWidth == this.dfMaxWidth ? -20 : -100, -(this.getLowerCaseDescent() + 5), this.dfMaxWidth + 10, this.getLowerCaseAscent() + 5};
        return bbox;
    }

    public boolean getIsProportional() {
        return (this.dfPitchAndFamily & 1) == 1;
    }

    public int getItalicAngle() {
        if (this.dfItalic != 0) {
            return -16;
        }
        return 0;
    }

    public Map getKerning() {
        return this.kerningTab;
    }

    public short getLastChar() {
        return this.dfLastChar;
    }

    public int getLowerCaseAscent() {
        return this.etmLowerCaseAscent;
    }

    public int getLowerCaseDescent() {
        return this.etmLowerCaseDescent;
    }

    public String getPostscriptName() {
        return this.postscriptName;
    }

    public int getStemV() {
        if (this.dfItalic != 0) {
            return (int)Math.round((double)this.dfMinWidth * 0.25);
        }
        return (int)Math.round((double)this.dfMinWidth * 0.6);
    }

    public String getWindowsName() {
        return this.windowsName;
    }

    public int getXHeight() {
        return this.etmXHeight;
    }

    public void load(InputStream inStream) throws IOException {
        byte[] buf = IOUtil.toByteArray(inStream);
        ByteArrayInputStream bufin = new ByteArrayInputStream(buf);
        PFMInputStream in = new PFMInputStream(bufin);
        in.readShort();
        long filesize = in.readInt();
        if (filesize != (long)buf.length) {
            this.getLogger().warn("Effective file size is not the same as indicated in the header.");
        }
        ((InputStream)bufin).reset();
        this.loadHeader(in);
        this.loadExtension(in);
    }

    private void loadExtMetrics(PFMInputStream inStream) throws IOException {
        int size = inStream.readShort();
        if (size != 52) {
            this.getLogger().warn("Size of extension block was expected to be 52 bytes, but was " + size + " bytes.");
        }
        inStream.skip(12L);
        this.etmCapHeight = inStream.readShort();
        this.etmXHeight = inStream.readShort();
        this.etmLowerCaseAscent = inStream.readShort();
        this.etmLowerCaseDescent = inStream.readShort();
    }

    private void loadExtension(PFMInputStream inStream) throws IOException {
        int size = inStream.readShort();
        if (size != 30) {
            this.getLogger().warn("Size of extension block was expected to be 30 bytes, but was " + size + " bytes.");
        }
        long extMetricsOffset = inStream.readInt();
        long extentTableOffset = inStream.readInt();
        inStream.skip(4L);
        long kernPairOffset = inStream.readInt();
        inStream.skip(4L);
        long driverInfoOffset = inStream.readInt();
        if (kernPairOffset > 0L) {
            inStream.reset();
            inStream.skip(kernPairOffset);
            this.loadKernPairs(inStream);
        }
        inStream.reset();
        inStream.skip(driverInfoOffset);
        this.postscriptName = inStream.readString();
        if (extMetricsOffset != 0L) {
            inStream.reset();
            inStream.skip(extMetricsOffset);
            this.loadExtMetrics(inStream);
        }
        if (extentTableOffset != 0L) {
            inStream.reset();
            inStream.skip(extentTableOffset);
            this.loadExtentTable(inStream);
        }
    }

    private void loadExtentTable(PFMInputStream inStream) throws IOException {
        this.extentTable = new int[this.dfLastChar - this.dfFirstChar + 1];
        this.dfMinWidth = this.dfMaxWidth;
        short i = this.dfFirstChar;
        while (i <= this.dfLastChar) {
            this.extentTable[i - this.dfFirstChar] = inStream.readShort();
            if (this.extentTable[i - this.dfFirstChar] < this.dfMinWidth) {
                this.dfMinWidth = this.extentTable[i - this.dfFirstChar];
            }
            i = (short)(i + 1);
        }
    }

    private void loadHeader(PFMInputStream inStream) throws IOException {
        inStream.skip(80L);
        this.dfItalic = inStream.readByte();
        inStream.skip(2L);
        this.dfWeight = inStream.readShort();
        this.dfCharSet = inStream.readByte();
        inStream.skip(4L);
        this.dfPitchAndFamily = inStream.readByte();
        this.dfAvgWidth = inStream.readShort();
        this.dfMaxWidth = inStream.readShort();
        this.dfFirstChar = inStream.readByte();
        this.dfLastChar = inStream.readByte();
        inStream.skip(8L);
        long faceOffset = inStream.readInt();
        inStream.reset();
        inStream.skip(faceOffset);
        this.windowsName = inStream.readString();
        inStream.reset();
        inStream.skip(117L);
    }

    private void loadKernPairs(PFMInputStream inStream) throws IOException {
        int i = inStream.readShort();
        this.getLogger().info(String.valueOf(i) + " kerning pairs");
        while (i > 0) {
            HashMap<Integer, Integer> adjTab;
            short g1 = inStream.readByte();
            --i;
            short g2 = inStream.readByte();
            int adj = inStream.readShort();
            if (adj > 32768) {
                adj = -(65536 - adj);
            }
            this.getLogger().debug("Char no: (" + g1 + ", " + g2 + ") kern: " + adj);
            if (this.getLogger().isDebugEnabled()) {
                String glyph1 = Glyphs.TEX8R_GLYPH_NAMES[g1];
                String glyph2 = Glyphs.TEX8R_GLYPH_NAMES[g2];
                this.getLogger().debug("glyphs: " + glyph1 + ", " + glyph2);
            }
            if ((adjTab = (HashMap<Integer, Integer>)this.kerningTab.get(new Integer(g1))) == null) {
                adjTab = new HashMap<Integer, Integer>();
            }
            adjTab.put(new Integer(g2), new Integer(adj));
            this.kerningTab.put(new Integer(g1), adjTab);
        }
    }
}

