/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.editor.fold;

import java.util.NoSuchElementException;
import org.netbeans.editor.fold.api.Fold;
import org.netbeans.editor.fold.api.FoldHierarchyIterator;
import org.netbeans.editor.fold.spi.AbstractFold;
import org.netbeans.editor.fold.spi.FoldHierarchySpi;

public final class SingleRootFoldIterator
implements FoldHierarchyIterator {
    public static final FoldHierarchyIterator EMPTY_ITERATOR = new EmptyIterator();
    private final FoldHierarchySpi hierarchySpi;
    private final Fold fold;
    private boolean collapsedFolds;
    private int startOffset;
    private int endOffset;
    private Item rootItem;
    private Item lastCollapsedItem;
    private int lastCollapsedEndOffset;
    private Fold nextToRet;
    private int nextToRetIndex;
    private Fold lastRet;

    public SingleRootFoldIterator(FoldHierarchySpi hierarchySpi, AbstractFold fold, int startOffset, int endOffset, boolean collapsedFolds) {
        this.hierarchySpi = hierarchySpi;
        this.fold = fold;
        this.startOffset = startOffset;
        this.endOffset = endOffset;
        this.collapsedFolds = collapsedFolds;
        if (collapsedFolds) {
            this.lastCollapsedEndOffset = startOffset;
        }
    }

    private Fold nextCollapsedFold() {
        this.ensureInited();
        Item collapsed = null;
        Item item = this.lastCollapsedItem;
        if (item == null || this.lastCollapsedEndOffset < item.getEndOffset()) {
            item = this.rootItem;
            if (item.isBranch()) {
                Item child = item.findChild(this.lastCollapsedEndOffset);
                while (child != null) {
                    if (CollapsedAcceptor.INSTANCE.isAccepted(child.fold)) {
                        collapsed = child;
                        break;
                    }
                    item = child;
                    child = item.findChild(this.lastCollapsedEndOffset);
                }
            } else {
                item = null;
            }
        }
        if (collapsed == null && item != null) {
            item = item.nextSiblingOrParent();
            while (item != null) {
                if (CollapsedAcceptor.INSTANCE.isAccepted(item.fold)) {
                    collapsed = item;
                    break;
                }
                item = item.isBeforeFirstChild() ? item.firstChild() : item.nextSiblingOrParent();
            }
        }
        this.lastCollapsedItem = collapsed;
        if (this.lastCollapsedItem != null) {
            this.lastCollapsedEndOffset = this.lastCollapsedItem.getEndOffset();
            return this.lastCollapsedItem.fold;
        }
        return null;
    }

    private void ensureInited() {
        if (this.rootItem == null) {
            this.rootItem = new Item(this.hierarchySpi);
        }
    }

    private void checkItemsFetched() {
        if (this.lastRet == null) {
            throw new IllegalStateException("No item fetched from iterator yet");
        }
    }

    public int getNestingLevel() {
        this.checkItemsFetched();
        int level = 0;
        Fold f = this.lastRet.getParent();
        while (f != null && !f.isRootFold()) {
            ++level;
        }
        return level;
    }

    public boolean hasNestedFolds() {
        this.checkItemsFetched();
        return this.lastRet.getFoldCount() != 0;
    }

    public boolean hasNext() {
        if (this.nextToRet == null) {
            if (this.collapsedFolds) {
                this.nextToRet = this.nextCollapsedFold();
            } else {
                this.nextToRetIndex = this.lastRet != null ? ++this.nextToRetIndex : (this.startOffset == 0 ? 0 : this.fold.getFoldIndex(this.startOffset));
                if (this.nextToRetIndex < this.fold.getFoldCount()) {
                    this.nextToRet = this.fold.getFold(this.nextToRetIndex);
                }
            }
        }
        return this.nextToRet != null;
    }

    public Object next() {
        if (this.hasNext()) {
            Fold f = this.nextToRet;
            this.nextToRet = null;
            this.lastRet = f;
            return f;
        }
        throw new NoSuchElementException("No more elements");
    }

    public void remove() {
        throw new UnsupportedOperationException();
    }

    public FoldHierarchyIterator nestedFoldIterator() {
        return this.nestedFoldIterator(0, Integer.MAX_VALUE);
    }

    public FoldHierarchyIterator nestedFoldIterator(int startOffset, int endOffset) {
        this.checkItemsFetched();
        return new SingleRootFoldIterator(this.hierarchySpi, (AbstractFold)this.lastRet, startOffset, endOffset, false);
    }

    private static void nextNotCalledYet() {
        throw new IllegalStateException("next() not called yet.");
    }

    static final class EmptyIterator
    implements FoldHierarchyIterator {
        EmptyIterator() {
        }

        public boolean hasNext() {
            return false;
        }

        public Object next() {
            throw new NoSuchElementException("No folds in this iterator");
        }

        public int getNestingLevel() {
            SingleRootFoldIterator.nextNotCalledYet();
            return 0;
        }

        public boolean hasNestedFolds() {
            SingleRootFoldIterator.nextNotCalledYet();
            return false;
        }

        public FoldHierarchyIterator nestedFoldIterator() {
            SingleRootFoldIterator.nextNotCalledYet();
            return null;
        }

        public FoldHierarchyIterator nestedFoldIterator(int startOffset, int endOffset) {
            SingleRootFoldIterator.nextNotCalledYet();
            return null;
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    private static final class CollapsedAcceptor
    implements FoldAcceptor {
        static final CollapsedAcceptor INSTANCE = new CollapsedAcceptor();

        private CollapsedAcceptor() {
        }

        public boolean isAccepted(Fold f) {
            return f.isCollapsed();
        }
    }

    private static interface FoldAcceptor {
        public boolean isAccepted(Fold var1);
    }

    static final class Item {
        Item child;
        Item parent;
        Fold fold;
        int startOffset;
        int endOffset;
        int childCount;
        int childIndex;

        Item(FoldHierarchySpi hierarchySpi) {
            this.init(hierarchySpi.getRootFold(0));
        }

        private Item() {
        }

        Item firstChild() {
            return this.child(0);
        }

        Item findChild(int offset) {
            return this.isBranch() ? this.child(this.fold.getFoldIndex(offset)) : null;
        }

        Item nextSibling() {
            return this.parent.child(this.parent.childIndex + 1);
        }

        Item nextSiblingOrParent() {
            Item item;
            if (this.parent != null) {
                item = this.nextSibling();
                if (item == null) {
                    item = this.parent.nextSiblingOrParent();
                }
            } else {
                item = null;
            }
            return item;
        }

        boolean isLeaf() {
            return this.childCount == 0;
        }

        boolean isBranch() {
            return this.childCount > 0;
        }

        boolean isRoot() {
            return this.parent == null;
        }

        int getStartOffset() {
            if (this.startOffset == -1) {
                this.startOffset = this.fold.getStartOffset();
            }
            return this.startOffset;
        }

        int getEndOffset() {
            if (this.endOffset == -1) {
                this.endOffset = this.fold.getEndOffset();
            }
            return this.endOffset;
        }

        boolean isBeforeFirstChild() {
            return this.childCount > 0 && this.childIndex == -1;
        }

        private void init(Fold fold) {
            this.fold = fold;
            this.startOffset = -1;
            this.endOffset = -1;
            this.childCount = fold.getFoldCount();
            this.childIndex = -1;
        }

        private Item child(int index) {
            Item item;
            if (index < this.childCount) {
                item = this.child;
                if (item == null) {
                    item = new Item();
                    item.parent = this;
                    this.child = item;
                }
                this.childIndex = index;
                item.init(this.fold.getFold(index));
            } else {
                item = null;
            }
            return item;
        }

        public String toString() {
            return "fold=" + this.fold + ", startOffset=" + this.startOffset + ", endOffset=" + this.endOffset + ", childIndex=" + this.childIndex + ", childCount=" + this.childCount + ", getStartOffset()=" + this.getStartOffset() + ", getEndOffset()=" + this.getEndOffset();
        }
    }
}

