/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.editor.fold.spi;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.netbeans.editor.fold.api.Fold;
import org.netbeans.editor.fold.api.FoldChildrenChange;
import org.netbeans.editor.fold.api.FoldHierarchyEvent;
import org.netbeans.editor.fold.spi.DefaultFoldStateChange;
import org.netbeans.editor.fold.spi.FoldHierarchySpi;

public final class FoldHierarchyTransaction {
    private static final FoldChildrenChange[] EMPTY_FOLD_CHILDREN_CHANGES = new FoldChildrenChange[0];
    private static final DefaultFoldStateChange[] EMPTY_FOLD_STATE_CHANGES = new DefaultFoldStateChange[0];
    private boolean committed;
    private boolean nonEmpty;
    private FoldHierarchySpi hierarchySpi;
    private List foldChildrenChangeList;
    private Map fold2ChildrenChange;
    private List foldStateChangeList;
    private Map fold2StateChange;

    public FoldHierarchyTransaction(FoldHierarchySpi hierarchySpi) {
        this.hierarchySpi = hierarchySpi;
    }

    private List getFoldChildrenChangeList() {
        if (this.foldChildrenChangeList == null) {
            this.foldChildrenChangeList = new ArrayList();
        }
        return this.foldChildrenChangeList;
    }

    private List getFoldStateChangeList() {
        if (this.foldStateChangeList == null) {
            this.foldStateChangeList = new ArrayList();
        }
        return this.foldStateChangeList;
    }

    private FoldChildrenChange getFoldChildrenChange(Fold f) {
        FoldChildrenChange change = this.fold2ChildrenChange != null ? (FoldChildrenChange)this.fold2ChildrenChange.get(f) : null;
        return change;
    }

    void addFoldChildrenChange(FoldChildrenChange change) {
        Fold fold;
        FoldChildrenChange origChange;
        this.checkNotCommitted();
        if (this.fold2ChildrenChange == null) {
            this.fold2ChildrenChange = new HashMap();
        }
        if ((origChange = this.getFoldChildrenChange(fold = change.getFold())) == null) {
            this.getFoldChildrenChangeList().add(change);
        }
        this.nonEmpty = true;
    }

    public DefaultFoldStateChange getFoldStateChange(Fold f) {
        DefaultFoldStateChange change = this.fold2StateChange != null ? (DefaultFoldStateChange)this.fold2StateChange.get(f) : null;
        return change;
    }

    void replaceFoldStateChange(DefaultFoldStateChange change) {
        DefaultFoldStateChange prevChange;
        this.checkNotCommitted();
        if (this.fold2StateChange == null) {
            this.fold2StateChange = new HashMap();
        }
        if ((prevChange = this.fold2StateChange.put(change.getFold(), change)) == null) {
            this.getFoldStateChangeList().add(change);
        } else {
            for (int i = this.foldStateChangeList.size() - 1; i >= 0; --i) {
                if (this.foldStateChangeList.get(i) != prevChange) continue;
                this.foldStateChangeList.set(i, change);
            }
        }
        this.nonEmpty = true;
    }

    void commitNoFiring() {
        this.checkNotCommitted();
        this.hierarchySpi.clearActiveTransaction();
    }

    public void commit() {
        this.checkNotCommitted();
        this.committed = true;
        this.hierarchySpi.clearActiveTransaction();
        if (this.nonEmpty) {
            DefaultFoldStateChange[] stateChanges;
            FoldChildrenChange[] childrenChanges;
            if (this.foldChildrenChangeList != null) {
                childrenChanges = new FoldChildrenChange[this.foldChildrenChangeList.size()];
                this.foldChildrenChangeList.toArray(childrenChanges);
            } else {
                childrenChanges = EMPTY_FOLD_CHILDREN_CHANGES;
            }
            if (this.foldStateChangeList != null) {
                stateChanges = new DefaultFoldStateChange[this.foldStateChangeList.size()];
                this.foldStateChangeList.toArray(stateChanges);
            } else {
                stateChanges = EMPTY_FOLD_STATE_CHANGES;
            }
            FoldHierarchyEvent evt = this.hierarchySpi.createFoldHierarchyEvent(childrenChanges, stateChanges);
            if (evt != null) {
                this.hierarchySpi.fireFoldHierarchyListener(evt);
            }
        }
    }

    private void checkNotCommitted() {
        if (this.committed) {
            throw new IllegalStateException("FoldHierarchyChange already committed.");
        }
    }
}

