/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.editor.fold.spi;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Iterator;
import java.util.List;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.EventListenerList;
import javax.swing.text.AbstractDocument;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.netbeans.editor.Settings;
import org.netbeans.editor.SettingsChangeEvent;
import org.netbeans.editor.SettingsChangeListener;
import org.netbeans.editor.Utilities;
import org.netbeans.editor.fold.api.Fold;
import org.netbeans.editor.fold.api.FoldChildrenChange;
import org.netbeans.editor.fold.api.FoldHierarchy;
import org.netbeans.editor.fold.api.FoldHierarchyEvent;
import org.netbeans.editor.fold.api.FoldHierarchyIterator;
import org.netbeans.editor.fold.api.FoldHierarchyListener;
import org.netbeans.editor.fold.api.FoldStateChange;
import org.netbeans.editor.fold.spi.AbstractFold;
import org.netbeans.editor.fold.spi.DefaultFoldStateChange;
import org.netbeans.editor.fold.spi.FoldHierarchyTransaction;
import org.netbeans.editor.fold.spi.FoldMaintainer;
import org.netbeans.editor.fold.spi.FoldMaintainerFactory;
import org.netbeans.editor.fold.spi.FoldMaintainerFactoryProvider;
import org.netbeans.editor.fold.spi.RootFold;
import org.netbeans.editor.view.spi.LockView;
import org.netbeans.editor.view.spi.ViewHierarchyMutex;
import org.netbeans.lib.editor.fold.SingleRootFoldIterator;

public final class FoldHierarchySpi
implements DocumentListener,
SettingsChangeListener {
    private static final boolean debug = Boolean.getBoolean("netbeans.debug.editor.fold");
    private static final boolean debugFire = Boolean.getBoolean("netbeans.debug.editor.fold.fire");
    private static final RootFold[] EMPTY_ROOT_FOLDS = new RootFold[0];
    private static Provider provider;
    private final FoldHierarchy hierarchy;
    private final JTextComponent component;
    private boolean inited;
    private AbstractDocument lastDocument;
    private RootFold[] rootFolds = EMPTY_ROOT_FOLDS;
    private ViewHierarchyMutex mutex;
    private EventListenerList listenerList;
    private boolean foldingEnabled;
    private FoldHierarchyTransaction activeTransaction;
    private PropertyChangeListener componentChangesListener;
    static /* synthetic */ Class class$org$netbeans$editor$fold$api$FoldHierarchy;
    static /* synthetic */ Class class$org$netbeans$editor$fold$api$FoldHierarchyListener;

    public static synchronized void registerProvider(Provider p) {
        if (provider != null) {
            throw new IllegalStateException("Provider already registered");
        }
        provider = p;
    }

    public static FoldHierarchySpi get(FoldHierarchy hierarchy) {
        return provider.get(hierarchy);
    }

    public static FoldHierarchySpi get(JTextComponent component) {
        return FoldHierarchySpi.get(FoldHierarchy.get(component));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static FoldHierarchySpi create(FoldHierarchy hierarchy, JTextComponent component) {
        if (hierarchy == null || component == null) {
            throw new NullPointerException();
        }
        Class clazz = class$org$netbeans$editor$fold$api$FoldHierarchy == null ? (class$org$netbeans$editor$fold$api$FoldHierarchy = FoldHierarchySpi.class$("org.netbeans.editor.fold.api.FoldHierarchy")) : class$org$netbeans$editor$fold$api$FoldHierarchy;
        synchronized (clazz) {
            provider.checkCreator(hierarchy);
            return new FoldHierarchySpi(hierarchy, component);
        }
    }

    private FoldHierarchySpi(FoldHierarchy hierarchy, JTextComponent component) {
        this.hierarchy = hierarchy;
        this.component = component;
        this.listenerList = new EventListenerList();
        this.mutex = LockView.getViewHierarchyMutex(component);
    }

    private void init() {
        this.inited = true;
        this.foldingEnabled = this.getFoldingEnabledSetting();
        Settings.addSettingsChangeListener(this);
        this.startComponentChangesListening();
        this.rebuild();
    }

    private void checkInited() {
        if (!this.inited) {
            this.init();
        }
    }

    public final FoldHierarchy getHierarchy() {
        return this.hierarchy;
    }

    public final void lock() {
        this.mutex.lock();
        this.checkInited();
    }

    public void unlock() {
        this.mutex.unlock();
    }

    public JTextComponent getComponent() {
        return this.component;
    }

    public Fold getRootFold(int index) {
        return this.rootFolds[index];
    }

    public int getRootFoldCount() {
        return this.rootFolds.length;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addFoldHierarchyListener(FoldHierarchyListener l) {
        EventListenerList eventListenerList = this.listenerList;
        synchronized (eventListenerList) {
            this.listenerList.add(class$org$netbeans$editor$fold$api$FoldHierarchyListener == null ? (class$org$netbeans$editor$fold$api$FoldHierarchyListener = FoldHierarchySpi.class$("org.netbeans.editor.fold.api.FoldHierarchyListener")) : class$org$netbeans$editor$fold$api$FoldHierarchyListener, l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeFoldHierarchyListener(FoldHierarchyListener l) {
        EventListenerList eventListenerList = this.listenerList;
        synchronized (eventListenerList) {
            this.listenerList.remove(class$org$netbeans$editor$fold$api$FoldHierarchyListener == null ? (class$org$netbeans$editor$fold$api$FoldHierarchyListener = FoldHierarchySpi.class$("org.netbeans.editor.fold.api.FoldHierarchyListener")) : class$org$netbeans$editor$fold$api$FoldHierarchyListener, l);
        }
    }

    void fireFoldHierarchyListener(FoldHierarchyEvent evt) {
        if (debugFire) {
            System.err.println("firing FoldHierarchyEvent:\n" + evt);
        }
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != (class$org$netbeans$editor$fold$api$FoldHierarchyListener == null ? FoldHierarchySpi.class$("org.netbeans.editor.fold.api.FoldHierarchyListener") : class$org$netbeans$editor$fold$api$FoldHierarchyListener)) continue;
            ((FoldHierarchyListener)listeners[i + 1]).foldHierarchyChanged(evt);
        }
    }

    public void collapse(List l) {
        this.listSetCollapsed(l, true);
    }

    public void expand(List l) {
        this.listSetCollapsed(l, false);
    }

    public FoldHierarchyIterator foldIterator(int startOffset, int endOffset) {
        return this.foldIterator(startOffset, endOffset, false);
    }

    public FoldHierarchyIterator collapsedFoldIterator(int startOffset, int endOffset) {
        return this.foldIterator(startOffset, endOffset, true);
    }

    private FoldHierarchyIterator foldIterator(int startOffset, int endOffset, boolean collapsedFolds) {
        if (this.getRootFoldCount() > 0) {
            RootFold firstRootFold = (RootFold)this.hierarchy.getRootFold(0);
            return new SingleRootFoldIterator(firstRootFold.getHierarchySpi(), firstRootFold, startOffset, endOffset, collapsedFolds);
        }
        return SingleRootFoldIterator.EMPTY_ITERATOR;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void listSetCollapsed(List l, boolean collapsed) {
        FoldHierarchyTransaction transaction = this.createFoldHierarchyTransaction();
        try {
            Iterator it = l.iterator();
            while (it.hasNext()) {
                Fold f = (Fold)it.next();
                AbstractFold af = this.castToAbstractFold(f);
                this.checkHierarchySpiIsThis(af);
                af.setCollapsed(collapsed, transaction);
            }
        }
        finally {
            transaction.commit();
        }
    }

    public FoldHierarchyTransaction createFoldHierarchyTransaction() {
        if (this.activeTransaction != null) {
            throw new IllegalStateException("Active transaction already exists.");
        }
        this.activeTransaction = new FoldHierarchyTransaction(this);
        return this.activeTransaction;
    }

    void clearActiveTransaction() {
        if (this.activeTransaction == null) {
            throw new IllegalStateException("No transaction in progress");
        }
        this.activeTransaction = null;
    }

    FoldHierarchyEvent createFoldHierarchyEvent(FoldChildrenChange[] foldChildrenChanges, DefaultFoldStateChange[] foldStateChanges) {
        FoldHierarchyEvent evt;
        Object change;
        int i;
        boolean thoroughCheck = true;
        int affectedStartOffset = Integer.MAX_VALUE;
        int affectedEndOffset = -1;
        for (i = foldChildrenChanges.length - 1; i >= 0; --i) {
            int offset;
            int j;
            change = foldChildrenChanges[i];
            int count = ((FoldChildrenChange)change).getAddedFoldCount();
            if (count > 0) {
                if (thoroughCheck) {
                    for (j = 0; j < count; ++j) {
                        Fold addedFold = ((FoldChildrenChange)change).getAddedFold(j);
                        offset = addedFold.getStartOffset();
                        if (offset < affectedStartOffset) {
                            affectedStartOffset = offset;
                        }
                        if ((offset = addedFold.getEndOffset()) <= affectedEndOffset) continue;
                        affectedEndOffset = offset;
                    }
                } else {
                    offset = ((FoldChildrenChange)change).getAddedFold(0).getStartOffset();
                    if (offset < affectedStartOffset) {
                        affectedStartOffset = offset;
                    }
                    if ((offset = ((FoldChildrenChange)change).getAddedFold(count - 1).getEndOffset()) > affectedEndOffset) {
                        affectedEndOffset = offset;
                    }
                }
            }
            if ((count = ((FoldChildrenChange)change).getRemovedFoldCount()) <= 0) continue;
            if (thoroughCheck) {
                for (j = 0; j < count; ++j) {
                    Fold removedFold = ((FoldChildrenChange)change).getRemovedFold(j);
                    offset = removedFold.getStartOffset();
                    if (offset < affectedStartOffset) {
                        affectedStartOffset = offset;
                    }
                    if ((offset = removedFold.getEndOffset()) <= affectedEndOffset) continue;
                    affectedEndOffset = offset;
                }
                continue;
            }
            offset = ((FoldChildrenChange)change).getRemovedFold(0).getStartOffset();
            if (offset < affectedStartOffset) {
                affectedStartOffset = offset;
            }
            if ((offset = ((FoldChildrenChange)change).getRemovedFold(count - 1).getEndOffset()) <= affectedEndOffset) continue;
            affectedEndOffset = offset;
        }
        for (i = foldStateChanges.length - 1; i >= 0; --i) {
            change = foldStateChanges[i];
            Fold fold = ((FoldStateChange)change).getFold();
            int offset = fold.getStartOffset();
            if (offset < affectedStartOffset) {
                affectedStartOffset = offset;
            }
            if ((offset = fold.getEndOffset()) > affectedEndOffset) {
                affectedEndOffset = offset;
            }
            if ((offset = ((FoldStateChange)change).getOriginalEndOffset()) == -1 || offset <= affectedEndOffset) continue;
            affectedEndOffset = offset;
        }
        if (affectedEndOffset != -1) {
            evt = new FoldHierarchyEvent(this.hierarchy, foldChildrenChanges, foldStateChanges, affectedStartOffset, affectedEndOffset);
        } else {
            if (debugFire) {
                FoldHierarchyEvent evt2 = new FoldHierarchyEvent(this.hierarchy, foldChildrenChanges, foldStateChanges, affectedStartOffset, affectedEndOffset);
                System.err.println("NOT creating FoldHierarchyEvent for:\n" + evt2);
            }
            evt = null;
        }
        return evt;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rebuild() {
        boolean releaseOnly;
        AbstractDocument adoc;
        Document doc;
        if (this.lastDocument != null) {
            this.lastDocument.removeDocumentListener(this);
            this.lastDocument = null;
        }
        if ((doc = this.getComponent().getDocument()) instanceof AbstractDocument) {
            adoc = (AbstractDocument)doc;
            releaseOnly = false;
        } else {
            adoc = null;
            releaseOnly = true;
        }
        if (!this.foldingEnabled) {
            releaseOnly = true;
        }
        if (!this.getComponent().isDisplayable()) {
            releaseOnly = true;
        }
        if (adoc != null) {
            adoc.readLock();
            if (!releaseOnly) {
                this.lastDocument = adoc;
                this.lastDocument.addDocumentListener(this);
            }
        }
        try {
            this.lock();
            try {
                this.rebuildRootFolds(releaseOnly);
            }
            finally {
                this.unlock();
            }
        }
        finally {
            if (adoc != null) {
                adoc.readUnlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void rebuildRootFolds(boolean releaseOnly) {
        Fold[] origRootFolds = this.rootFolds;
        for (int i = 0; i < origRootFolds.length; ++i) {
            this.rootFolds[i].getMaintainer().release();
        }
        FoldMaintainerFactoryProvider provider = !releaseOnly ? FoldMaintainerFactoryProvider.getDefault() : FoldMaintainerFactoryProvider.getEmpty();
        List factoryList = provider.getFactoryList(this);
        int factoryListLength = factoryList.size();
        if (debug) {
            System.err.println("FoldHierarchy rebuild(): FoldMaintainer factory count= + " + factoryListLength);
        }
        if (factoryListLength > 1) {
            throw new IllegalStateException("Multiple fold maintainers support not yet implemented");
        }
        this.rootFolds = new RootFold[factoryListLength];
        for (int i = 0; i < factoryListLength; ++i) {
            this.rootFolds[i] = new RootFold(this, i);
        }
        FoldHierarchyTransaction localTransaction = this.createFoldHierarchyTransaction();
        boolean ok = false;
        try {
            for (int i = 0; i < factoryListLength; ++i) {
                FoldMaintainerFactory factory = (FoldMaintainerFactory)factoryList.get(i);
                FoldMaintainer maintainer = factory.createFoldMaintainer();
                RootFold rootFold = this.rootFolds[i];
                maintainer.init(rootFold, localTransaction);
                rootFold.setMaintainer(maintainer);
            }
            ok = true;
            Object var13_15 = null;
            if (!ok) {
                this.rootFolds = EMPTY_ROOT_FOLDS;
            }
            localTransaction.commitNoFiring();
        }
        catch (Throwable throwable) {
            Object var13_16 = null;
            if (!ok) {
                this.rootFolds = EMPTY_ROOT_FOLDS;
            }
            localTransaction.commitNoFiring();
            throw throwable;
        }
        FoldHierarchyTransaction transaction = this.createFoldHierarchyTransaction();
        try {
            transaction.addFoldChildrenChange(new FoldChildrenChange(null, 0, origRootFolds, this.rootFolds));
        }
        finally {
            transaction.commit();
        }
    }

    private static boolean isDocumentChangesListeningNecessary() {
        return false;
    }

    private void startComponentChangesListening() {
        if (this.componentChangesListener == null) {
            this.componentChangesListener = new PropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent evt) {
                    String propName = evt.getPropertyName();
                    if ("document".equals(propName)) {
                        if (FoldHierarchySpi.isDocumentChangesListeningNecessary()) {
                            FoldHierarchySpi.this.rebuild();
                        }
                    } else if ("ancestor".equals(propName)) {
                        FoldHierarchySpi.this.rebuild();
                    }
                }
            };
            this.getComponent().addPropertyChangeListener(this.componentChangesListener);
        }
    }

    AbstractFold castToAbstractFold(Fold f) {
        if (!(f instanceof AbstractFold)) {
            throw new IllegalArgumentException("Cannot process fold f=" + f + ". Not instanceof AbstractFold");
        }
        return (AbstractFold)f;
    }

    void checkHierarchySpiIsThis(AbstractFold f) {
        if (f.getHierarchySpi() != this) {
            throw new IllegalArgumentException("Fold f=" + f + " not part of hierarchy=" + this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void insertUpdate(DocumentEvent evt) {
        this.lock();
        try {
            FoldHierarchyTransaction transaction = this.createFoldHierarchyTransaction();
            try {
                int rootFoldsLength = this.rootFolds.length;
                for (int i = 0; i < rootFoldsLength; ++i) {
                    this.rootFolds[i].getMaintainer().insertUpdate(evt, transaction);
                }
            }
            finally {
                transaction.commit();
            }
        }
        finally {
            this.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeUpdate(DocumentEvent evt) {
        this.lock();
        try {
            FoldHierarchyTransaction transaction = this.createFoldHierarchyTransaction();
            try {
                int rootFoldsLength = this.rootFolds.length;
                for (int i = 0; i < rootFoldsLength; ++i) {
                    this.rootFolds[i].getMaintainer().removeUpdate(evt, transaction);
                }
            }
            finally {
                transaction.commit();
            }
        }
        finally {
            this.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void changedUpdate(DocumentEvent evt) {
        this.lock();
        try {
            FoldHierarchyTransaction transaction = this.createFoldHierarchyTransaction();
            try {
                int rootFoldsLength = this.rootFolds.length;
                for (int i = 0; i < rootFoldsLength; ++i) {
                    this.rootFolds[i].getMaintainer().changedUpdate(evt, transaction);
                }
            }
            finally {
                transaction.commit();
            }
        }
        finally {
            this.unlock();
        }
    }

    private boolean getFoldingEnabledSetting() {
        Boolean b = (Boolean)Settings.getValue(Utilities.getKitClass(this.hierarchy.getComponent()), "code-folding-enable");
        return b != null ? b : false;
    }

    public void settingsChange(SettingsChangeEvent evt) {
        boolean origFoldingEnabled = this.foldingEnabled;
        this.foldingEnabled = this.getFoldingEnabledSetting();
        if (origFoldingEnabled != this.foldingEnabled) {
            SwingUtilities.invokeLater(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    FoldHierarchySpi.this.lock();
                    try {
                        FoldHierarchySpi.this.rebuild();
                    }
                    finally {
                        FoldHierarchySpi.this.unlock();
                    }
                }
            });
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public static interface Provider {
        public FoldHierarchySpi get(FoldHierarchy var1);

        public void checkCreator(FoldHierarchy var1);
    }
}

