/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.editor.ext.java;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.swing.text.BadLocationException;
import javax.swing.text.JTextComponent;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.Formatter;
import org.netbeans.editor.SyntaxSupport;
import org.netbeans.editor.TokenID;
import org.netbeans.editor.ext.CompletionQuery;
import org.netbeans.editor.ext.ExtFormatter;
import org.netbeans.editor.ext.java.JCBaseFinder;
import org.netbeans.editor.ext.java.JCClass;
import org.netbeans.editor.ext.java.JCConstructor;
import org.netbeans.editor.ext.java.JCExpression;
import org.netbeans.editor.ext.java.JCField;
import org.netbeans.editor.ext.java.JCFinder;
import org.netbeans.editor.ext.java.JCMethod;
import org.netbeans.editor.ext.java.JCPackage;
import org.netbeans.editor.ext.java.JCParameter;
import org.netbeans.editor.ext.java.JCTokenProcessor;
import org.netbeans.editor.ext.java.JCType;
import org.netbeans.editor.ext.java.JCUtilities;
import org.netbeans.editor.ext.java.JavaCompletion;
import org.netbeans.editor.ext.java.JavaSyntaxSupport;

public class JavaCompletionQuery
implements CompletionQuery {
    static /* synthetic */ Class class$org$netbeans$editor$ext$java$JavaSyntaxSupport;

    public CompletionQuery.Result query(JTextComponent component, int offset, SyntaxSupport support) {
        return this.query(component, offset, support, false);
    }

    public CompletionQuery.Result query(JTextComponent component, int offset, SyntaxSupport support, boolean sourceHelp) {
        BaseDocument doc = (BaseDocument)component.getDocument();
        JavaSyntaxSupport sup = (JavaSyntaxSupport)support.get(class$org$netbeans$editor$ext$java$JavaSyntaxSupport == null ? (class$org$netbeans$editor$ext$java$JavaSyntaxSupport = JavaCompletionQuery.class$("org.netbeans.editor.ext.java.JavaSyntaxSupport")) : class$org$netbeans$editor$ext$java$JavaSyntaxSupport);
        JavaResult ret = null;
        try {
            int lastSepOffset = sup.getLastCommandSeparator(offset);
            JCTokenProcessor tp = new JCTokenProcessor(offset);
            sup.tokenizeText(tp, lastSepOffset + 1, offset, true);
            boolean errState = false;
            TokenID lastValidTokenID = tp.getLastValidTokenID();
            if (lastValidTokenID != null) {
                switch (lastValidTokenID.getNumericID()) {
                    case 25: {
                        errState = true;
                        break;
                    }
                    case 8: {
                        if (tp.getLastValidTokenText() != null && tp.getLastValidTokenText().endsWith("*/")) break;
                        errState = true;
                        break;
                    }
                    case 7: {
                        errState = true;
                    }
                }
            }
            if (!errState) {
                sup.refreshClassInfo();
                Context ctx = new Context(tp, component, sup, sourceHelp, offset);
                JCExpression exp = tp.getResultExp();
                ctx.resolveExp(exp);
                ret = ctx.result;
            }
        }
        catch (BadLocationException e) {
            e.printStackTrace();
        }
        return ret;
    }

    static List findFieldsAndMethods(JCFinder finder, String curPkg, JCClass cls, String name, boolean exactMatch, boolean staticOnly, boolean inspectOuterClasses) {
        JCPackage pkg;
        List ret = new ArrayList();
        if (staticOnly && (pkg = finder.getExactPackage(cls.getPackageName())) != null) {
            ret = finder.findClasses(pkg, cls.getName() + '.' + name, false);
        }
        if (finder instanceof JCBaseFinder) {
            ret.addAll(((JCBaseFinder)finder).findFields(curPkg, cls, name, exactMatch, staticOnly, inspectOuterClasses));
            ret.addAll(((JCBaseFinder)finder).findMethods(curPkg, cls, name, exactMatch, staticOnly, inspectOuterClasses));
        } else {
            ret.addAll(finder.findFields(cls, name, exactMatch, staticOnly, inspectOuterClasses));
            ret.addAll(finder.findMethods(cls, name, exactMatch, staticOnly, inspectOuterClasses));
        }
        return ret;
    }

    private static String formatTypeList(List typeList, boolean methodOpen) {
        StringBuffer sb = new StringBuffer();
        if (typeList.size() > 0) {
            int cntM1 = typeList.size() - 1;
            for (int i = 0; i <= cntM1; ++i) {
                JCType t = (JCType)typeList.get(i);
                if (t != null) {
                    sb.append(t.format(false));
                } else {
                    sb.append('?');
                }
                if (i >= cntM1) continue;
                sb.append(", ");
            }
            if (methodOpen) {
                sb.append(", *");
            }
        } else if (methodOpen) {
            sb.append("*");
        }
        return sb.toString();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public static class JavaResult
    extends CompletionQuery.AbstractResult {
        private int classDisplayOffset;
        private JCExpression substituteExp;
        private int substituteOffset;
        private int substituteLength;
        private JTextComponent component;

        public JavaResult(JTextComponent component, List data, String title, JCExpression substituteExp, int classDisplayOffset) {
            this(component, data, title, substituteExp, substituteExp.getTokenOffset(0), substituteExp.getTokenLength(0), classDisplayOffset);
        }

        public JavaResult(JTextComponent component, List data, String title, JCExpression substituteExp, int substituteOffset, int substituteLength, int classDisplayOffset) {
            super(data, title);
            this.component = component;
            this.substituteExp = substituteExp;
            this.substituteOffset = substituteOffset;
            this.substituteLength = substituteLength;
            this.classDisplayOffset = classDisplayOffset;
        }

        protected JTextComponent getComponent() {
            return this.component;
        }

        protected int getSubstituteLength() {
            return this.substituteLength;
        }

        protected int getSubstituteOffset() {
            return this.substituteOffset;
        }

        protected JCExpression getSubstituteExp() {
            return this.substituteExp;
        }

        protected int getClassDisplayOffset() {
            return this.classDisplayOffset;
        }

        protected String getMainText(Object dataItem) {
            String text = null;
            if (dataItem instanceof JCPackage) {
                text = ((JCPackage)dataItem).getLastName();
            } else if (dataItem instanceof JCClass) {
                text = ((JCClass)dataItem).getName();
                if (this.classDisplayOffset > 0 && this.classDisplayOffset < text.length()) {
                    text = text.substring(this.classDisplayOffset);
                }
            } else if (dataItem instanceof JCField) {
                text = ((JCField)dataItem).getName();
            } else if (dataItem instanceof JCMethod) {
                JCMethod mtd = (JCMethod)dataItem;
                text = mtd.getName();
            } else if (dataItem instanceof JCConstructor) {
                text = ((JCConstructor)dataItem).getClazz().getName();
            }
            return text;
        }

        protected String getCommonText(String prefix) {
            List data = this.getData();
            int cnt = data.size();
            int prefixLen = prefix.length();
            String commonText = null;
            for (int i = 0; i < cnt; ++i) {
                int commonInd;
                String mainText = this.getMainText(data.get(i));
                if (mainText == null || !mainText.startsWith(prefix)) continue;
                mainText = mainText.substring(prefixLen);
                if (commonText == null) {
                    commonText = mainText;
                }
                int minLen = Math.min(mainText.length(), commonText.length());
                for (commonInd = 0; commonInd < minLen && mainText.charAt(commonInd) == commonText.charAt(commonInd); ++commonInd) {
                }
                if (commonInd != 0) {
                    commonText = commonText.substring(0, commonInd);
                    continue;
                }
                return null;
            }
            return prefix + (commonText != null ? commonText : "");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean substituteCommonText(int dataIndex) {
            block6: {
                BaseDocument doc = (BaseDocument)this.component.getDocument();
                try {
                    String prefix = doc.getText(this.substituteOffset, this.substituteLength);
                    String commonText = this.getCommonText(prefix);
                    if (commonText == null) break block6;
                    if (this.substituteExp != null && (this.substituteExp.getExpID() == 10 || this.substituteExp.getExpID() == 11)) {
                        return true;
                    }
                    doc.atomicLock();
                    try {
                        doc.remove(this.substituteOffset, this.substituteLength);
                        doc.insertString(this.substituteOffset, commonText, null);
                    }
                    finally {
                        doc.atomicUnlock();
                    }
                }
                catch (BadLocationException badLocationException) {
                    // empty catch block
                }
            }
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean substituteText(int dataIndex, boolean shift) {
            int selectionEndOffset;
            int selectionStartOffset;
            String text;
            BaseDocument doc;
            block24: {
                Object replacement;
                block27: {
                    block26: {
                        block25: {
                            block23: {
                                doc = (BaseDocument)this.component.getDocument();
                                text = null;
                                selectionStartOffset = -1;
                                selectionEndOffset = -1;
                                replacement = this.getData().get(dataIndex);
                                if (!(replacement instanceof JCPackage)) break block23;
                                text = ((JCPackage)replacement).getLastName();
                                break block24;
                            }
                            if (!(replacement instanceof JCClass)) break block25;
                            text = ((JCClass)replacement).getName();
                            if (this.classDisplayOffset > 0 && this.classDisplayOffset < text.length()) {
                                text = text.substring(this.classDisplayOffset);
                            }
                            break block24;
                        }
                        if (!(replacement instanceof JCField)) break block26;
                        text = ((JCField)replacement).getName();
                        break block24;
                    }
                    if (!(replacement instanceof JCConstructor)) break block27;
                    JCConstructor mtd = (JCConstructor)replacement;
                    switch (this.substituteExp != null ? this.substituteExp.getExpID() : -1) {
                        case 11: {
                            break;
                        }
                        case 10: {
                            Object o;
                            JCParameter[] parms = mtd.getParameters();
                            if (parms.length == 0) {
                                text = ")";
                                break;
                            }
                            int ind = this.substituteExp.getParameterCount();
                            boolean addSpace = false;
                            Formatter f = doc.getFormatter();
                            if (f instanceof ExtFormatter && (o = ((ExtFormatter)f).getSettingValue("java-format-space-after-comma")) instanceof Boolean && ((Boolean)o).booleanValue()) {
                                addSpace = true;
                            }
                            try {
                                if (addSpace && (ind == 0 || this.substituteOffset > 0 && Character.isWhitespace(doc.getText(this.substituteOffset - 1, 1).charAt(0)))) {
                                    addSpace = false;
                                }
                            }
                            catch (BadLocationException e) {
                                // empty catch block
                            }
                            if (ind < parms.length) {
                                text = addSpace ? " " : "";
                                selectionStartOffset = text.length();
                                text = text + parms[ind].getName();
                                selectionEndOffset = text.length();
                                break;
                            }
                            break block24;
                        }
                        default: {
                            Object o;
                            text = this.getMainText(replacement);
                            boolean addSpace = false;
                            Formatter f = doc.getFormatter();
                            if (f instanceof ExtFormatter && (o = ((ExtFormatter)f).getSettingValue("java-format-space-before-parenthesis")) instanceof Boolean && ((Boolean)o).booleanValue()) {
                                addSpace = true;
                            }
                            if (addSpace) {
                                text = text + ' ';
                            }
                            text = text + '(';
                            JCParameter[] parms = mtd.getParameters();
                            if (parms.length > 0) {
                                selectionStartOffset = text.length();
                                text = text + parms[0].getName();
                                selectionEndOffset = text.length();
                                break;
                            }
                            text = text + ")";
                        }
                    }
                    break block24;
                }
                if (replacement instanceof JCConstructor) {
                    text = ((JCConstructor)replacement).getClazz().getName();
                }
            }
            if (text != null) {
                doc.atomicLock();
                try {
                    doc.remove(this.substituteOffset, this.substituteLength);
                    doc.insertString(this.substituteOffset, text, null);
                    if (selectionStartOffset >= 0) {
                        this.component.select(this.substituteOffset + selectionStartOffset, this.substituteOffset + selectionEndOffset);
                    }
                }
                catch (BadLocationException e) {
                }
                finally {
                    doc.atomicUnlock();
                }
            }
            return true;
        }
    }

    static class Context {
        private JCTokenProcessor tp;
        private JTextComponent component;
        private JavaSyntaxSupport sup;
        private boolean sourceHelp;
        private int endOffset;
        private boolean findType;
        private boolean staticOnly = true;
        private JCPackage lastPkg;
        private JCType lastType;
        private JavaResult result;
        private boolean isConstructor;

        public Context(JCTokenProcessor tp, JTextComponent component, JavaSyntaxSupport sup, boolean sourceHelp, int endOffset) {
            this.tp = tp;
            this.component = component;
            this.sup = sup;
            this.sourceHelp = sourceHelp;
            this.endOffset = endOffset;
        }

        public void setFindType(boolean findType) {
            this.findType = findType;
        }

        protected Object clone() {
            return new Context(this.tp, this.component, this.sup, this.sourceHelp, this.endOffset);
        }

        private String formatName(String name, boolean appendStar) {
            return name != null ? (appendStar ? name + '*' : name) : (appendStar ? "*" : "");
        }

        private String formatType(JCType type, boolean useFullName, boolean appendDot, boolean appendStar) {
            StringBuffer sb = new StringBuffer();
            if (type != null) {
                sb.append(type.format(useFullName));
            }
            if (appendDot) {
                sb.append('.');
            }
            if (appendStar) {
                sb.append('*');
            }
            return sb.toString();
        }

        private JCType resolveType(JCExpression exp) {
            Context ctx = (Context)this.clone();
            ctx.setFindType(true);
            JCType typ = null;
            if (ctx.resolveExp(exp)) {
                typ = ctx.lastType;
            }
            return typ;
        }

        boolean resolveExp(JCExpression exp) {
            boolean lastDot = false;
            JCFinder finder = JavaCompletion.getFinder();
            boolean ok = true;
            switch (exp.getExpID()) {
                case 5: {
                    lastDot = true;
                }
                case 4: {
                    List<JCClass> res;
                    int parmCnt = exp.getParameterCount();
                    for (int i = 0; i < parmCnt && ok; ++i) {
                        ok = this.resolveItem(exp.getParameter(i), i == 0, !lastDot && i == parmCnt - 1);
                    }
                    if (!ok || !lastDot) break;
                    int tokenCntM1 = exp.getTokenCount() - 1;
                    int substPos = exp.getTokenOffset(tokenCntM1) + exp.getTokenLength(tokenCntM1);
                    if (this.lastType != null) {
                        List<JCClass> res2;
                        JCClass cls = this.lastType.getArrayDepth() == 0 ? this.lastType.getClazz() : JavaCompletion.OBJECT_CLASS_ARRAY;
                        if (this.sourceHelp) {
                            res2 = new ArrayList<JCClass>();
                            res2.add(this.lastType.getClazz());
                        } else {
                            JCClass curCls = this.sup.getClass(exp.getTokenOffset(tokenCntM1));
                            res2 = JavaCompletionQuery.findFieldsAndMethods(finder, curCls == null ? null : curCls.getPackageName(), cls, "", false, this.staticOnly, false);
                        }
                        this.result = new JavaResult(this.component, res2, this.formatType(this.lastType, true, true, true), exp, substPos, 0, cls.getName().length() + 1);
                        break;
                    }
                    String searchPkg = this.lastPkg.getName() + '.';
                    if (this.sourceHelp) {
                        res = new ArrayList<JCPackage>();
                        res.add((JCClass)((Object)this.lastPkg));
                    } else {
                        res = finder.findPackages(searchPkg, false, false);
                        String text = null;
                        try {
                            int firstTokenIdx = exp.getTokenOffset(0);
                            int cmdStartIdx = this.sup.getLastCommandSeparator(firstTokenIdx);
                            if (cmdStartIdx < 0) {
                                text = this.sup.getDocument().getText(0, firstTokenIdx);
                                cmdStartIdx = text.lastIndexOf(10);
                                if (cmdStartIdx != -1) {
                                    text = text.substring(cmdStartIdx + 1);
                                }
                            } else {
                                text = this.sup.getDocument().getText(cmdStartIdx, firstTokenIdx - cmdStartIdx);
                            }
                        }
                        catch (BadLocationException e) {
                            // empty catch block
                        }
                        if (text != null && -1 == text.indexOf("package")) {
                            res.addAll(Arrays.asList(this.lastPkg.getClasses()));
                        }
                    }
                    this.result = new JavaResult(this.component, res, searchPkg + '*', exp, substPos, 0, 0);
                    break;
                }
                case 15: {
                    List res = finder.findClasses(null, "", false);
                    this.result = new JavaResult(this.component, res, "*", exp, this.endOffset, 0, 0);
                    break;
                }
                default: {
                    ok = this.resolveItem(exp, true, true);
                }
            }
            return ok;
        }

        boolean resolveItem(JCExpression item, boolean first, boolean last) {
            boolean cont = true;
            boolean methodOpen = false;
            JCFinder finder = JavaCompletion.getFinder();
            block0 : switch (item.getExpID()) {
                case 0: {
                    if (first) {
                        this.lastType = item.getType();
                        this.staticOnly = false;
                        break;
                    }
                    cont = false;
                    break;
                }
                case 1: {
                    switch (item.getTokenID(0).getNumericID()) {
                        case 108: {
                            if (first) {
                                JCClass cls = this.sup.getClass(item.getTokenOffset(0));
                                if (cls == null) break block0;
                                this.lastType = JavaCompletion.getType(cls, 0);
                                this.staticOnly = false;
                                break;
                            }
                            this.staticOnly = false;
                            break;
                        }
                        case 105: {
                            if (first) {
                                JCClass cls = this.sup.getClass(item.getTokenOffset(0));
                                if (cls == null || (cls = finder.getExactClass(cls.getFullName())) == null || (cls = cls.getSuperclass()) == null) break block0;
                                this.lastType = JavaCompletion.getType(cls, 0);
                                this.staticOnly = false;
                                break;
                            }
                            cont = false;
                            break;
                        }
                        case 77: {
                            if (!first) {
                                this.lastType = JavaCompletion.CLASS_TYPE;
                                this.staticOnly = false;
                                break;
                            }
                            cont = false;
                            break;
                        }
                        default: {
                            String var = item.getTokenText(0);
                            int varPos = item.getTokenOffset(0);
                            if (first) {
                                if (last && !this.findType) {
                                    ArrayList res = new ArrayList();
                                    JCClass cls = this.sup.getClass(varPos);
                                    if (cls != null) {
                                        res.addAll(JavaCompletionQuery.findFieldsAndMethods(finder, cls.getPackageName(), cls, var, false, this.sup.isStaticBlock(varPos), true));
                                    }
                                    if (var.length() > 0 || !this.sourceHelp) {
                                        res.addAll(finder.findPackages(var, false, false));
                                        if (var.length() > 0) {
                                            res.addAll(finder.findClasses(null, var, false));
                                            if (cls != null) {
                                                JCPackage pkg = finder.getExactPackage(cls.getPackageName());
                                                List lst = finder.findClasses(pkg, cls.getName() + "." + var, false);
                                                for (int i = 0; i < lst.size(); ++i) {
                                                    if (res.contains(lst.get(i))) continue;
                                                    res.add(lst.get(i));
                                                }
                                            }
                                            List importedCls = this.sup.getImportedInnerClasses();
                                            for (int i = 0; i < importedCls.size(); ++i) {
                                                JCClass iCls = (JCClass)importedCls.get(i);
                                                if (iCls.getName().indexOf("." + var) <= 0 || res.contains(iCls)) continue;
                                                res.add(iCls);
                                            }
                                        }
                                    }
                                    this.result = new JavaResult(this.component, res, var + '*', item, 0);
                                    break;
                                }
                                this.lastType = (JCType)this.sup.findType(var, varPos);
                                if (this.lastType != null) {
                                    this.staticOnly = false;
                                    break;
                                }
                                this.lastPkg = finder.getExactPackage(var);
                                if (this.lastPkg != null) break block0;
                                JCClass cls = this.sup.getClassFromName(var, true);
                                if (cls != null) {
                                    this.lastType = JavaCompletion.getType(cls, 0);
                                    break;
                                }
                                cont = false;
                                break;
                            }
                            if (this.lastType != null) {
                                if (this.findType || !last) {
                                    JCClass cls;
                                    boolean inner = false;
                                    int ad = this.lastType.getArrayDepth();
                                    if (this.staticOnly && ad == 0 && (cls = finder.getExactClass(this.lastType.getClazz().getFullName() + "." + var)) != null) {
                                        this.lastType = JavaCompletion.getType(cls, 0);
                                        inner = true;
                                    }
                                    if (inner) break block0;
                                    if (ad == 0) {
                                        List fldList = finder.findFields(this.lastType.getClazz(), var, true, this.staticOnly, false);
                                        if (fldList.size() > 0) {
                                            JCField fld = (JCField)fldList.get(0);
                                            this.lastType = fld.getType();
                                            this.staticOnly = false;
                                            break;
                                        }
                                        this.lastType = null;
                                        cont = false;
                                        break;
                                    }
                                    cont = false;
                                    break;
                                }
                                JCClass curCls = this.sup.getClass(varPos);
                                JCClass cls = this.lastType.getArrayDepth() == 0 ? this.lastType.getClazz() : JavaCompletion.OBJECT_CLASS_ARRAY;
                                this.result = new JavaResult(this.component, JavaCompletionQuery.findFieldsAndMethods(finder, curCls == null ? null : curCls.getPackageName(), cls, var, false, this.staticOnly, false), this.lastType.format(false) + '.' + var + '*', item, cls.getName().length() + 1);
                                break;
                            }
                            String searchName = this.lastPkg.getName() + '.' + var;
                            if (this.findType || !last) {
                                this.lastPkg = finder.getExactPackage(searchName);
                                if (this.lastPkg != null) break block0;
                                JCClass cls = finder.getExactClass(searchName);
                                if (cls != null) {
                                    this.lastType = JavaCompletion.getType(cls, 0);
                                    break;
                                }
                                this.lastType = null;
                                cont = false;
                                break;
                            }
                            if (!last) break block0;
                            String searchPkg = this.lastPkg.getName() + '.' + var;
                            List res = finder.findPackages(searchPkg, false, false);
                            res.addAll(finder.findClasses(this.lastPkg, var, false));
                            this.result = new JavaResult(this.component, res, searchPkg + '*', item, 0);
                            break;
                        }
                    }
                    break;
                }
                case 7: {
                    cont = this.resolveItem(item.getParameter(0), first, false);
                    if (!cont) break;
                    cont = false;
                    if (this.lastType == null) break;
                    if (item.getParameterCount() == 2) {
                        JCType arrayType = this.resolveType(item.getParameter(1));
                        if (arrayType == null || !arrayType.equals(JavaCompletion.INT_TYPE)) break;
                        this.lastType = JavaCompletion.getType(this.lastType.getClazz(), Math.max(this.lastType.getArrayDepth() - 1, 0));
                        cont = true;
                        break;
                    }
                    this.lastType = JavaCompletion.getType(this.lastType.getClazz(), this.lastType.getArrayDepth() + 1);
                    cont = true;
                    break;
                }
                case 16: {
                    this.lastType = JavaCompletion.BOOLEAN_TYPE;
                    break;
                }
                case 2: {
                    ArrayList res = new ArrayList();
                    JCClass curCls = this.sup.getClass(item.getTokenOffset(0));
                    if (curCls != null) {
                        res.addAll(JavaCompletionQuery.findFieldsAndMethods(finder, curCls.getPackageName(), curCls, "", false, this.sup.isStaticBlock(item.getTokenOffset(0)), true));
                    }
                    res.addAll(finder.findPackages("", false, false));
                    res.addAll(finder.findClasses(null, "", false));
                    this.result = new JavaResult(this.component, res, "*", item, this.endOffset, 0, 0);
                    switch (item.getTokenID(0).getNumericID()) {
                        case 17: 
                        case 36: 
                        case 37: 
                        case 38: 
                        case 39: 
                        case 40: 
                        case 41: 
                        case 42: 
                        case 43: 
                        case 44: 
                        case 45: 
                        case 46: {
                            if (item.getParameterCount() <= 0) break;
                            this.lastType = this.resolveType(item.getParameter(0));
                            this.staticOnly = false;
                            break;
                        }
                        case 18: 
                        case 19: 
                        case 33: 
                        case 34: 
                        case 35: 
                        case 47: 
                        case 61: 
                        case 62: {
                            this.lastType = JavaCompletion.BOOLEAN_TYPE;
                            break;
                        }
                        case 20: 
                        case 21: 
                        case 22: 
                        case 23: 
                        case 24: 
                        case 25: 
                        case 26: 
                        case 27: 
                        case 28: 
                        case 29: 
                        case 30: {
                            switch (item.getParameterCount()) {
                                case 2: {
                                    JCType typ1 = this.resolveType(item.getParameter(0));
                                    JCType typ2 = this.resolveType(item.getParameter(1));
                                    if (typ1 == null || typ2 == null || typ1.getArrayDepth() != 0 || typ2.getArrayDepth() != 0 || !JavaCompletion.isPrimitiveClass(typ1.getClazz()) || !JavaCompletion.isPrimitiveClass(typ2.getClazz())) break;
                                    this.lastType = JCUtilities.getCommonType(typ1, typ2);
                                    break;
                                }
                                case 1: {
                                    JCType typ = this.resolveType(item.getParameter(0));
                                    if (typ == null || !JavaCompletion.isPrimitiveClass(typ.getClazz())) break;
                                    this.lastType = typ;
                                }
                            }
                            break;
                        }
                        case 50: {
                            switch (item.getParameterCount()) {
                                case 2: {
                                    JCType typ1 = this.resolveType(item.getParameter(0));
                                    JCType typ2 = this.resolveType(item.getParameter(1));
                                    if (typ1 == null || typ2 == null) break;
                                    this.lastType = JCUtilities.getCommonType(typ1, typ2);
                                    break;
                                }
                                case 1: {
                                    this.lastType = this.resolveType(item.getParameter(0));
                                }
                            }
                            break;
                        }
                        case 52: {
                            if (item.getParameterCount() < 2) break;
                            this.lastType = this.resolveType(item.getParameter(1));
                        }
                    }
                    break;
                }
                case 3: {
                    if (item.getParameterCount() <= 0) break;
                    this.lastType = this.resolveType(item.getParameter(0));
                    break;
                }
                case 13: {
                    this.lastType = this.resolveType(item.getParameter(0));
                    this.staticOnly = false;
                    break;
                }
                case 14: {
                    this.lastType = item.getType();
                    break;
                }
                case 9: {
                    cont = this.resolveItem(item.getParameter(0), first, last);
                    break;
                }
                case 12: {
                    this.isConstructor = true;
                    cont = this.resolveExp(item.getParameter(0));
                    this.staticOnly = false;
                    break;
                }
                case 10: {
                    methodOpen = true;
                }
                case 11: {
                    List filtered;
                    List typeList;
                    String parmStr;
                    JCClass cls;
                    String mtdName = item.getTokenText(0);
                    if ("this".equals(mtdName) && item.getTokenCount() > 0 && (cls = this.sup.getClass(item.getTokenOffset(0))) != null && (cls = finder.getExactClass(cls.getFullName())) != null) {
                        this.isConstructor = true;
                        mtdName = cls.getName();
                    }
                    if ("super".equals(mtdName) && item.getTokenCount() > 0 && (cls = this.sup.getClass(item.getTokenOffset(0))) != null && (cls = finder.getExactClass(cls.getFullName())) != null && (cls = cls.getSuperclass()) != null) {
                        this.isConstructor = true;
                        mtdName = cls.getName();
                    }
                    if (this.isConstructor) {
                        cls = null;
                        if (first) {
                            cls = this.sup.getClassFromName(mtdName, true);
                        } else if (last && this.lastPkg != null) {
                            cls = JCUtilities.getExactClass(finder, mtdName, this.lastPkg.getName());
                        } else if (this.lastType != null) {
                            cls = last ? JCUtilities.getExactClass(finder, mtdName, this.lastType.getClazz().getFullName()) : (this.lastType.getArrayDepth() == 0 ? this.lastType.getClazz() : JavaCompletion.OBJECT_CLASS_ARRAY);
                        }
                        if (cls != null) {
                            List mtdList;
                            this.lastType = JavaCompletion.getType(cls, 0);
                            List ctrList = finder instanceof JCBaseFinder ? JCUtilities.getConstructors(cls, ((JCBaseFinder)finder).getShowDeprecated()) : JCUtilities.getConstructors(cls);
                            parmStr = "*";
                            typeList = this.getTypeList(item);
                            filtered = JCUtilities.filterMethods(ctrList, typeList, methodOpen);
                            if (filtered.size() > 0) {
                                ctrList = filtered;
                                parmStr = JavaCompletionQuery.formatTypeList(typeList, methodOpen);
                            }
                            if ((mtdList = finder.findMethods(cls, mtdName, true, false, first)).size() > 0) {
                                if (last && !this.findType) {
                                    this.result = new JavaResult(this.component, mtdList, this.lastType.getClazz().getFullName() + '.' + mtdName + '(' + parmStr + ')', item, this.endOffset, 0, 0);
                                } else {
                                    this.lastType = ((JCMethod)mtdList.get(0)).getReturnType();
                                    this.staticOnly = false;
                                }
                            } else {
                                this.result = new JavaResult(this.component, ctrList, mtdName + '(' + parmStr + ')', item, this.endOffset, 0, 0);
                            }
                        } else {
                            this.isConstructor = false;
                        }
                    }
                    if (this.isConstructor) break;
                    if (first && (cls = this.sup.getClass(item.getTokenOffset(0))) != null) {
                        this.lastType = JavaCompletion.getType(cls, 0);
                    }
                    if (this.lastType != null) {
                        cls = this.lastType.getArrayDepth() == 0 ? this.lastType.getClazz() : JavaCompletion.OBJECT_CLASS_ARRAY;
                        List mtdList = finder.findMethods(cls, mtdName, true, false, first);
                        parmStr = "*";
                        typeList = this.getTypeList(item);
                        filtered = JCUtilities.filterMethods(mtdList, typeList, methodOpen);
                        if (filtered.size() > 0) {
                            mtdList = filtered;
                            parmStr = JavaCompletionQuery.formatTypeList(typeList, methodOpen);
                        }
                        if (mtdList.size() > 0) {
                            if (last && !this.findType) {
                                this.result = new JavaResult(this.component, mtdList, this.lastType.getClazz().getFullName() + '.' + mtdName + '(' + parmStr + ')', item, this.endOffset, 0, 0);
                                break;
                            }
                            if (mtdList.size() <= 0) break;
                            this.lastType = ((JCMethod)mtdList.get(0)).getReturnType();
                            this.staticOnly = false;
                            break;
                        }
                        this.lastType = null;
                        cont = false;
                        break;
                    }
                    this.lastPkg = null;
                    cont = false;
                }
            }
            if (this.lastType == null && this.lastPkg == null) {
                cont = false;
            }
            return cont;
        }

        private List getTypeList(JCExpression item) {
            int parmCnt = item.getParameterCount();
            ArrayList<JCType> typeList = new ArrayList<JCType>();
            if (parmCnt > 0) {
                boolean methodOpen = item.getExpID() == 10;
                for (int i = 0; i < parmCnt; ++i) {
                    JCExpression parm = item.getParameter(i);
                    JCType typ = this.resolveType(parm);
                    typeList.add(typ);
                }
            }
            return typeList;
        }
    }
}

