/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.editor.ext.html;

import java.awt.Color;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.text.BadLocationException;
import javax.swing.text.Caret;
import javax.swing.text.JTextComponent;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.SettingsUtil;
import org.netbeans.editor.SyntaxSupport;
import org.netbeans.editor.TokenID;
import org.netbeans.editor.TokenItem;
import org.netbeans.editor.Utilities;
import org.netbeans.editor.ext.CompletionQuery;
import org.netbeans.editor.ext.html.HTMLSettingsDefaults;
import org.netbeans.editor.ext.html.HTMLSyntaxSupport;
import org.netbeans.editor.ext.html.HTMLTokenContext;
import org.netbeans.editor.ext.html.SyntaxElement;
import org.netbeans.editor.ext.html.dtd.DTD;

public class HTMLCompletionQuery
implements CompletionQuery {
    private static boolean lowerCase;
    static /* synthetic */ Class class$org$netbeans$editor$ext$html$HTMLSyntaxSupport;

    public CompletionQuery.Result query(JTextComponent component, int offset, SyntaxSupport support) {
        BaseDocument doc;
        Class kitClass = Utilities.getKitClass(component);
        if (kitClass != null) {
            lowerCase = SettingsUtil.getBoolean(kitClass, "completion-lower-case", HTMLSettingsDefaults.defaultCompletionLowerCase);
        }
        if ((doc = (BaseDocument)component.getDocument()).getLength() == 0) {
            return null;
        }
        HTMLSyntaxSupport sup = (HTMLSyntaxSupport)support.get(class$org$netbeans$editor$ext$html$HTMLSyntaxSupport == null ? (class$org$netbeans$editor$ext$html$HTMLSyntaxSupport = HTMLCompletionQuery.class$("org.netbeans.editor.ext.html.HTMLSyntaxSupport")) : class$org$netbeans$editor$ext$html$HTMLSyntaxSupport);
        if (sup == null) {
            return null;
        }
        DTD dtd = sup.getDTD();
        if (dtd == null) {
            return null;
        }
        try {
            boolean begin;
            TokenItem item = null;
            TokenItem prev = null;
            boolean inside = false;
            item = sup.getTokenChain(offset, offset + 1);
            if (item != null) {
                prev = item.getPrevious();
                if (prev != null) {
                    int index;
                    TokenItem prevv = prev;
                    String prevvImage = prevv.getImage();
                    for (index = prevvImage.length() - 1; index > -1 && !Character.isLetter(prevvImage.charAt(index)); --index) {
                    }
                    while (index == -1 && prevv != null) {
                        while (prevv != null && (prevv.getTokenID().getNumericID() != 4 && prevv.getTokenID().getNumericID() != 5 || prevv.getImage().trim().equals(">"))) {
                            prevv = prevv.getPrevious();
                        }
                        if (prevv == null) continue;
                        prevvImage = prevv.getImage();
                        for (index = 0; index < prevvImage.length() && !Character.isLetter(prevvImage.charAt(index)); ++index) {
                        }
                        if (index != prevvImage.length()) continue;
                        index = -1;
                        prevv = prevv.getPrevious();
                    }
                    lowerCase = prevv != null && index != -1 ? !Character.isUpperCase(prevvImage.charAt(index)) : true;
                }
                inside = item.getOffset() < offset;
            } else {
                prev = sup.getTokenChain(offset - 1, offset);
            }
            boolean bl = begin = prev == null && !inside;
            if (begin) {
                return null;
            }
            TokenID id = null;
            List l = null;
            int len = 1;
            int itemOffset = 0;
            String preText = null;
            if (inside) {
                id = item.getTokenID();
                preText = item.getImage().substring(0, offset - item.getOffset());
                itemOffset = item.getOffset();
            } else {
                id = prev.getTokenID();
                preText = prev.getImage().substring(0, offset - prev.getOffset());
                itemOffset = prev.getOffset();
            }
            if ((id == HTMLTokenContext.TEXT || id == HTMLTokenContext.VALUE) && preText.endsWith("&")) {
                l = this.translateCharRefs(offset - len, len, dtd.getCharRefList(""));
            } else if (id == HTMLTokenContext.CHARACTER) {
                if (inside || !preText.endsWith(";")) {
                    len = offset - itemOffset;
                    l = this.translateCharRefs(offset - len, len, dtd.getCharRefList(preText.substring(1)));
                }
            } else if (id == HTMLTokenContext.TEXT && preText.endsWith("<")) {
                l = this.translateTags(offset - len, len, dtd.getElementList(""));
            } else if (id == HTMLTokenContext.TAG && preText.startsWith("<") && !preText.startsWith("</")) {
                len = offset - itemOffset;
                l = this.translateTags(offset - len, len, dtd.getElementList(preText.substring(1)));
            } else if (id == HTMLTokenContext.TEXT && preText.endsWith("</")) {
                len = 2;
                l = sup.getPossibleEndTags(offset, "");
            } else if (id == HTMLTokenContext.TAG && preText.startsWith("</")) {
                len = offset - itemOffset;
                l = sup.getPossibleEndTags(offset, preText.substring(2));
            } else if (id == HTMLTokenContext.WS || id == HTMLTokenContext.ARGUMENT) {
                SyntaxElement elem = null;
                try {
                    elem = sup.getElementChain(offset);
                    if (elem == null) {
                        elem = sup.getElementChain(offset - 1);
                    }
                }
                catch (BadLocationException e) {
                    return null;
                }
                if (elem == null) {
                    return null;
                }
                if (elem.getType() == 4) {
                    SyntaxElement.Tag tagElem = (SyntaxElement.Tag)elem;
                    String tagName = tagElem.getName().toUpperCase();
                    DTD.Element tag = dtd.getElement(tagName);
                    if (tag == null) {
                        return null;
                    }
                    String prefix = id == HTMLTokenContext.ARGUMENT ? preText : "";
                    len = prefix.length();
                    List possible = tag.getAttributeList(prefix);
                    Collection existing = tagElem.getAttributes();
                    String wordAtCursor = "";
                    try {
                        wordAtCursor = Utilities.getWord(doc, Utilities.getWordStart(doc, offset));
                    }
                    catch (BadLocationException e) {
                        // empty catch block
                    }
                    if (wordAtCursor == null) {
                        wordAtCursor = "";
                    }
                    l = new ArrayList();
                    Iterator i = possible.iterator();
                    while (i.hasNext()) {
                        DTD.Attribute attr = (DTD.Attribute)i.next();
                        String aName = attr.getName();
                        if (!aName.equals(prefix) && (existing.contains(aName.toUpperCase()) || existing.contains(aName.toLowerCase())) && !wordAtCursor.equals(aName)) continue;
                        l.add(attr);
                    }
                    l = this.translateAttribs(offset - len, len, l);
                }
            } else if (id == HTMLTokenContext.VALUE || id == HTMLTokenContext.OPERATOR || id == HTMLTokenContext.WS && (inside ? prev : prev.getPrevious()).getTokenID() == HTMLTokenContext.OPERATOR) {
                SyntaxElement elem = null;
                try {
                    elem = sup.getElementChain(offset);
                }
                catch (BadLocationException e) {
                    return null;
                }
                if (elem == null) {
                    return null;
                }
                if (elem.getType() == 2 && (elem = elem.getPrevious()) == null) {
                    return null;
                }
                if (elem.getType() == 4) {
                    TokenItem argItem;
                    SyntaxElement.Tag tagElem = (SyntaxElement.Tag)elem;
                    String tagName = tagElem.getName().toUpperCase();
                    DTD.Element tag = dtd.getElement(tagName);
                    if (tag == null) {
                        return null;
                    }
                    for (argItem = prev; argItem != null && argItem.getTokenID() != HTMLTokenContext.ARGUMENT; argItem = argItem.getPrevious()) {
                    }
                    if (argItem == null) {
                        return null;
                    }
                    String argName = argItem.getImage().toLowerCase();
                    DTD.Attribute arg = tag.getAttribute(argName);
                    if (arg == null || arg.getType() != 1) {
                        return null;
                    }
                    if (id != HTMLTokenContext.VALUE) {
                        len = 0;
                        l = this.translateValues(offset - len, len, arg.getValueList(""));
                    } else {
                        len = offset - itemOffset;
                        l = this.translateValues(offset - len, len, arg.getValueList(preText));
                    }
                }
            }
            if (l == null) {
                return null;
            }
            return new CompletionQuery.DefaultResult(component, "Results for DOCTYPE " + dtd.getIdentifier(), l, offset, len);
        }
        catch (BadLocationException e) {
            e.printStackTrace();
            return null;
        }
    }

    List translateCharRefs(int offset, int length, List refs) {
        ArrayList<CharRefItem> result = new ArrayList<CharRefItem>(refs.size());
        Iterator i = refs.iterator();
        while (i.hasNext()) {
            result.add(new CharRefItem(((DTD.CharRef)i.next()).getName(), offset, length));
        }
        return result;
    }

    List translateTags(int offset, int length, List tags) {
        ArrayList<TagItem> result = new ArrayList<TagItem>(tags.size());
        Iterator i = tags.iterator();
        while (i.hasNext()) {
            result.add(new TagItem(((DTD.Element)i.next()).getName(), offset, length));
        }
        return result;
    }

    List translateAttribs(int offset, int length, List attribs) {
        ArrayList<HTMLResultItem> result = new ArrayList<HTMLResultItem>(attribs.size());
        Iterator i = attribs.iterator();
        while (i.hasNext()) {
            DTD.Attribute attrib = (DTD.Attribute)i.next();
            String name = attrib.getName();
            switch (attrib.getType()) {
                case 0: {
                    result.add(new BooleanAttribItem(name, offset, length, attrib.isRequired()));
                    break;
                }
                case 1: {
                    result.add(new SetAttribItem(name, offset, length, attrib.isRequired()));
                    break;
                }
                case 2: {
                    result.add(new PlainAttribItem(name, offset, length, attrib.isRequired()));
                }
            }
        }
        return result;
    }

    List translateValues(int offset, int length, List values) {
        if (values == null) {
            return new ArrayList(0);
        }
        ArrayList<ValueItem> result = new ArrayList<ValueItem>(values.size());
        Iterator i = values.iterator();
        while (i.hasNext()) {
            result.add(new ValueItem(((DTD.Value)i.next()).getName(), offset, length));
        }
        return result;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static class ValueItem
    extends HTMLResultItem {
        public ValueItem(String name, int offset, int length) {
            super(name, offset, length);
        }

        Color getPaintColor() {
            return Color.magenta;
        }

        public boolean substituteText(JTextComponent c, int a, int b, boolean shift) {
            this.replaceText(c, shift ? this.baseText + " " : this.baseText);
            return !shift;
        }
    }

    private static class PlainAttribItem
    extends HTMLResultItem {
        boolean required;

        public PlainAttribItem(String name, int offset, int length, boolean required) {
            super(name, offset, length);
            this.required = required;
        }

        Color getPaintColor() {
            return this.required ? Color.red : Color.green.darker();
        }

        public boolean substituteText(JTextComponent c, int a, int b, boolean shift) {
            this.replaceText(c, this.baseText + "=''");
            if (shift) {
                Caret caret = c.getCaret();
                caret.setDot(caret.getDot() - 1);
            }
            return false;
        }
    }

    private static class BooleanAttribItem
    extends HTMLResultItem {
        boolean required;

        public BooleanAttribItem(String name, int offset, int length, boolean required) {
            super(name, offset, length);
            this.required = required;
        }

        Color getPaintColor() {
            return this.required ? Color.red : Color.green.darker();
        }

        public boolean substituteText(JTextComponent c, int a, int b, boolean shift) {
            this.replaceText(c, shift ? this.baseText + " " : this.baseText);
            return false;
        }
    }

    private static class SetAttribItem
    extends HTMLResultItem {
        boolean required;

        public SetAttribItem(String name, int offset, int length, boolean required) {
            super(name, offset, length);
            this.required = required;
        }

        Color getPaintColor() {
            return this.required ? Color.red : Color.green.darker();
        }

        String getPaintText() {
            return this.baseText;
        }

        public String getItemText() {
            return this.baseText + "=";
        }

        public boolean substituteText(JTextComponent c, int a, int b, boolean shift) {
            super.substituteText(c, 0, 0, shift);
            return false;
        }
    }

    private static class TagItem
    extends HTMLResultItem {
        public TagItem(String name, int offset, int length) {
            super(name, offset, length);
        }

        public boolean substituteText(JTextComponent c, int a, int b, boolean shift) {
            this.replaceText(c, "<" + this.baseText + (shift ? " >" : ">"));
            if (shift) {
                Caret caret = c.getCaret();
                caret.setDot(caret.getDot() - 1);
            }
            return !shift;
        }

        Color getPaintColor() {
            return Color.blue;
        }

        public String getItemText() {
            return "<" + this.baseText + ">";
        }
    }

    private static class CharRefItem
    extends HTMLResultItem {
        public CharRefItem(String name, int offset, int length) {
            super(name, offset, length);
        }

        Color getPaintColor() {
            return Color.red.darker();
        }

        public String getItemText() {
            return "&" + this.baseText + ";";
        }
    }

    static class EndTagItem
    extends HTMLResultItem {
        public EndTagItem(String baseText, int offset, int length) {
            super(baseText, offset, length);
        }

        Color getPaintColor() {
            return Color.blue;
        }

        public String getItemText() {
            return "</" + this.baseText + ">";
        }

        public boolean substituteText(JTextComponent c, int a, int b, boolean shift) {
            return super.substituteText(c, a, b, shift);
        }
    }

    private static abstract class HTMLResultItem
    implements CompletionQuery.ResultItem {
        static JLabel rubberStamp = new JLabel();
        String baseText;
        int offset;
        int length;

        public HTMLResultItem(String baseText, int offset, int length) {
            this.baseText = lowerCase ? baseText.toLowerCase() : baseText.toUpperCase();
            this.offset = offset;
            this.length = length;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        boolean replaceText(JTextComponent component, String text) {
            BaseDocument doc = (BaseDocument)component.getDocument();
            doc.atomicLock();
            try {
                doc.remove(this.offset, this.length);
                doc.insertString(this.offset, text, null);
            }
            catch (BadLocationException exc) {
                boolean bl = false;
                return bl;
            }
            finally {
                doc.atomicUnlock();
            }
            return true;
        }

        public boolean substituteCommonText(JTextComponent c, int a, int b, int subLen) {
            return this.replaceText(c, this.getItemText().substring(0, subLen));
        }

        public boolean substituteText(JTextComponent c, int a, int b, boolean shift) {
            return this.replaceText(c, this.getItemText());
        }

        public Component getPaintComponent(JList list, boolean isSelected, boolean cellHasFocus) {
            rubberStamp.setText(" " + this.getPaintText());
            if (isSelected) {
                rubberStamp.setBackground(list.getSelectionBackground());
                rubberStamp.setForeground(list.getSelectionForeground());
            } else {
                rubberStamp.setBackground(list.getBackground());
                rubberStamp.setForeground(this.getPaintColor());
            }
            return rubberStamp;
        }

        String getPaintText() {
            return this.getItemText();
        }

        abstract Color getPaintColor();

        public String getItemText() {
            return this.baseText;
        }

        static {
            rubberStamp.setOpaque(true);
        }
    }
}

