/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.editor.ext;

import java.awt.Color;
import java.awt.Insets;
import java.awt.Rectangle;
import java.io.IOException;
import java.io.StringReader;
import javax.swing.JEditorPane;
import javax.swing.SwingUtilities;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.EditorKit;
import javax.swing.text.html.HTMLEditorKit;
import org.netbeans.editor.ext.JavaDocView;

public class HTMLJavaDocView
extends JEditorPane
implements JavaDocView {
    private HTMLEditorKit htmlKit;

    public HTMLJavaDocView(Color bgColor) {
        this.setEditable(false);
        this.setBGColor(bgColor);
        this.setMargin(new Insets(0, 3, 3, 3));
    }

    public void setContent(final String content) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                StringReader in = new StringReader("<HTML><BODY>" + content + "</BODY></HTML>");
                try {
                    Document doc = HTMLJavaDocView.this.getDocument();
                    doc.remove(0, doc.getLength());
                    HTMLJavaDocView.this.getEditorKit().read(in, HTMLJavaDocView.this.getDocument(), 0);
                    HTMLJavaDocView.this.setCaretPosition(0);
                    HTMLJavaDocView.this.scrollRectToVisible(new Rectangle(0, 0, 0, 0));
                }
                catch (IOException ioe) {
                    ioe.printStackTrace();
                }
                catch (BadLocationException ble) {
                    ble.printStackTrace();
                }
            }
        });
    }

    public void setBGColor(Color bgColor) {
        this.setBackground(bgColor);
    }

    protected EditorKit createDefaultEditorKit() {
        if (this.htmlKit == null) {
            this.htmlKit = new HTMLEditorKit();
            this.setEditorKit(this.htmlKit);
        }
        return this.htmlKit;
    }
}

