/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.editor.ext;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.ArrayList;
import java.util.List;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.netbeans.editor.EditorState;
import org.netbeans.editor.LocaleSupport;

public class GotoDialogPanel
extends JPanel {
    static final long serialVersionUID = -8686958102543713464L;
    private static final String HISTORY_KEY = "GotoDialogPanel.history-goto-line";
    private static final int MAX_ITEMS = 20;
    private boolean dontFire = false;
    protected JLabel gotoLabel;
    protected JComboBox gotoCombo;

    public GotoDialogPanel() {
        this.initComponents();
        this.getAccessibleContext().setAccessibleName(LocaleSupport.getString("goto-title"));
        this.getAccessibleContext().setAccessibleDescription(LocaleSupport.getString("ACSD_goto"));
        this.gotoCombo.getAccessibleContext().setAccessibleDescription(LocaleSupport.getString("ACSD_goto-line"));
        ArrayList history = (ArrayList)EditorState.get(HISTORY_KEY);
        if (history == null) {
            history = new ArrayList();
        }
        this.updateCombo(history);
    }

    protected void updateCombo(List content) {
        this.dontFire = true;
        this.gotoCombo.setModel(new DefaultComboBoxModel<Object>(content.toArray()));
        this.dontFire = false;
    }

    private void initComponents() {
        this.gotoLabel = new JLabel();
        this.gotoCombo = new JComboBox();
        this.setLayout(new GridBagLayout());
        this.gotoLabel.setText(LocaleSupport.getString("goto-line"));
        this.gotoLabel.setLabelFor(this.gotoCombo);
        this.gotoLabel.setDisplayedMnemonic(LocaleSupport.getChar("goto-line-mnemonic", 'l'));
        GridBagConstraints gridBagConstraints1 = new GridBagConstraints();
        gridBagConstraints1.insets = new Insets(12, 12, 0, 11);
        gridBagConstraints1.anchor = 17;
        gridBagConstraints1.weighty = 1.0;
        this.add((Component)this.gotoLabel, gridBagConstraints1);
        this.gotoCombo.setEditable(true);
        gridBagConstraints1 = new GridBagConstraints();
        gridBagConstraints1.fill = 2;
        gridBagConstraints1.insets = new Insets(12, 0, 0, 10);
        gridBagConstraints1.anchor = 17;
        gridBagConstraints1.weightx = 1.0;
        gridBagConstraints1.weighty = 1.0;
        this.add((Component)this.gotoCombo, gridBagConstraints1);
    }

    public String getValue() {
        return (String)this.gotoCombo.getEditor().getItem();
    }

    public void updateHistory() {
        String value;
        List<String> history = (ArrayList<String>)EditorState.get(HISTORY_KEY);
        if (history == null) {
            history = new ArrayList<String>();
        }
        if (history.contains(value = this.getValue())) {
            history.remove(value);
            history.add(0, value);
        } else {
            if (history.size() >= 20) {
                history = history.subList(0, 19);
            }
            history.add(0, this.getValue());
        }
        EditorState.put(HISTORY_KEY, history);
        this.updateCombo(history);
    }

    public void popupNotify() {
        this.gotoCombo.getEditor().selectAll();
        this.gotoCombo.getEditor().getEditorComponent().requestFocus();
    }

    public JComboBox getGotoCombo() {
        return this.gotoCombo;
    }
}

