/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.editor.ext;

import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import javax.swing.Action;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.KeyStroke;
import javax.swing.text.BadLocationException;
import javax.swing.text.Caret;
import javax.swing.text.JTextComponent;
import javax.swing.text.Keymap;
import javax.swing.text.TextAction;
import org.netbeans.editor.BaseAction;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.BaseKit;
import org.netbeans.editor.EditorUI;
import org.netbeans.editor.Formatter;
import org.netbeans.editor.Settings;
import org.netbeans.editor.SyntaxSupport;
import org.netbeans.editor.Utilities;
import org.netbeans.editor.ext.Completion;
import org.netbeans.editor.ext.CompletionJavaDoc;
import org.netbeans.editor.ext.ExtCaret;
import org.netbeans.editor.ext.ExtEditorUI;
import org.netbeans.editor.ext.ExtFormatter;
import org.netbeans.editor.ext.ExtSyntaxSupport;
import org.netbeans.editor.ext.ExtUtilities;
import org.netbeans.editor.ext.FindDialogSupport;
import org.netbeans.editor.ext.GotoDialogSupport;
import org.netbeans.editor.ext.JDCPopupPanel;
import org.netbeans.editor.ext.ToolTipSupport;

public class ExtKit
extends BaseKit {
    public static final String buildPopupMenuAction = "build-popup-menu";
    public static final String showPopupMenuAction = "show-popup-menu";
    public static final String buildToolTipAction = "build-tool-tip";
    public static final String findAction = "find";
    public static final String replaceAction = "replace";
    public static final String gotoAction = "goto";
    public static final String gotoDeclarationAction = "goto-declaration";
    public static final String gotoSourceAction = "goto-source";
    public static final String gotoHelpAction = "goto-help";
    public static final String matchBraceAction = "match-brace";
    public static final String selectionMatchBraceAction = "selection-match-brace";
    public static final String toggleCaseIdentifierBeginAction = "toggle-case-identifier-begin";
    public static final String codeSelectAction = "code-select";
    public static final String escapeAction = "escape";
    public static final String completionShowAction = "completion-show";
    public static final String completionHideAction = "completion-hide";
    public static final String jdcPopupPanelHideAction = "jdc-popup-hide";
    public static final String jdcPopupPanelShowAction = "jdc-popup-show";
    public static final String shiftInsertBreakAction = "shift-insert-break";
    public static final String commentAction = "comment";
    public static final String uncommentAction = "uncomment";
    public static final String toggleToolbarAction = "toggle-toolbar";
    private static FindDialogSupport findDialogSupport;

    public Caret createCaret() {
        return new ExtCaret();
    }

    public SyntaxSupport createSyntaxSupport(BaseDocument doc) {
        return new ExtSyntaxSupport(doc);
    }

    public Completion createCompletion(ExtEditorUI extEditorUI) {
        return null;
    }

    public CompletionJavaDoc createCompletionJavaDoc(ExtEditorUI extEditorUI) {
        return null;
    }

    protected EditorUI createEditorUI() {
        return new ExtEditorUI();
    }

    protected Action[] createActions() {
        Action[] extActions = new Action[]{new BuildPopupMenuAction(), new ShowPopupMenuAction(), new BuildToolTipAction(), new FindAction(), new ReplaceAction(), new GotoAction(), new GotoDeclarationAction(), new ToggleCaseIdentifierBeginAction(), new MatchBraceAction(matchBraceAction, false), new MatchBraceAction(selectionMatchBraceAction, true), new EscapeAction(), new ExtDefaultKeyTypedAction(), new ExtInsertTabAction(), new ExtInsertBreakAction(), new CompletionShowAction(), new CompletionHideAction(), new JDCPopupPanelHideAction(), new JDCPopupPanelShowAction(), new ShiftInsertBreakAction()};
        return TextAction.augmentList(super.createActions(), extActions);
    }

    public static class ExtDeleteCharAction
    extends BaseKit.DeleteCharAction {
        public ExtDeleteCharAction(String nm, boolean nextChar) {
            super(nm, nextChar);
        }
    }

    public static class ShiftInsertBreakAction
    extends BaseAction {
        public ShiftInsertBreakAction() {
            super(ExtKit.shiftInsertBreakAction, 14);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void actionPerformed(ActionEvent evt, JTextComponent target) {
            if (target != null) {
                Completion completion = ExtUtilities.getCompletion(target);
                if (completion != null && completion.isPaneVisible()) {
                    if (!completion.substituteText(true)) {
                        completion.refresh(false);
                    }
                } else {
                    if (!target.isEditable() || !target.isEnabled()) {
                        target.getToolkit().beep();
                        return;
                    }
                    BaseDocument doc = (BaseDocument)target.getDocument();
                    doc.atomicLock();
                    try {
                        target.replaceSelection("");
                        Caret caret = target.getCaret();
                        int dotpos = caret.getDot();
                        doc.insertString(dotpos, "-", null);
                        doc.remove(dotpos, 1);
                        int eolDot = Utilities.getRowEnd(target, caret.getDot());
                        int newDotPos = doc.getFormatter().indentNewLine(doc, eolDot);
                        caret.setDot(newDotPos);
                    }
                    catch (BadLocationException ex) {
                    }
                    finally {
                        doc.atomicUnlock();
                    }
                }
            }
        }
    }

    public static class JDCPopupPanelShowAction
    extends BaseAction {
        public JDCPopupPanelShowAction() {
            super(ExtKit.jdcPopupPanelShowAction);
        }

        public void actionPerformed(ActionEvent evt, JTextComponent target) {
            JDCPopupPanel jdc;
            if (target != null && (jdc = ExtUtilities.getJDCPopupPanel(target)) != null) {
                jdc.setVisible(true);
            }
        }
    }

    public static class JDCPopupPanelHideAction
    extends BaseAction {
        public JDCPopupPanelHideAction() {
            super(ExtKit.jdcPopupPanelHideAction);
        }

        public void actionPerformed(ActionEvent evt, JTextComponent target) {
            JDCPopupPanel jdc;
            if (target != null && (jdc = ExtUtilities.getJDCPopupPanel(target)) != null) {
                jdc.setVisible(false);
            }
        }
    }

    public static class CompletionHideAction
    extends BaseAction {
        static final long serialVersionUID = -9162014350666711948L;

        public CompletionHideAction() {
            super(ExtKit.completionHideAction);
        }

        public void actionPerformed(ActionEvent evt, JTextComponent target) {
            Completion completion;
            if (target != null && (completion = ExtUtilities.getCompletion(target)) != null) {
                completion.setPaneVisible(false);
            }
        }
    }

    public static class CompletionShowAction
    extends BaseAction {
        static final long serialVersionUID = 1050644925893851146L;

        public CompletionShowAction() {
            super(ExtKit.completionShowAction);
        }

        public void actionPerformed(ActionEvent evt, JTextComponent target) {
            Completion completion;
            if (target != null && (completion = ExtUtilities.getCompletion(target)) != null) {
                completion.setPaneVisible(true);
            }
        }
    }

    public static class ExtInsertTabAction
    extends BaseKit.InsertTabAction {
        static final long serialVersionUID = 2711045528538714986L;

        public void actionPerformed(ActionEvent evt, JTextComponent target) {
            if (target != null) {
                Completion completion = ExtUtilities.getCompletion(target);
                if (completion != null && completion.isPaneVisible()) {
                    completion.refresh(false);
                    completion.substituteCommonText();
                } else {
                    super.actionPerformed(evt, target);
                }
            }
        }
    }

    public static class ExtInsertBreakAction
    extends BaseKit.InsertBreakAction {
        static final long serialVersionUID = 4004043376345356060L;

        public void actionPerformed(ActionEvent evt, JTextComponent target) {
            if (target != null) {
                Completion completion = ExtUtilities.getCompletion(target);
                if (completion != null && completion.isPaneVisible()) {
                    if (completion.substituteText(false)) {
                        completion.setPaneVisible(false);
                    } else {
                        completion.refresh(false);
                    }
                } else {
                    super.actionPerformed(evt, target);
                }
            }
        }
    }

    public static class ExtDefaultKeyTypedAction
    extends BaseKit.DefaultKeyTypedAction {
        static final long serialVersionUID = 5273032708909044812L;

        public void actionPerformed(ActionEvent evt, JTextComponent target) {
            String cmd = evt.getActionCommand();
            int mod = evt.getModifiers();
            if (cmd == null || !cmd.equals(" ") || mod != 2) {
                Caret caret = target.getCaret();
                if (caret instanceof ExtCaret) {
                    ((ExtCaret)caret).requestMatchBraceUpdateSync();
                }
                super.actionPerformed(evt, target);
            }
            if (target != null && evt != null && cmd != null && cmd.length() == 1 && (mod & 8) == 0 && (mod & 2) == 0) {
                this.checkIndentHotChars(target, cmd);
                this.checkCompletion(target, cmd);
            }
        }

        protected void checkIndentHotChars(JTextComponent target, String typedText) {
            BaseDocument doc = Utilities.getDocument(target);
            if (doc != null) {
                ExtFormatter ef;
                int[] fmtBlk;
                Caret caret = target.getCaret();
                Formatter f = doc.getFormatter();
                if (f instanceof ExtFormatter && (fmtBlk = (ef = (ExtFormatter)f).getReformatBlock(target, typedText)) != null) {
                    try {
                        fmtBlk[0] = Utilities.getRowStart(doc, fmtBlk[0]);
                        fmtBlk[1] = Utilities.getRowEnd(doc, fmtBlk[1]);
                        ef.reformat(doc, fmtBlk[0], fmtBlk[1], true);
                    }
                    catch (BadLocationException e) {
                    }
                    catch (IOException e) {
                        // empty catch block
                    }
                }
            }
        }

        protected void checkCompletion(JTextComponent target, String typedText) {
            Completion completion = ExtUtilities.getCompletion(target);
            BaseDocument doc = (BaseDocument)target.getDocument();
            ExtSyntaxSupport extSup = (ExtSyntaxSupport)doc.getSyntaxSupport();
            if (completion != null && typedText.length() > 0) {
                if (!completion.isPaneVisible()) {
                    if (completion.isAutoPopupEnabled()) {
                        int result = extSup.checkCompletion(target, typedText, false);
                        if (result == 0) {
                            completion.popup(true);
                        } else if (result == 1) {
                            completion.cancelRequest();
                        }
                    }
                } else {
                    int result = extSup.checkCompletion(target, typedText, true);
                    switch (result) {
                        case 4: {
                            completion.setPaneVisible(false);
                            break;
                        }
                        case 2: {
                            completion.refresh(false);
                            break;
                        }
                        case 3: {
                            completion.refresh(true);
                        }
                    }
                }
            }
        }
    }

    public static class EscapeAction
    extends BaseAction {
        public EscapeAction() {
            super(ExtKit.escapeAction);
        }

        public void actionPerformed(ActionEvent evt, JTextComponent target) {
            if (target != null) {
                ExtUtilities.getExtEditorUI(target).hidePopupMenu();
            }
        }
    }

    public static class UncommentAction
    extends BaseAction {
        static final long serialVersionUID = -7005758666529862034L;
        private String lineCommentString;

        public UncommentAction(String lineCommentString) {
            super(ExtKit.uncommentAction);
            this.lineCommentString = lineCommentString;
            this.putValue("IconResource", "org/netbeans/modules/editor/resources/uncomment");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void actionPerformed(ActionEvent evt, JTextComponent target) {
            block12: {
                if (target != null) {
                    if (!target.isEditable() || !target.isEnabled()) {
                        target.getToolkit().beep();
                        return;
                    }
                    Caret caret = target.getCaret();
                    BaseDocument doc = (BaseDocument)target.getDocument();
                    int commentLen = this.lineCommentString.length();
                    try {
                        if (caret.isSelectionVisible()) {
                            int startPos = Utilities.getRowStart(doc, target.getSelectionStart());
                            int endPos = target.getSelectionEnd();
                            doc.atomicLock();
                            try {
                                if (endPos > 0 && Utilities.getRowStart(doc, endPos) == endPos) {
                                    --endPos;
                                }
                                int pos = startPos;
                                for (int lineCnt = Utilities.getRowCount(doc, startPos, endPos); lineCnt > 0; --lineCnt) {
                                    if (Utilities.getRowEnd(doc, pos) - pos >= commentLen && doc.getText(pos, commentLen).equals(this.lineCommentString)) {
                                        doc.remove(pos, commentLen);
                                    }
                                    pos = Utilities.getRowStart(doc, pos, 1);
                                }
                                break block12;
                            }
                            finally {
                                doc.atomicUnlock();
                            }
                        }
                        int pos = Utilities.getRowStart(doc, caret.getDot());
                        if (Utilities.getRowEnd(doc, pos) - pos >= commentLen && doc.getText(pos, commentLen).equals(this.lineCommentString)) {
                            doc.remove(pos, commentLen);
                        }
                    }
                    catch (BadLocationException e) {
                        target.getToolkit().beep();
                    }
                }
            }
        }
    }

    public static class CommentAction
    extends BaseAction {
        static final long serialVersionUID = -1422954906554289179L;
        private String lineCommentString;

        public CommentAction(String lineCommentString) {
            super(ExtKit.commentAction);
            this.lineCommentString = lineCommentString;
            this.putValue("IconResource", "org/netbeans/modules/editor/resources/comment");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void actionPerformed(ActionEvent evt, JTextComponent target) {
            block10: {
                if (target != null) {
                    if (!target.isEditable() || !target.isEnabled()) {
                        target.getToolkit().beep();
                        return;
                    }
                    Caret caret = target.getCaret();
                    BaseDocument doc = (BaseDocument)target.getDocument();
                    try {
                        if (caret.isSelectionVisible()) {
                            int startPos = Utilities.getRowStart(doc, target.getSelectionStart());
                            int endPos = target.getSelectionEnd();
                            doc.atomicLock();
                            try {
                                if (endPos > 0 && Utilities.getRowStart(doc, endPos) == endPos) {
                                    --endPos;
                                }
                                int pos = startPos;
                                for (int lineCnt = Utilities.getRowCount(doc, startPos, endPos); lineCnt > 0; --lineCnt) {
                                    doc.insertString(pos, this.lineCommentString, null);
                                    pos = Utilities.getRowStart(doc, pos, 1);
                                }
                                break block10;
                            }
                            finally {
                                doc.atomicUnlock();
                            }
                        }
                        doc.insertString(Utilities.getRowStart(doc, target.getSelectionStart()), this.lineCommentString, null);
                    }
                    catch (BadLocationException e) {
                        target.getToolkit().beep();
                    }
                }
            }
        }
    }

    public static class PrefixMakerAction
    extends BaseAction {
        static final long serialVersionUID = -2305157963664484920L;
        private String prefix;
        private String[] prefixGroup;

        public PrefixMakerAction(String name, String prefix, String[] prefixGroup) {
            super(name);
            this.prefix = prefix;
            this.prefixGroup = prefixGroup;
            String iconRes = null;
            if ("get".equals(prefix)) {
                iconRes = "org/netbeans/modules/editor/resources/var_get";
            } else if ("set".equals(prefix)) {
                iconRes = "org/netbeans/modules/editor/resources/var_set";
            } else if ("is".equals(prefix)) {
                iconRes = "org/netbeans/modules/editor/resources/var_is";
            }
            if (iconRes != null) {
                this.putValue("IconResource", iconRes);
            }
        }

        public void actionPerformed(ActionEvent evt, JTextComponent target) {
            if (target != null) {
                if (!target.isEditable() || !target.isEnabled()) {
                    target.getToolkit().beep();
                    return;
                }
                BaseDocument doc = (BaseDocument)target.getDocument();
                int dotPos = target.getCaret().getDot();
                try {
                    int[] block = Utilities.getIdentifierBlock(doc, dotPos);
                    if (block == null) {
                        target.getToolkit().beep();
                        return;
                    }
                    String identifier = doc.getText(block[0], block[1] - block[0]);
                    if (identifier.startsWith(this.prefix) && Character.isUpperCase(identifier.charAt(this.prefix.length()))) {
                        return;
                    }
                    for (int i = 0; i < this.prefixGroup.length; ++i) {
                        String actPref = this.prefixGroup[i];
                        if (!identifier.startsWith(actPref) || identifier.length() <= actPref.length() || !Character.isUpperCase(identifier.charAt(actPref.length()))) continue;
                        doc.remove(block[0], actPref.length());
                        doc.insertString(block[0], this.prefix, null);
                        return;
                    }
                    Utilities.changeCase(doc, block[0], 1, 0);
                    doc.insertString(block[0], this.prefix, null);
                }
                catch (BadLocationException e) {
                    target.getToolkit().beep();
                }
            }
        }
    }

    public static class CodeSelectAction
    extends BaseAction {
        static final long serialVersionUID = 4033474080778585860L;

        public CodeSelectAction() {
            super(ExtKit.codeSelectAction);
        }

        public void actionPerformed(ActionEvent evt, JTextComponent target) {
        }
    }

    public static class MatchBraceAction
    extends BaseAction {
        boolean select;
        static final long serialVersionUID = -184887499045886231L;

        public MatchBraceAction(String name, boolean select) {
            super(name, 14);
            this.select = select;
        }

        public void actionPerformed(ActionEvent evt, JTextComponent target) {
            if (target != null) {
                try {
                    int[] matchBlk;
                    Caret caret = target.getCaret();
                    BaseDocument doc = Utilities.getDocument(target);
                    int dotPos = caret.getDot();
                    ExtSyntaxSupport sup = (ExtSyntaxSupport)doc.getSyntaxSupport();
                    if (dotPos > 0 && (matchBlk = sup.findMatchingBlock(dotPos - 1, false)) != null) {
                        if (this.select) {
                            caret.moveDot(matchBlk[1]);
                        } else {
                            caret.setDot(matchBlk[1]);
                        }
                    }
                }
                catch (BadLocationException e) {
                    target.getToolkit().beep();
                }
            }
        }
    }

    public static class ToggleCaseIdentifierBeginAction
    extends BaseAction {
        static final long serialVersionUID = 584392193824931979L;

        ToggleCaseIdentifierBeginAction() {
            super(ExtKit.toggleCaseIdentifierBeginAction, 30);
        }

        public void actionPerformed(ActionEvent evt, JTextComponent target) {
            if (target != null) {
                if (!target.isEditable() || !target.isEnabled()) {
                    target.getToolkit().beep();
                    return;
                }
                try {
                    Caret caret = target.getCaret();
                    BaseDocument doc = (BaseDocument)target.getDocument();
                    int[] idBlk = Utilities.getIdentifierBlock(doc, caret.getDot());
                    if (idBlk != null) {
                        Utilities.changeCase(doc, idBlk[0], 1, 2);
                    }
                }
                catch (BadLocationException e) {
                    target.getToolkit().beep();
                }
            }
        }
    }

    public static class GotoDeclarationAction
    extends BaseAction {
        static final long serialVersionUID = -6440495023918097760L;

        public GotoDeclarationAction() {
            super(ExtKit.gotoDeclarationAction, 142);
        }

        public boolean gotoDeclaration(JTextComponent target) {
            try {
                int decPos;
                Caret caret = target.getCaret();
                int dotPos = caret.getDot();
                BaseDocument doc = (BaseDocument)target.getDocument();
                int[] idBlk = Utilities.getIdentifierBlock(doc, dotPos);
                ExtSyntaxSupport extSup = (ExtSyntaxSupport)doc.getSyntaxSupport();
                if (idBlk != null && (decPos = extSup.findDeclarationPosition(doc.getText(idBlk), idBlk[1])) >= 0) {
                    caret.setDot(decPos);
                    return true;
                }
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
            return false;
        }

        public void actionPerformed(ActionEvent evt, JTextComponent target) {
            if (target != null) {
                this.gotoDeclaration(target);
            }
        }
    }

    public static class GotoAction
    extends BaseAction {
        static final long serialVersionUID = 8425585413146373256L;

        public GotoAction() {
            super(ExtKit.gotoAction, 14);
        }

        protected int getOffsetFromLine(BaseDocument doc, int lineOffset) {
            return Utilities.getRowStartFromLineOffset(doc, lineOffset);
        }

        public void actionPerformed(ActionEvent evt, JTextComponent target) {
            if (target != null) {
                new GotoDialogSupport().showGotoDialog();
            }
        }
    }

    public static class ReplaceAction
    extends BaseAction {
        static final long serialVersionUID = 1828017436079834384L;

        public ReplaceAction() {
            super(ExtKit.replaceAction, 78);
        }

        public FindDialogSupport getSupport() {
            return FindDialogSupport.getFindDialogSupport();
        }

        public void actionPerformed(ActionEvent evt, JTextComponent target) {
            if (target != null) {
                this.getSupport().showReplaceDialog();
            }
        }
    }

    public static class FindAction
    extends BaseAction {
        static final long serialVersionUID = 719554648887497427L;

        public FindAction() {
            super(ExtKit.findAction, 78);
        }

        public FindDialogSupport getSupport() {
            return FindDialogSupport.getFindDialogSupport();
        }

        public void actionPerformed(ActionEvent evt, JTextComponent target) {
            if (target != null) {
                this.getSupport().showFindDialog();
            }
        }
    }

    public static class BuildToolTipAction
    extends BaseAction {
        static final long serialVersionUID = -2701131863705941250L;

        public BuildToolTipAction() {
            super(ExtKit.buildToolTipAction, 64);
        }

        protected String buildText(JTextComponent target) {
            ToolTipSupport tts = ExtUtilities.getExtEditorUI(target).getToolTipSupport();
            return tts != null ? target.getToolTipText(tts.getLastMouseEvent()) : target.getToolTipText();
        }

        public void actionPerformed(ActionEvent evt, JTextComponent target) {
            ToolTipSupport tts;
            if (target != null && (tts = ExtUtilities.getExtEditorUI(target).getToolTipSupport()) != null) {
                tts.setToolTipText(this.buildText(target));
            }
        }
    }

    public static class ShowPopupMenuAction
    extends BaseAction {
        static final long serialVersionUID = 4257043398248915291L;

        public ShowPopupMenuAction() {
            super(ExtKit.showPopupMenuAction, 64);
        }

        public void actionPerformed(ActionEvent evt, JTextComponent target) {
            if (target != null) {
                try {
                    int dotPos = target.getCaret().getDot();
                    Rectangle r = target.getUI().modelToView(target, dotPos);
                    if (r != null) {
                        ExtUtilities.getExtEditorUI(target).showPopupMenu(r.x, r.y + r.height);
                    }
                }
                catch (BadLocationException e) {
                    target.getToolkit().beep();
                }
            }
        }
    }

    public static class BuildPopupMenuAction
    extends BaseAction {
        static final long serialVersionUID = 4257043398248915291L;

        public BuildPopupMenuAction() {
            super(ExtKit.buildPopupMenuAction, 64);
        }

        public void actionPerformed(ActionEvent evt, JTextComponent target) {
            if (target != null) {
                JPopupMenu pm = this.buildPopupMenu(target);
                ExtUtilities.getExtEditorUI(target).setPopupMenu(pm);
            }
        }

        protected JPopupMenu buildPopupMenu(JTextComponent target) {
            JPopupMenu pm = new JPopupMenu();
            EditorUI ui = Utilities.getEditorUI(target);
            List l = (List)Settings.getValue(Utilities.getKitClass(target), ui == null || ui.hasExtComponent() ? "popup-menu-action-name-list" : "dialog-popup-menu-action-name-list");
            if (l != null) {
                Iterator i = l.iterator();
                while (i.hasNext()) {
                    String an = (String)i.next();
                    this.addAction(target, pm, an);
                }
            }
            return pm;
        }

        protected void addAction(JTextComponent target, JPopupMenu popupMenu, String actionName) {
            Action a = Utilities.getKit(target).getActionByName(actionName);
            if (a != null) {
                String itemText;
                JMenuItem item = null;
                if (a instanceof BaseAction) {
                    item = ((BaseAction)a).getPopupMenuItem(target);
                }
                if (item == null && (itemText = this.getItemText(target, actionName, a)) != null) {
                    KeyStroke[] keys;
                    item = new JMenuItem(itemText);
                    item.addActionListener(a);
                    Keymap km = target.getKeymap();
                    if (km != null && (keys = km.getKeyStrokesForAction(a)) != null && keys.length > 0) {
                        item.setAccelerator(keys[0]);
                    }
                    item.setEnabled(a.isEnabled());
                    Object helpID = a.getValue("helpID");
                    if (helpID != null && helpID instanceof String) {
                        item.putClientProperty("HelpID", helpID);
                    }
                }
                if (item != null) {
                    popupMenu.add(item);
                }
            } else {
                popupMenu.addSeparator();
            }
        }

        protected String getItemText(JTextComponent target, String actionName, Action a) {
            String itemText = a instanceof BaseAction ? ((BaseAction)a).getPopupMenuText(target) : actionName;
            return itemText;
        }
    }
}

