/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.editor;

import javax.swing.text.BadLocationException;
import javax.swing.text.Position;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.InvalidMarkException;
import org.netbeans.editor.Mark;
import org.netbeans.editor.MarkBlock;
import org.netbeans.editor.MarkFactory;

public class MarkBlockChain {
    protected MarkBlock chain;
    protected MarkBlock currentBlock;
    protected BaseDocument doc;

    public MarkBlockChain(BaseDocument doc) {
        this.doc = doc;
    }

    public final MarkBlock getChain() {
        return this.chain;
    }

    public int compareBlock(int startPos, int endPos) {
        int rel;
        if (this.currentBlock == null) {
            this.currentBlock = this.chain;
            if (this.currentBlock == null) {
                return 0;
            }
        }
        boolean afterPrev = false;
        boolean beforeNext = false;
        boolean cont = false;
        MarkBlock contBlk = null;
        int contRel = 0;
        while (true) {
            if (((rel = this.currentBlock.compare(startPos, endPos)) & 1) != 0) {
                return rel;
            }
            if ((rel & 0x80) != 0) {
                if (beforeNext) {
                    if (!cont || (rel & 2) != 0) {
                        return rel;
                    }
                    this.currentBlock = contBlk;
                    return contRel;
                }
                if (this.currentBlock.next != null) {
                    afterPrev = true;
                    boolean bl = cont = (rel & 2) != 0;
                    if (cont) {
                        contRel = rel;
                        contBlk = this.currentBlock;
                    }
                    this.currentBlock = this.currentBlock.next;
                    continue;
                }
                return rel;
            }
            if (afterPrev) {
                if (!cont || (rel & 0x11) != 0) {
                    return rel;
                }
                this.currentBlock = contBlk;
                return contRel;
            }
            if (this.currentBlock.prev == null) break;
            beforeNext = true;
            boolean bl = cont = (rel & 2) != 0;
            if (cont) {
                contRel = rel;
                contBlk = this.currentBlock;
            }
            this.currentBlock = this.currentBlock.prev;
        }
        return rel;
    }

    public void removeEmptyBlocks() {
        block4: {
            try {
                MarkBlock blk = this.chain;
                while (blk != null) {
                    if (blk.startMark.getOffset() == blk.endMark.getOffset()) {
                        blk = this.checkedRemove(blk);
                        continue;
                    }
                    blk = blk.next;
                }
            }
            catch (InvalidMarkException e) {
                if (!Boolean.getBoolean("netbeans.debug.exceptions")) break block4;
                e.printStackTrace();
            }
        }
    }

    protected MarkBlock createBlock(int startPos, int endPos) throws BadLocationException {
        return new MarkBlock(this.doc, this.createBlockStartMark(), this.createBlockEndMark(), startPos, endPos);
    }

    protected Mark createBlockStartMark() {
        return new Mark();
    }

    protected Mark createBlockEndMark() {
        return new Mark();
    }

    public void addBlock(int startPos, int endPos, boolean concat) {
        block19: {
            if (startPos == endPos) {
                return;
            }
            try {
                int rel = this.compareBlock(startPos, endPos) & 0xFFFFFFF3;
                if ((rel & 0x40) != 0) {
                    if (concat && rel == 66) {
                        this.currentBlock.startMark.move(this.doc, startPos);
                    } else {
                        boolean first = this.currentBlock == this.chain;
                        MarkBlock blk = this.currentBlock.insertChain(this.createBlock(startPos, endPos));
                        if (first) {
                            this.chain = blk;
                        }
                    }
                } else if ((rel & 0x80) != 0) {
                    if (concat && rel == 130) {
                        this.currentBlock.endMark.move(this.doc, endPos);
                    } else {
                        this.currentBlock.addChain(this.createBlock(startPos, endPos));
                    }
                } else if (this.currentBlock == null) {
                    this.chain = this.createBlock(startPos, endPos);
                } else {
                    this.currentBlock.extendStart(startPos);
                    this.currentBlock.extendEnd(endPos);
                    MarkBlock blk = this.chain;
                    while (blk != null) {
                        if (blk != this.currentBlock) {
                            if (this.currentBlock.extend(blk, concat)) {
                                MarkBlock tempCurBlk = this.currentBlock;
                                blk = this.checkedRemove(blk);
                                this.currentBlock = tempCurBlk;
                                continue;
                            }
                            blk = blk.next;
                            continue;
                        }
                        blk = blk.next;
                    }
                }
            }
            catch (InvalidMarkException e) {
                if (Boolean.getBoolean("netbeans.debug.exceptions")) {
                    e.printStackTrace();
                }
            }
            catch (BadLocationException e) {
                if (!Boolean.getBoolean("netbeans.debug.exceptions")) break block19;
                e.printStackTrace();
            }
        }
    }

    public void removeBlock(int startPos, int endPos) {
        block12: {
            if (startPos == endPos) {
                return;
            }
            try {
                int rel;
                while (((rel = this.compareBlock(startPos, endPos)) & 1) != 0) {
                    if ((rel & 8) != 0) {
                        this.checkedRemove(this.currentBlock);
                        continue;
                    }
                    switch (this.currentBlock.shrink(startPos, endPos)) {
                        case 4129: {
                            int endMarkPos = this.currentBlock.endMark.getOffset();
                            this.currentBlock.endMark.move(this.doc, startPos);
                            this.currentBlock.addChain(this.createBlock(endPos, endMarkPos));
                            return;
                        }
                        case 257: 
                        case 1057: {
                            this.currentBlock.startMark.move(this.doc, endPos);
                            return;
                        }
                        case 513: 
                        case 2081: {
                            this.currentBlock.endMark.move(this.doc, startPos);
                            return;
                        }
                    }
                    this.checkedRemove(this.currentBlock);
                }
            }
            catch (BadLocationException e) {
                if (Boolean.getBoolean("netbeans.debug.exceptions")) {
                    e.printStackTrace();
                }
            }
            catch (InvalidMarkException e) {
                if (!Boolean.getBoolean("netbeans.debug.exceptions")) break block12;
                e.printStackTrace();
            }
        }
    }

    protected MarkBlock checkedRemove(MarkBlock blk) {
        boolean first = blk == this.chain;
        blk = blk.removeChain();
        if (first) {
            this.chain = blk;
        }
        this.currentBlock = null;
        return blk;
    }

    public int adjustToBlockEnd(int pos) {
        int rel = this.compareBlock(pos, pos) & 0xFFFFFFF3;
        if (rel == 1057 || rel == 4129) {
            pos = this.currentBlock.getEndOffset();
        }
        return pos;
    }

    public int adjustToNextBlockStart(int pos) {
        MarkBlock nextBlk;
        int rel = this.compareBlock(pos, pos) & 0xFFFFFFF3;
        pos = (rel & 0x40) != 0 ? this.currentBlock.getStartOffset() : (this.currentBlock != null ? ((nextBlk = this.currentBlock.getNext()) != null ? nextBlk.getStartOffset() : -1) : -1);
        return pos;
    }

    public String toString() {
        return "MarkBlockChain: currentBlock=" + this.currentBlock + "\nblock chain: " + (this.chain != null ? "\n" + this.chain.toStringChain() : " Empty");
    }

    public static class LayerChain
    extends MarkBlockChain {
        private String layerName;

        public LayerChain(BaseDocument doc, String layerName) {
            super(doc);
            this.layerName = layerName;
        }

        public final String getLayerName() {
            return this.layerName;
        }

        protected Mark createBlockStartMark() {
            MarkFactory.DrawMark startMark = new MarkFactory.DrawMark(this.layerName, null);
            startMark.activateLayer = true;
            return startMark;
        }

        protected Mark createBlockEndMark() {
            MarkFactory.DrawMark endMark = new MarkFactory.DrawMark(this.layerName, null, Position.Bias.Backward);
            return endMark;
        }
    }
}

