/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.editor;

import java.awt.Color;
import java.util.List;
import javax.swing.text.BadLocationException;
import javax.swing.text.JTextComponent;
import javax.swing.text.Style;
import javax.swing.text.StyleConstants;
import org.netbeans.editor.AnnotationDesc;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.Coloring;
import org.netbeans.editor.DrawContext;
import org.netbeans.editor.DrawLayer;
import org.netbeans.editor.FindSupport;
import org.netbeans.editor.GuardedDocument;
import org.netbeans.editor.MarkChain;
import org.netbeans.editor.MarkFactory;
import org.netbeans.editor.StringMap;
import org.netbeans.editor.TokenCategory;
import org.netbeans.editor.TokenContextPath;
import org.netbeans.editor.TokenID;
import org.netbeans.editor.Utilities;

public class DrawLayerFactory {
    public static final String SYNTAX_LAYER_NAME = "syntax-layer";
    public static final int SYNTAX_LAYER_VISIBILITY = 1000;
    public static final String BOOKMARK_LAYER_NAME = "bookmark-layer";
    public static final int BOOKMARK_LAYER_VISIBILITY = 2000;
    public static final String ANNOTATION_LAYER_NAME = "annotation-layer";
    public static final int ANNOTATION_LAYER_VISIBILITY = 2100;
    public static final String HIGHLIGHT_SEARCH_LAYER_NAME = "highlight-search-layer";
    public static final int HIGHLIGHT_SEARCH_LAYER_VISIBILITY = 9000;
    public static final String INC_SEARCH_LAYER_NAME = "inc-search-layer";
    public static final int INC_SEARCH_LAYER_VISIBILITY = 9500;
    public static final String CARET_LAYER_NAME = "caret-layer";
    public static final int CARET_LAYER_VISIBILITY = 10000;
    public static final String GUARDED_LAYER_NAME = "guarded-layer";
    public static final int GUARDED_LAYER_VISIBILITY = 1400;

    public static class AnnotationLayer
    extends DrawLayer.AbstractLayer {
        private Coloring coloring = null;
        private MarkChain markChain;

        public AnnotationLayer(BaseDocument doc) {
            super(DrawLayerFactory.ANNOTATION_LAYER_NAME);
            this.markChain = new MarkChain(doc, DrawLayerFactory.ANNOTATION_LAYER_NAME);
        }

        public final MarkChain getMarkChain() {
            return this.markChain;
        }

        public boolean extendsEOL() {
            return true;
        }

        public boolean isActive(DrawContext ctx, MarkFactory.DrawMark mark) {
            int nextActivityOffset;
            this.coloring = null;
            if (mark == null) {
                return false;
            }
            if (ctx.getEditorUI().getComponent() == null || !mark.activateLayer) {
                return false;
            }
            BaseDocument doc = ctx.getEditorUI().getDocument();
            AnnotationDesc anno = doc.getAnnotations().getActiveAnnotation(mark);
            if (anno == null) {
                AnnotationDesc activeAnno = doc.getAnnotations().getLineActiveAnnotation(mark);
                if (activeAnno == null) {
                    return false;
                }
                if (ctx.getFragmentOffset() >= activeAnno.getOffset() && (ctx.getFragmentOffset() < activeAnno.getOffset() + activeAnno.getLength() || activeAnno.isWholeLine())) {
                    this.coloring = activeAnno.getColoring();
                    return true;
                }
                return false;
            }
            int nextLineStart = -1;
            try {
                nextLineStart = Utilities.getRowStart(doc, ctx.getFragmentOffset(), 1);
            }
            catch (BadLocationException e) {
                return false;
            }
            if (nextLineStart < 0) {
                nextLineStart = Integer.MAX_VALUE;
            }
            if (anno.isWholeLine()) {
                nextActivityOffset = nextLineStart;
            } else {
                nextActivityOffset = ctx.getFragmentOffset() + anno.getLength();
                if (nextActivityOffset > nextLineStart) {
                    nextActivityOffset = nextLineStart;
                }
            }
            this.setNextActivityChangeOffset(nextActivityOffset);
            this.coloring = anno.getColoring();
            return true;
        }

        public void updateContext(DrawContext ctx) {
            if (this.coloring != null) {
                this.coloring.apply(ctx);
            }
        }
    }

    public static class WordColoringLayer
    extends DrawLayer.AbstractLayer {
        protected StringMap stringMap = new StringMap();

        public WordColoringLayer(String name) {
            super(name);
        }

        public void put(String s, Coloring c) {
            this.stringMap.put(s, c);
        }

        public void put(String[] strings, Coloring c) {
            for (int i = 0; i < strings.length; ++i) {
                this.put(strings[i], c);
            }
        }

        public void put(List stringList, Coloring c) {
            String[] strings = new String[stringList.size()];
            stringList.toArray(strings);
            this.put(strings, c);
        }

        public void init(DrawContext ctx) {
        }

        public boolean isActive(DrawContext ctx, MarkFactory.DrawMark mark) {
            return true;
        }

        public void updateContext(DrawContext ctx) {
            Coloring c = (Coloring)this.stringMap.get(ctx.getBuffer(), ctx.getTokenOffset(), ctx.getTokenLength());
            if (c != null) {
                c.apply(ctx);
            }
        }
    }

    public static class StyleLayer
    extends DrawLayer.AbstractLayer {
        protected Style style;
        protected MarkChain markChain;
        protected Color backColor;
        protected Color foreColor;

        public StyleLayer(String layerName, BaseDocument doc, Style style) {
            super(layerName);
            this.style = style;
            this.markChain = new MarkChain(doc, layerName);
        }

        public boolean extendsEOL() {
            return true;
        }

        public final MarkChain getMarkChain() {
            return this.markChain;
        }

        public void init(DrawContext ctx) {
            this.foreColor = StyleConstants.getForeground(this.style);
            this.backColor = StyleConstants.getBackground(this.style);
        }

        public boolean isActive(DrawContext ctx, MarkFactory.DrawMark mark) {
            boolean active = false;
            if (mark != null) {
                boolean bl = active = ctx.getEditorUI().getComponent() != null && mark.activateLayer;
                if (active) {
                    try {
                        BaseDocument doc = ctx.getEditorUI().getDocument();
                        int nextRowStartPos = Utilities.getRowStart(doc, ctx.getFragmentOffset(), 1);
                        if (nextRowStartPos < 0) {
                            nextRowStartPos = Integer.MAX_VALUE;
                        }
                        this.setNextActivityChangeOffset(nextRowStartPos);
                    }
                    catch (BadLocationException e) {
                        active = false;
                    }
                }
            }
            return active;
        }

        public void updateContext(DrawContext ctx) {
            if (this.foreColor != null) {
                ctx.setForeColor(this.foreColor);
            }
            if (this.backColor != null) {
                ctx.setBackColor(this.backColor);
            }
        }

        public String toString() {
            return super.toString() + (this.markChain != null ? ", " + this.markChain : "");
        }
    }

    static class GuardedLayer
    extends ColorLineLayer {
        GuardedDocument doc;

        GuardedLayer() {
            super(DrawLayerFactory.GUARDED_LAYER_NAME);
        }

        public void init(DrawContext ctx) {
            super.init(ctx);
            this.doc = (GuardedDocument)ctx.getEditorUI().getDocument();
        }

        public boolean isActive(DrawContext ctx, MarkFactory.DrawMark mark) {
            boolean active = mark != null ? mark.activateLayer : this.doc.isPosGuarded(ctx.getFragmentOffset());
            return active;
        }

        protected Coloring getColoring(DrawContext ctx) {
            return ctx.getEditorUI().getColoring("guarded");
        }
    }

    public static class BookmarkLayer
    extends ColorLineLayer {
        public BookmarkLayer() {
            super(DrawLayerFactory.BOOKMARK_LAYER_NAME);
        }

        protected Coloring getColoring(DrawContext ctx) {
            return ctx.getEditorUI().getColoring("bookmark");
        }
    }

    public static class IncSearchLayer
    extends DrawLayer.AbstractLayer {
        Coloring coloring;
        int pos;
        int len;
        boolean enabled;

        public IncSearchLayer() {
            super(DrawLayerFactory.INC_SEARCH_LAYER_NAME);
        }

        public boolean isEnabled() {
            return this.enabled;
        }

        public void setEnabled(boolean enabled) {
            this.enabled = enabled;
        }

        void setArea(int pos, int len) {
            this.pos = pos;
            this.len = len;
        }

        int getOffset() {
            return this.pos;
        }

        int getLength() {
            return this.len;
        }

        public void init(DrawContext ctx) {
            this.setNextActivityChangeOffset(this.enabled ? this.pos : Integer.MAX_VALUE);
        }

        public boolean isActive(DrawContext ctx, MarkFactory.DrawMark mark) {
            boolean active = false;
            if (this.enabled && ctx.getFragmentOffset() == this.pos) {
                active = true;
                this.setNextActivityChangeOffset(this.pos + this.len);
            }
            return active;
        }

        public void updateContext(DrawContext ctx) {
            if (this.coloring == null) {
                this.coloring = ctx.getEditorUI().getColoring("inc-search");
            }
            if (this.coloring != null) {
                this.coloring.apply(ctx);
            }
        }
    }

    public static class HighlightSearchLayer
    extends DrawLayer.AbstractLayer {
        int[] blocks = new int[]{-1, -1};
        Coloring coloring;
        int curInd;
        boolean enabled;

        public HighlightSearchLayer() {
            super(DrawLayerFactory.HIGHLIGHT_SEARCH_LAYER_NAME);
        }

        public boolean isEnabled() {
            return this.enabled;
        }

        public void setEnabled(boolean enabled) {
            this.enabled = enabled;
        }

        public void init(DrawContext ctx) {
            if (this.enabled) {
                try {
                    BaseDocument doc = ctx.getEditorUI().getDocument();
                    this.blocks = FindSupport.getFindSupport().getBlocks(this.blocks, doc, ctx.getStartOffset(), ctx.getEndOffset());
                }
                catch (BadLocationException e) {
                    this.blocks = new int[]{-1, -1};
                }
                this.coloring = null;
                this.curInd = 0;
            }
        }

        public boolean isActive(DrawContext ctx, MarkFactory.DrawMark mark) {
            boolean active;
            if (this.enabled) {
                int pos = ctx.getFragmentOffset();
                if (pos == this.blocks[this.curInd]) {
                    active = true;
                    this.setNextActivityChangeOffset(this.blocks[this.curInd + 1]);
                } else if (pos == this.blocks[this.curInd + 1]) {
                    active = false;
                    this.curInd += 2;
                    this.setNextActivityChangeOffset(this.blocks[this.curInd]);
                    if (pos == this.blocks[this.curInd]) {
                        this.setNextActivityChangeOffset(this.blocks[this.curInd + 1]);
                        active = true;
                    }
                } else {
                    this.setNextActivityChangeOffset(this.blocks[this.curInd]);
                    active = false;
                }
            } else {
                active = false;
            }
            return active;
        }

        public void updateContext(DrawContext ctx) {
            int pos = ctx.getFragmentOffset();
            if (pos >= this.blocks[this.curInd] && pos < this.blocks[this.curInd + 1]) {
                if (this.coloring == null) {
                    this.coloring = ctx.getEditorUI().getColoring("highlight-search");
                }
                if (this.coloring != null) {
                    this.coloring.apply(ctx);
                }
            }
        }
    }

    public static class CaretLayer
    extends DrawLayer.AbstractLayer {
        Coloring coloring;

        public CaretLayer() {
            super(DrawLayerFactory.CARET_LAYER_NAME);
        }

        public boolean extendsEmptyLine() {
            return true;
        }

        public void init(DrawContext ctx) {
            this.coloring = null;
        }

        public boolean isActive(DrawContext ctx, MarkFactory.DrawMark mark) {
            JTextComponent c;
            boolean active = mark != null ? mark.activateLayer : (c = ctx.getEditorUI().getComponent()) != null && c.getCaret().isSelectionVisible() && ctx.getFragmentOffset() >= c.getSelectionStart() && ctx.getFragmentOffset() < c.getSelectionEnd();
            return active;
        }

        public void updateContext(DrawContext ctx) {
            if (this.coloring == null) {
                this.coloring = ctx.getEditorUI().getColoring("selection");
            }
            if (this.coloring != null) {
                this.coloring.apply(ctx);
            }
        }
    }

    public static abstract class ColorLineLayer
    extends DrawLayer.AbstractLayer {
        Coloring coloring;

        public ColorLineLayer(String name) {
            super(name);
        }

        public boolean extendsEOL() {
            return true;
        }

        public void init(DrawContext ctx) {
            this.coloring = null;
        }

        public boolean isActive(DrawContext ctx, MarkFactory.DrawMark mark) {
            boolean active;
            if (mark != null) {
                boolean bl = active = ctx.getEditorUI().getComponent() != null && mark.activateLayer;
                if (active) {
                    try {
                        BaseDocument doc = ctx.getEditorUI().getDocument();
                        int nextRowStartPos = Utilities.getRowStart(doc, ctx.getFragmentOffset(), 1);
                        if (nextRowStartPos < 0) {
                            nextRowStartPos = Integer.MAX_VALUE;
                        }
                        this.setNextActivityChangeOffset(nextRowStartPos);
                    }
                    catch (BadLocationException e) {
                        active = false;
                    }
                }
            } else {
                active = false;
            }
            return active;
        }

        public void updateContext(DrawContext ctx) {
            if (this.coloring == null) {
                this.coloring = this.getColoring(ctx);
            }
            if (this.coloring != null) {
                this.coloring.apply(ctx);
            }
        }

        protected abstract Coloring getColoring(DrawContext var1);
    }

    public static class SyntaxLayer
    extends DrawLayer.AbstractLayer {
        public SyntaxLayer() {
            super(DrawLayerFactory.SYNTAX_LAYER_NAME);
        }

        public void init(DrawContext ctx) {
        }

        public boolean isActive(DrawContext ctx, MarkFactory.DrawMark mark) {
            return true;
        }

        public void updateContext(DrawContext ctx) {
            TokenID tokenID = ctx.getTokenID();
            TokenContextPath tcp = ctx.getTokenContextPath();
            if (tokenID != null && tcp != null) {
                String fullName = tcp.getFullTokenName(tokenID);
                Coloring c = ctx.getEditorUI().getColoring(fullName);
                if (c != null) {
                    c.apply(ctx);
                } else {
                    TokenCategory cat = tokenID.getCategory();
                    if (cat != null) {
                        fullName = tcp.getFullTokenName(cat);
                        c = ctx.getEditorUI().getColoring(fullName);
                        if (c != null) {
                            c.apply(ctx);
                        }
                    }
                }
            }
        }
    }
}

