/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.editor;

import java.util.ArrayList;

public class Bookmarks {
    private ArrayList bookmarks = new ArrayList(15);

    private Bookmark getInternalBookmark(int line) {
        for (int i = 0; i < this.bookmarks.size() && ((Bookmark)this.bookmarks.get(i)).getLine() <= line; ++i) {
            if (((Bookmark)this.bookmarks.get(i)).getLine() != line) continue;
            return (Bookmark)this.bookmarks.get(i);
        }
        return null;
    }

    public Bookmark getBookmark(int line) {
        return this.getInternalBookmark(line);
    }

    public Bookmark getNextLineBookmark(int line) {
        for (int i = 0; i < this.bookmarks.size(); ++i) {
            if (((Bookmark)this.bookmarks.get(i)).getLine() < line) continue;
            return (Bookmark)this.bookmarks.get(i);
        }
        return null;
    }

    public void putBookmark(Bookmark bookmark) {
        int line = bookmark.getLine();
        boolean inserted = false;
        for (int i = 0; i < this.bookmarks.size(); ++i) {
            if (((Bookmark)this.bookmarks.get(i)).getLine() <= line) continue;
            this.bookmarks.add(i, bookmark);
            inserted = true;
            break;
        }
        if (!inserted) {
            this.bookmarks.add(bookmark);
        }
    }

    public Bookmark removeBookmark(int line) {
        Bookmark bookmark = this.getInternalBookmark(line);
        if (bookmark == null) {
            return null;
        }
        this.bookmarks.remove(bookmark);
        return bookmark;
    }

    public void removeBookmark(Bookmark bookmark) {
        this.bookmarks.remove(bookmark);
    }

    public void removeAll() {
        for (int i = 0; i < this.bookmarks.size(); ++i) {
            ((Bookmark)this.bookmarks.get(i)).remove();
        }
        this.bookmarks = new ArrayList();
    }

    public static interface Bookmark {
        public int getLine();

        public void remove();
    }
}

