/*
 * Decompiled with CFR 0.152.
 */
package imhotepc.apps;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import org.apache.batik.transcoder.SVGAbstractTranscoder;
import org.apache.batik.transcoder.Transcoder;
import org.apache.batik.transcoder.TranscoderInput;
import org.apache.batik.transcoder.TranscoderOutput;
import org.apache.batik.transcoder.image.JPEGTranscoder;

public class Main {
    private static void usage() {
        System.out.println("Imhotep Converter options are ");
        System.out.println("\t-t <transcoder>");
        System.out.println("\t   Transcoder Class Name");
        System.out.println("\t-w <width>");
        System.out.println("\t   output width. This is a floating point value. ");
        System.out.println("\t-h <height>");
        System.out.println("\t   output height. This is a floating point value. ");
        System.out.println("\t-i <input>");
        System.out.println("\t   input file path");
        System.out.println("\t-o <output>");
        System.out.println("\t   output file path");
    }

    public static void main(String[] args) {
        if (args.length < 10) {
            Main.usage();
            System.exit(0);
        }
        String transcoder = args[1];
        String width = args[3];
        String height = args[5];
        String inputFile = args[7];
        String outputFile = args[9];
        try {
            System.out.println("#Transcoder Name    : " + transcoder);
            Class<?> clazz = Class.forName(transcoder);
            Transcoder t = (Transcoder)clazz.newInstance();
            t.addTranscodingHint(SVGAbstractTranscoder.KEY_WIDTH, (Object)new Float(width));
            t.addTranscodingHint(SVGAbstractTranscoder.KEY_HEIGHT, (Object)new Float(height));
            t.addTranscodingHint(JPEGTranscoder.KEY_QUALITY, (Object)new Float(0.8));
            System.out.println("#Transcoder Class   : " + t.getClass());
            System.out.println("#Transcoder Options : " + t.getTranscodingHints());
            System.out.println("#");
            System.out.println("#Input File Name    : " + inputFile);
            File in = new File(inputFile);
            if (!in.exists()) {
                in = new File(new URI(inputFile));
            }
            FileInputStream inStream = new FileInputStream(in);
            TranscoderInput input = new TranscoderInput((InputStream)inStream);
            input.setURI(in.toURI().toASCIIString());
            if (!in.canRead()) {
                throw new IOException("Can not Read");
            }
            System.out.println("#Input File         : " + input.getURI());
            System.out.println("#");
            System.out.println("#Output File Name   : " + outputFile);
            File out = new File(outputFile);
            if (!out.exists()) {
                out = new File(new URI(outputFile));
            }
            FileOutputStream outStream = new FileOutputStream(out);
            TranscoderOutput output = new TranscoderOutput((OutputStream)outStream);
            output.setURI(out.toURI().toASCIIString());
            if (!out.canWrite()) {
                throw new IOException("Can not Write");
            }
            System.out.println("#Output File        : " + input.getURI());
            System.out.println("#");
            System.out.print("#transcode...");
            t.transcode(input, output);
            outStream.flush();
            outStream.close();
            inStream.close();
            System.out.println("... Success");
            System.out.println("#");
            System.exit(0);
        }
        catch (Exception e) {
            e.printStackTrace();
            System.err.println(e);
            System.exit(-1);
        }
    }
}

