/*
 * Decompiled with CFR 0.152.
 */
package com.ysystems.lib.yutil;

import java.awt.Color;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringBufferInputStream;
import java.util.Enumeration;
import java.util.Properties;

public class YutilProperties
extends Properties {
    public YutilProperties() {
        super(new Properties());
    }

    public YutilProperties(String args, boolean scanout) {
        super(new Properties());
        this.setPropertiesDefaults(args, scanout);
    }

    public YutilProperties(String[] argv) {
        super(new Properties());
        this.setPropertiesDefaults(argv);
    }

    public YutilProperties(InputStream in) {
        super(new Properties());
        this.setPropertiesDefaults(in);
    }

    public YutilProperties(YutilProperties argprops) {
        super(new Properties());
        this.setPropertiesDefaults(argprops);
    }

    public void setPropertiesDefaults(String args, boolean scanout) {
        if (args == null) {
            return;
        }
        if (scanout) {
            StringBuffer sb = new StringBuffer(args.length() + 32);
            try {
                this.defaults.load(new StringBufferInputStream(YutilProperties.scanOutProperties(args, sb).toString()));
            }
            catch (IOException excp) {
                System.out.println(excp);
            }
        } else {
            try {
                this.defaults.load(new StringBufferInputStream(args));
            }
            catch (IOException excp) {
                System.out.println(excp);
            }
        }
        try {
            this.defaults.load(new StringBufferInputStream(args));
        }
        catch (IOException excp) {
            System.out.println(excp);
        }
    }

    public void setPropertiesDefaults(String[] argv) {
        if (argv == null) {
            return;
        }
        int i = 0;
        while (i < argv.length) {
            try {
                this.defaults.load(new StringBufferInputStream(argv[i]));
            }
            catch (IOException excp) {
                System.out.println(excp);
            }
            ++i;
        }
    }

    public void setPropertiesDefaults(InputStream in) {
        if (in == null) {
            return;
        }
        try {
            this.defaults.load(in);
        }
        catch (IOException excp) {
            System.out.println(excp);
        }
    }

    public void setPropertiesDefaults(YutilProperties argprops) {
        if (argprops == null) {
            return;
        }
        Enumeration<?> ep = argprops.propertyNames();
        while (ep.hasMoreElements()) {
            String key = (String)ep.nextElement();
            String val = String.valueOf(key) + "=" + argprops.getProperty(key);
            this.setPropertiesDefaults(val, false);
        }
    }

    public void setProperties(String args, boolean scanout) {
        if (args == null) {
            return;
        }
        if (scanout) {
            StringBuffer sb = new StringBuffer(args.length() + 32);
            try {
                this.load(new StringBufferInputStream(YutilProperties.scanOutProperties(args, sb).toString()));
            }
            catch (IOException excp) {
                System.out.println(excp);
            }
        } else {
            try {
                this.load(new StringBufferInputStream(args));
            }
            catch (IOException excp) {
                System.out.println(excp);
            }
        }
    }

    public void setProperties(String[] argv) {
        if (argv == null) {
            return;
        }
        int i = 0;
        while (i < argv.length) {
            try {
                this.load(new StringBufferInputStream(argv[i]));
            }
            catch (IOException excp) {
                System.out.println(excp);
            }
            ++i;
        }
    }

    public void setProperties(InputStream in) {
        if (in == null) {
            return;
        }
        try {
            this.load(in);
        }
        catch (IOException excp) {
            System.out.println(excp);
        }
    }

    public void setProperties(YutilProperties argprops) {
        if (argprops == null) {
            return;
        }
        Enumeration<?> ep = argprops.propertyNames();
        while (ep.hasMoreElements()) {
            String key = (String)ep.nextElement();
            String val = String.valueOf(key) + "=" + argprops.getProperty(key);
            this.setProperties(val, false);
        }
    }

    public int getProperty_int(String key) {
        if (key == null) {
            return 0;
        }
        String val = this.getProperty(key);
        if (val == null) {
            return 0;
        }
        int ret_int = 0;
        try {
            Integer workint = new Integer(val);
            ret_int = workint;
        }
        catch (NumberFormatException e) {
            ret_int = 0;
        }
        return ret_int;
    }

    public double getProperty_double(String key) {
        if (key == null) {
            return 0.0;
        }
        String val = this.getProperty(key);
        if (val == null) {
            return 0.0;
        }
        double ret_double = 0.0;
        try {
            Double workdouble = new Double(val);
            ret_double = workdouble;
        }
        catch (NumberFormatException e) {
            ret_double = 0.0;
        }
        return ret_double;
    }

    public boolean getProperty_boolean(String key) {
        if (key == null) {
            return false;
        }
        String val = this.getProperty(key);
        if (val == null) {
            return false;
        }
        boolean ret_boolean = false;
        if (val.equalsIgnoreCase("ON") || val.equalsIgnoreCase("YES") || val.equalsIgnoreCase("TRUE")) {
            ret_boolean = true;
        } else if (val.equalsIgnoreCase("OFF") || val.equalsIgnoreCase("NO") || val.equalsIgnoreCase("FALSE")) {
            ret_boolean = false;
        }
        return ret_boolean;
    }

    public String getProperty_String(String key) {
        if (key == null) {
            return null;
        }
        String val = this.getProperty(key);
        return val;
    }

    public Color getProperty_Color(String key) {
        if (key == null) {
            return Color.black;
        }
        String val = this.getProperty(key);
        if (val == null) {
            return Color.black;
        }
        Color ret_Color = YutilProperties.convertStringToColor(val);
        return ret_Color;
    }

    public static Color convertStringToColor(String val) {
        Color ret_Color;
        try {
            String workstr1;
            int slen = val.length();
            if (val.startsWith("0x") || val.startsWith("0X")) {
                workstr1 = val.substring(2);
                slen -= 2;
            } else if (val.startsWith("#")) {
                workstr1 = val.substring(1);
                --slen;
            } else {
                return new Color(Integer.parseInt(val));
            }
            if (slen <= 6) {
                int ival = Integer.parseInt(workstr1, 16);
                ret_Color = new Color(ival);
            } else {
                String workstr2 = slen == 8 ? workstr1 : (slen == 7 ? "0" + workstr1 : workstr1.substring(slen - 8));
                int a = Integer.parseInt(workstr2.substring(0, 2), 16);
                int r = Integer.parseInt(workstr2.substring(2, 4), 16);
                int g = Integer.parseInt(workstr2.substring(4, 6), 16);
                int b = Integer.parseInt(workstr2.substring(6, 8), 16);
                try {
                    ret_Color = new Color(r, g, b, a);
                }
                catch (NoSuchMethodError excp1) {
                    System.out.println("YutilProperties:convertStringToColor|excp1=[" + excp1 + "]");
                    ret_Color = new Color(r, g, b);
                }
            }
        }
        catch (NumberFormatException e) {
            ret_Color = Color.black;
        }
        return ret_Color;
    }

    public static String convertColorToString(Color val) {
        String ret_String;
        String bs;
        String gs;
        int a;
        try {
            a = val.getAlpha();
        }
        catch (NoSuchMethodError excp) {
            System.out.println("YutilProperties:convertColorToString:excp=[" + excp + "]");
            a = 255;
        }
        int r = val.getRed();
        int g = val.getGreen();
        int b = val.getBlue();
        String rs = Integer.toHexString(r);
        if (rs.length() == 1) {
            rs = "0" + rs;
        }
        if ((gs = Integer.toHexString(g)).length() == 1) {
            gs = "0" + gs;
        }
        if ((bs = Integer.toHexString(b)).length() == 1) {
            bs = "0" + bs;
        }
        if (a == 255) {
            ret_String = "#" + rs + gs + bs;
        } else {
            String as = Integer.toHexString(a);
            if (as.length() == 1) {
                as = "0" + as;
            }
            ret_String = "#" + as + rs + gs + bs;
        }
        return ret_String;
    }

    /*
     * WARNING - void declaration
     */
    public static StringBuffer scanOutProperties(String args, StringBuffer sb) {
        int len = args.length();
        sb.setLength(0);
        int si = 0;
        while (si < len) {
            void var8_8;
            void var7_7;
            void var6_6;
            void var5_5;
            int nambeg = -1;
            int namlen = 0;
            int valbeg = -1;
            int vallen = 0;
            block1: while (si < len) {
                char c = args.charAt(si);
                if (c == ' ' || c == '\t' || c == '\n' || c == '\r') {
                    ++si;
                    continue;
                }
                nambeg = si;
                while (si < len) {
                    c = args.charAt(si);
                    if (c == '\n') {
                        ++si;
                        break block1;
                    }
                    if (c != '=') {
                        ++namlen;
                        ++si;
                        continue;
                    }
                    if (++si >= len) break block1;
                    c = args.charAt(si);
                    if (c == '\"' || c == '\'') {
                        char matchc = c;
                        if (++si >= len) break block1;
                        c = args.charAt(si);
                        valbeg = si;
                        while (true) {
                            if (c == '\n') {
                                ++si;
                                break block1;
                            }
                            if (c == '\\' && si + 1 < len && (args.charAt(si + 1) == '\"' || args.charAt(si + 1) == '\'')) {
                                vallen += 2;
                                if ((si += 2) >= len) break block1;
                                c = args.charAt(si);
                                continue;
                            }
                            if (c == matchc) {
                                ++si;
                                break block1;
                            }
                            ++vallen;
                            if (++si >= len) break block1;
                            c = args.charAt(si);
                        }
                    }
                    valbeg = si;
                    while (true) {
                        if (c == '\n') {
                            ++si;
                            break block1;
                        }
                        if (c == ' ') {
                            ++si;
                            break block1;
                        }
                        ++vallen;
                        if (++si >= len) break block1;
                        c = args.charAt(si);
                    }
                }
                break block1;
            }
            YutilProperties.scanOutPropertiesNamValAppend(args, (int)var5_5, (int)var6_6, (int)var7_7, (int)var8_8, sb);
        }
        return sb;
    }

    private static void scanOutPropertiesNamValAppend(String args, int nambeg, int namlen, int valbeg, int vallen, StringBuffer sb) {
        int len = args.length();
        if (nambeg < 0 || nambeg >= len || nambeg + namlen - 1 >= len) {
            return;
        }
        if (valbeg < 0 || valbeg >= len || valbeg + vallen - 1 >= len) {
            return;
        }
        int si = nambeg;
        while (si < nambeg + namlen) {
            sb.append(args.charAt(si));
            ++si;
        }
        sb.append('=');
        si = valbeg;
        while (si < valbeg + vallen) {
            sb.append(args.charAt(si));
            ++si;
        }
        sb.append('\n');
    }
}

