/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.jai.imageioimpl;

import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.util.Map;
import java.util.Vector;
import javax.imageio.ImageWriteParam;
import javax.imageio.ImageWriter;
import javax.imageio.stream.ImageOutputStream;
import javax.media.jai.ImageLayout;
import javax.media.jai.PlanarImage;
import javax.media.jai.PropertyChangeEventJAI;
import javax.media.jai.RenderedOp;
import javax.media.jai.RenderingChangeEvent;

final class PixelReplacementImage
extends PlanarImage
implements PropertyChangeListener {
    private ImageWriteParam param;
    private ImageWriter writer;
    private int imageIndex;
    private ImageOutputStream streamToClose;

    private static Vector createVector(Object element) {
        Vector<Object> v = new Vector<Object>(1);
        v.add(element);
        return v;
    }

    PixelReplacementImage(RenderedImage source, Map configuration, ImageWriteParam param, ImageWriter writer, int imageIndex, ImageOutputStream streamToClose) throws IOException {
        super(new ImageLayout(source), PixelReplacementImage.createVector(source), configuration);
        if (!writer.canReplacePixels(imageIndex)) {
            throw new IllegalArgumentException("!writer.canReplacePixels(imageIndex)");
        }
        this.param = param;
        this.writer = writer;
        this.imageIndex = imageIndex;
        this.streamToClose = streamToClose;
    }

    public void dispose() {
        if (this.streamToClose != null) {
            try {
                this.streamToClose.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        super.dispose();
    }

    public Raster getTile(int tileX, int tileY) {
        return this.getSourceImage(0).getTile(tileX, tileY);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void propertyChange(PropertyChangeEvent evt) {
        PlanarImage source = this.getSourceImage(0);
        Object eventSource = evt.getSource();
        if (evt instanceof PropertyChangeEventJAI && evt.getPropertyName().equalsIgnoreCase("invalidregion") && eventSource.equals(source) || evt instanceof RenderingChangeEvent && evt.getOldValue().equals(source) && eventSource instanceof RenderedOp && evt.getNewValue().equals(((RenderedOp)eventSource).getRendering())) {
            Shape srcInvalidRegion = null;
            if (evt instanceof RenderingChangeEvent) {
                RenderingChangeEvent rcEvent = (RenderingChangeEvent)evt;
                srcInvalidRegion = rcEvent.getInvalidRegion();
                source = (PlanarImage)evt.getNewValue();
                this.setSource(source, 0);
                if (srcInvalidRegion == null) {
                    srcInvalidRegion = ((PlanarImage)rcEvent.getOldValue()).getBounds();
                }
            } else {
                Shape evtNewValue = (Shape)evt.getNewValue();
                if (evtNewValue instanceof Shape && (srcInvalidRegion = evtNewValue) == null) {
                    srcInvalidRegion = source.getBounds();
                }
            }
            if (srcInvalidRegion == null) {
                return;
            }
            if (this.param != null) {
                Rectangle sourceRegion = this.param.getSourceRegion();
                if (sourceRegion != null && !srcInvalidRegion.intersects(sourceRegion)) {
                    return;
                }
            } else {
                this.param = this.writer.getDefaultWriteParam();
            }
            Point[] tileIndices = source.getTileIndices(srcInvalidRegion.getBounds());
            int numTiles = tileIndices.length;
            int i = 0;
            while (i < numTiles) {
                Point tileIndex = tileIndices[i];
                Rectangle tileRect = source.getTileRect(tileIndex.x, tileIndex.y);
                if (srcInvalidRegion.intersects(tileRect)) {
                    Raster raster = source.getTile(tileIndex.x, tileIndex.y);
                    try {
                        ImageWriter imageWriter = this.writer;
                        synchronized (imageWriter) {
                            this.writer.prepareReplacePixels(this.imageIndex, tileRect);
                            this.param.setDestinationOffset(tileRect.getLocation());
                            this.writer.replacePixels(raster, this.param);
                            this.writer.endReplacePixels();
                        }
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                }
                ++i;
            }
        }
    }
}

