/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.imageioimpl.plugins.tiff;

import com.sun.media.imageio.plugins.tiff.BaselineTIFFTagSet;
import com.sun.media.imageio.plugins.tiff.TIFFCompressor;
import com.sun.media.imageioimpl.plugins.tiff.TIFFField;
import com.sun.media.imageioimpl.plugins.tiff.TIFFIFD;
import com.sun.media.imageioimpl.plugins.tiff.TIFFImageMetadata;
import com.sun.media.imageioimpl.plugins.tiff.TIFFImageWriter;
import java.awt.Point;
import java.awt.color.ColorSpace;
import java.awt.image.BufferedImage;
import java.awt.image.ComponentColorModel;
import java.awt.image.DataBufferByte;
import java.awt.image.PixelInterleavedSampleModel;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Iterator;
import javax.imageio.IIOException;
import javax.imageio.IIOImage;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.ImageWriteParam;
import javax.imageio.ImageWriter;
import javax.imageio.metadata.IIOInvalidTreeException;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.metadata.IIOMetadataNode;
import javax.imageio.plugins.jpeg.JPEGImageWriteParam;
import javax.imageio.spi.IIORegistry;
import javax.imageio.spi.ImageReaderSpi;
import javax.imageio.spi.ServiceRegistry;
import javax.imageio.stream.ImageOutputStream;
import javax.imageio.stream.MemoryCacheImageInputStream;
import javax.imageio.stream.MemoryCacheImageOutputStream;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class TIFFJPEGCompressor
extends TIFFCompressor {
    private static final boolean DEBUG = false;
    static final int CHROMA_SUBSAMPLING = 2;
    private static final String STREAM_METADATA_NAME = "javax_imageio_jpeg_stream_1.0";
    private static final String IMAGE_METADATA_NAME = "javax_imageio_jpeg_image_1.0";
    private ImageWriteParam param = null;
    private JPEGImageWriteParam JPEGParam = null;
    private ImageWriter JPEGWriter = null;
    private boolean usingCodecLib;
    private IIOByteArrayOutputStream baos;
    private boolean hasJPEGTables = false;
    private IIOMetadata streamMetadata = null;
    private IIOMetadata imageMetadata = null;

    static ImageReader getCoreJPEGReader() {
        ImageReader jpegReader = null;
        try {
            IIORegistry registry = IIORegistry.getDefaultInstance();
            Class<?> imageReaderClass = Class.forName("javax.imageio.spi.ImageReaderSpi");
            Iterator<?> readerSPIs = registry.getServiceProviders(imageReaderClass, new JPEGSPIFilter(), true);
            if (readerSPIs.hasNext()) {
                ImageReaderSpi jpegReaderSPI = (ImageReaderSpi)readerSPIs.next();
                jpegReader = jpegReaderSPI.createReaderInstance();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return jpegReader;
    }

    private static void pruneNodes(Node tree) {
        String[] unwantedNodes = new String[]{"app0JFIF", "dht", "dqt"};
        IIOMetadataNode iioTree = (IIOMetadataNode)tree;
        int i = 0;
        while (i < unwantedNodes.length) {
            NodeList list = iioTree.getElementsByTagName(unwantedNodes[i]);
            int length = list.getLength();
            int j = 0;
            while (j < length) {
                Node node = list.item(j);
                if (node != null) {
                    node.getParentNode().removeChild(node);
                }
                ++j;
            }
            ++i;
        }
    }

    public TIFFJPEGCompressor(ImageWriteParam param) {
        super("JPEG", 7, false);
        this.param = param;
    }

    private void initJPEGWriter(boolean preferCodecLib) {
        if (this.JPEGWriter != null) {
            String writerClassName = this.JPEGWriter.getClass().getName();
            if (preferCodecLib && !writerClassName.startsWith("com.sun.media") || !preferCodecLib && !writerClassName.startsWith("com.sun.imageio")) {
                this.JPEGWriter = null;
            }
        }
        if (this.JPEGWriter == null) {
            Iterator<ImageWriter> iter = ImageIO.getImageWritersByFormatName("jpeg");
            if (!iter.hasNext()) {
                throw new IllegalStateException("No JPEG writers found!");
            }
            this.JPEGWriter = iter.next();
            if (!preferCodecLib && !this.JPEGWriter.getClass().getName().startsWith("com.sun.imageio")) {
                while (iter.hasNext()) {
                    ImageWriter nextWriter = iter.next();
                    if (!nextWriter.getClass().getName().startsWith("com.sun.imageio")) continue;
                    this.JPEGWriter = nextWriter;
                }
            }
        }
        this.usingCodecLib = this.JPEGWriter.getClass().getName().startsWith("com.sun.media");
        if (this.JPEGParam == null) {
            if (this.param != null && this.param instanceof JPEGImageWriteParam) {
                this.JPEGParam = (JPEGImageWriteParam)this.param;
            } else {
                this.JPEGParam = new JPEGImageWriteParam(this.writer != null ? this.writer.getLocale() : null);
                if (this.param.getCompressionMode() == 2) {
                    this.JPEGParam.setCompressionMode(2);
                    this.JPEGParam.setCompressionQuality(this.param.getCompressionQuality());
                }
            }
        }
    }

    private IIOMetadata getEmptyImageMetadata() throws IIOException {
        if (this.imageMetadata == null) {
            TIFFImageWriter tiffWriter = (TIFFImageWriter)this.writer;
            this.imageMetadata = this.JPEGWriter.getDefaultImageMetadata(tiffWriter.imageType, this.JPEGParam);
            Node tree = this.imageMetadata.getAsTree(IMAGE_METADATA_NAME);
            TIFFJPEGCompressor.pruneNodes(tree);
            try {
                this.imageMetadata.setFromTree(IMAGE_METADATA_NAME, tree);
            }
            catch (IIOInvalidTreeException e) {
                throw new IIOException("Cannot empty image metadata!", e);
            }
        }
        return this.imageMetadata;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMetadata(IIOMetadata metadata) {
        super.setMetadata(metadata);
        if (metadata instanceof TIFFImageMetadata) {
            TIFFImageMetadata tim = (TIFFImageMetadata)metadata;
            TIFFIFD rootIFD = tim.getRootIFD();
            BaselineTIFFTagSet base = BaselineTIFFTagSet.getInstance();
            TIFFField f = tim.getTIFFField(277);
            int numBands = f.getAsInt(0);
            if (numBands == 1) {
                rootIFD.removeTIFFField(530);
                rootIFD.removeTIFFField(531);
                rootIFD.removeTIFFField(532);
            } else {
                TIFFField YCbCrSubSamplingField = new TIFFField(base.getTag(530), 3, 2, new char[]{'\u0002', '\u0002'});
                rootIFD.addTIFFField(YCbCrSubSamplingField);
                TIFFField YCbCrPositioningField = new TIFFField(base.getTag(531), 3, 1, new char[]{'\u0001'});
                rootIFD.addTIFFField(YCbCrPositioningField);
                TIFFField referenceBlackWhiteField = new TIFFField(base.getTag(532), 5, 6, new long[][]{{0L, 1L}, {255L, 1L}, {128L, 1L}, {255L, 1L}, {128L, 1L}, {255L, 1L}});
                rootIFD.addTIFFField(referenceBlackWhiteField);
            }
            TIFFField JPEGTablesField = tim.getTIFFField(347);
            if (JPEGTablesField != null) {
                this.initJPEGWriter(false);
            }
            if (JPEGTablesField != null && this.JPEGWriter.getClass().getName().startsWith("com.sun.imageio")) {
                this.hasJPEGTables = true;
                if (JPEGTablesField.getCount() > 0) {
                    byte[] tables = JPEGTablesField.getAsBytes();
                    ByteArrayInputStream bais = new ByteArrayInputStream(tables);
                    MemoryCacheImageInputStream iis = new MemoryCacheImageInputStream(bais);
                    ImageReader jpegReader = TIFFJPEGCompressor.getCoreJPEGReader();
                    jpegReader.setInput(iis);
                    try {
                        try {
                            this.streamMetadata = jpegReader.getStreamMetadata();
                        }
                        catch (Exception e) {
                            this.streamMetadata = null;
                            Object var14_14 = null;
                            jpegReader.reset();
                        }
                        Object var14_13 = null;
                        jpegReader.reset();
                    }
                    catch (Throwable throwable) {
                        Object var14_15 = null;
                        jpegReader.reset();
                        throw throwable;
                    }
                }
                if (this.streamMetadata == null) {
                    this.streamMetadata = this.JPEGWriter.getDefaultStreamMetadata(this.JPEGParam);
                    ByteArrayOutputStream tableByteStream = new ByteArrayOutputStream();
                    MemoryCacheImageOutputStream tableStream = new MemoryCacheImageOutputStream(tableByteStream);
                    this.JPEGWriter.setOutput(tableStream);
                    try {
                        this.JPEGWriter.prepareWriteSequence(this.streamMetadata);
                        tableStream.flush();
                        this.JPEGWriter.endWriteSequence();
                        byte[] tables = tableByteStream.toByteArray();
                        JPEGTablesField = new TIFFField(base.getTag(347), 7, tables.length, tables);
                        rootIFD.addTIFFField(JPEGTablesField);
                    }
                    catch (Exception e) {
                        rootIFD.removeTIFFField(347);
                        this.hasJPEGTables = false;
                    }
                }
            } else {
                rootIFD.removeTIFFField(347);
                this.initJPEGWriter(true);
            }
        }
    }

    public int encode(byte[] b, int off, int width, int height, int[] bitsPerSample, int scanlineStride) throws IOException {
        int compDataLength;
        ColorSpace cs;
        int[] offsets;
        DataBufferByte dbb;
        long initialStreamPosition;
        ImageOutputStream ios;
        if (!(bitsPerSample.length == 3 && bitsPerSample[0] == 8 && bitsPerSample[1] == 8 && bitsPerSample[2] == 8 || bitsPerSample.length == 1 && bitsPerSample[0] == 8)) {
            throw new IIOException("Can only JPEG compress 8- and 24-bit images!");
        }
        if (this.usingCodecLib) {
            ios = this.stream;
            initialStreamPosition = this.stream.getStreamPosition();
        } else {
            if (this.baos == null) {
                this.baos = new IIOByteArrayOutputStream();
            } else {
                this.baos.reset();
            }
            ios = new MemoryCacheImageOutputStream(this.baos);
            initialStreamPosition = 0L;
        }
        this.JPEGWriter.setOutput(ios);
        if (off == 0 || this.usingCodecLib) {
            dbb = new DataBufferByte(b, b.length - off, off);
        } else {
            byte[] btmp = new byte[b.length - off];
            System.arraycopy(b, off, btmp, 0, b.length - off);
            dbb = new DataBufferByte(btmp, btmp.length, 0);
        }
        if (bitsPerSample.length == 3) {
            offsets = new int[]{0, 1, 2};
            cs = ColorSpace.getInstance(1000);
        } else {
            offsets = new int[]{0};
            cs = ColorSpace.getInstance(1003);
        }
        ComponentColorModel cm = new ComponentColorModel(cs, false, false, 1, 0);
        PixelInterleavedSampleModel sm = new PixelInterleavedSampleModel(0, width, height, bitsPerSample.length, scanlineStride, offsets);
        WritableRaster wras = Raster.createWritableRaster(sm, dbb, new Point(0, 0));
        BufferedImage bi = new BufferedImage(cm, wras, false, null);
        if (this.usingCodecLib) {
            this.JPEGWriter.write(null, new IIOImage(bi, null, null), this.JPEGParam);
            compDataLength = (int)(this.stream.getStreamPosition() - initialStreamPosition);
        } else {
            if (this.hasJPEGTables) {
                this.JPEGWriter.prepareWriteSequence(this.streamMetadata);
                ios.flush();
                this.baos.reset();
                IIOMetadata emptyMetadata = this.getEmptyImageMetadata();
                IIOImage image = new IIOImage(bi, null, emptyMetadata);
                this.JPEGWriter.writeToSequence(image, this.JPEGParam);
                this.JPEGWriter.endWriteSequence();
            } else {
                this.JPEGWriter.write(null, new IIOImage(bi, null, null), this.JPEGParam);
            }
            compDataLength = this.baos.size();
            this.baos.writeTo(this.stream);
            this.baos.reset();
        }
        return compDataLength;
    }

    protected void finalize() throws Throwable {
        super.finalize();
        if (this.JPEGWriter != null) {
            this.JPEGWriter.dispose();
        }
    }

    static {
        DEBUG = false;
        CHROMA_SUBSAMPLING = 2;
        STREAM_METADATA_NAME = STREAM_METADATA_NAME;
        IMAGE_METADATA_NAME = IMAGE_METADATA_NAME;
    }

    private class IIOByteArrayOutputStream
    extends ByteArrayOutputStream {
        IIOByteArrayOutputStream() {
        }

        IIOByteArrayOutputStream(int size) {
            super(size);
        }

        public synchronized void writeTo(ImageOutputStream ios) throws IOException {
            ios.write(this.buf, 0, this.count);
        }
    }

    private static class JPEGSPIFilter
    implements ServiceRegistry.Filter {
        JPEGSPIFilter() {
        }

        public boolean filter(Object provider) {
            ImageReaderSpi readerSPI = (ImageReaderSpi)provider;
            if (readerSPI.getPluginClassName().startsWith("com.sun.imageio")) {
                String streamMetadataName = readerSPI.getNativeStreamMetadataFormatName();
                if (streamMetadataName != null) {
                    return streamMetadataName.indexOf("jpeg_stream") != -1;
                }
                return false;
            }
            return false;
        }
    }
}

