/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.imageioimpl.plugins.tiff;

import com.sun.media.imageio.plugins.tiff.TIFFDecompressor;
import com.sun.media.imageioimpl.plugins.tiff.I18N;
import java.io.IOException;
import java.util.zip.DataFormatException;
import java.util.zip.Inflater;
import javax.imageio.IIOException;

public class TIFFDeflateDecompressor
extends TIFFDecompressor {
    private static final boolean DEBUG = false;
    Inflater inflater = new Inflater();

    public synchronized void decodeRaw(byte[] b, int dstOffset, int bitsPerPixel, int scanlineStride) throws IOException {
        int bufOffset;
        byte[] buf;
        this.stream.seek(this.offset);
        byte[] srcData = new byte[this.byteCount];
        this.stream.readFully(srcData);
        int bytesPerRow = (this.srcWidth * bitsPerPixel + 7) / 8;
        if (bytesPerRow == scanlineStride) {
            buf = b;
            bufOffset = dstOffset;
        } else {
            buf = new byte[bytesPerRow * this.srcHeight];
            bufOffset = 0;
        }
        this.inflater.setInput(srcData);
        try {
            this.inflater.inflate(buf, bufOffset, bytesPerRow * this.srcHeight);
        }
        catch (DataFormatException dfe) {
            throw new IIOException(I18N.getString("TIFFDeflateDecompressor0"), dfe);
        }
        this.inflater.reset();
        if (bytesPerRow != scanlineStride) {
            int off = 0;
            int y = 0;
            while (y < this.srcHeight) {
                System.arraycopy(buf, off, b, dstOffset, bytesPerRow);
                off += bytesPerRow;
                dstOffset += scanlineStride;
                ++y;
            }
        }
    }

    static {
        DEBUG = false;
    }
}

