/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.imageioimpl.plugins.jpeg2000;

import com.sun.media.imageioimpl.common.ImageUtil;
import com.sun.media.imageioimpl.plugins.jpeg2000.Box;
import java.awt.image.IndexColorModel;
import javax.imageio.metadata.IIOInvalidTreeException;
import javax.imageio.metadata.IIOMetadataNode;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class PaletteBox
extends Box {
    private int numEntries;
    private int numComps;
    private byte[] bitDepth;
    private byte[][] lut;

    private static int computeLength(IndexColorModel icm) {
        int size = icm.getMapSize();
        int[] comp = icm.getComponentSize();
        return 11 + comp.length + size * comp.length;
    }

    private static byte[] getCompSize(IndexColorModel icm) {
        int[] comp = icm.getComponentSize();
        int size = comp.length;
        byte[] buf = new byte[size];
        int i = 0;
        while (i < size) {
            buf[i] = (byte)(comp[i] - 1);
            ++i;
        }
        return buf;
    }

    private static byte[][] getLUT(IndexColorModel icm) {
        int[] comp = icm.getComponentSize();
        int size = icm.getMapSize();
        byte[][] lut = new byte[comp.length][size];
        icm.getReds(lut[0]);
        icm.getGreens(lut[1]);
        icm.getBlues(lut[2]);
        if (comp.length == 4) {
            icm.getAlphas(lut[3]);
        }
        return lut;
    }

    public PaletteBox(IndexColorModel icm) {
        this(PaletteBox.computeLength(icm), PaletteBox.getCompSize(icm), PaletteBox.getLUT(icm));
    }

    public PaletteBox(Node node) throws IIOInvalidTreeException {
        super(node);
        byte[][] tlut = null;
        int index = 0;
        NodeList children = node.getChildNodes();
        int i = 0;
        while (i < children.getLength()) {
            Node child = children.item(i);
            String name = child.getNodeName();
            if ("NumberEntries".equals(name)) {
                this.numEntries = Box.getIntElementValue(child);
            }
            if ("NumberColors".equals(name)) {
                this.numComps = Box.getIntElementValue(child);
            }
            if ("BitDepth".equals(name)) {
                this.bitDepth = Box.getByteArrayElementValue(child);
            }
            if ("LUT".equals(name)) {
                tlut = new byte[this.numEntries][];
                NodeList children1 = child.getChildNodes();
                int j = 0;
                while (j < children1.getLength()) {
                    Node child1 = children1.item(j);
                    name = child1.getNodeName();
                    if ("LUTRow".equals(name)) {
                        tlut[index++] = Box.getByteArrayElementValue(child1);
                    }
                    ++j;
                }
            }
            ++i;
        }
        this.lut = new byte[this.numComps][this.numEntries];
        int i2 = 0;
        while (i2 < this.numComps) {
            int j = 0;
            while (j < this.numEntries) {
                this.lut[i2][j] = tlut[j][i2];
                ++j;
            }
            ++i2;
        }
    }

    public PaletteBox(int length, byte[] comp, byte[][] lut) {
        super(length, 1885564018, null);
        this.bitDepth = comp;
        this.lut = lut;
        this.numEntries = lut[0].length;
        this.numComps = lut.length;
    }

    public PaletteBox(byte[] data) {
        super(8 + data.length, 1885564018, data);
    }

    public int getNumEntries() {
        return this.numEntries;
    }

    public int getNumComp() {
        return this.numComps;
    }

    public byte[] getBitDepths() {
        return this.bitDepth;
    }

    public byte[][] getLUT() {
        return this.lut;
    }

    public IIOMetadataNode getNativeNode() {
        IIOMetadataNode node = new IIOMetadataNode(Box.getName(this.getType()));
        this.setDefaultAttributes(node);
        IIOMetadataNode child = new IIOMetadataNode("NumberEntries");
        child.setUserObject(new Integer(this.numEntries));
        child.setNodeValue("" + this.numEntries);
        node.appendChild(child);
        child = new IIOMetadataNode("NumberColors");
        child.setUserObject(new Integer(this.numComps));
        child.setNodeValue("" + this.numComps);
        node.appendChild(child);
        child = new IIOMetadataNode("BitDepth");
        child.setUserObject(this.bitDepth);
        child.setNodeValue(ImageUtil.convertObjectToString(this.bitDepth));
        node.appendChild(child);
        child = new IIOMetadataNode("LUT");
        int i = 0;
        while (i < this.numEntries) {
            IIOMetadataNode child1 = new IIOMetadataNode("LUTRow");
            byte[] row = new byte[this.numComps];
            int j = 0;
            while (j < this.numComps) {
                row[j] = this.lut[j][i];
                ++j;
            }
            child1.setUserObject(row);
            child1.setNodeValue(ImageUtil.convertObjectToString(row));
            child.appendChild(child1);
            ++i;
        }
        node.appendChild(child);
        return node;
    }

    protected void parse(byte[] data) {
        if (data == null) {
            return;
        }
        this.numEntries = (short)((data[0] & 0xFF) << 8 | data[1] & 0xFF);
        this.numComps = data[2];
        this.bitDepth = new byte[this.numComps];
        System.arraycopy(data, 3, this.bitDepth, 0, this.numComps);
        this.lut = new byte[this.numComps][this.numEntries];
        int i = 0;
        int k = 3 + this.numComps;
        while (i < this.numEntries) {
            int j = 0;
            while (j < this.numComps) {
                this.lut[j][i] = data[k++];
                ++j;
            }
            ++i;
        }
    }

    protected void compose() {
        if (this.data != null) {
            return;
        }
        this.data = new byte[3 + this.numComps + this.numEntries * this.numComps];
        this.data[0] = (byte)(this.numEntries >> 8);
        this.data[1] = (byte)(this.numEntries & 0xFF);
        this.data[2] = (byte)this.numComps;
        System.arraycopy(this.bitDepth, 0, this.data, 3, this.numComps);
        int i = 0;
        int k = 3 + this.numComps;
        while (i < this.numEntries) {
            int j = 0;
            while (j < this.numComps) {
                this.data[k++] = this.lut[j][i];
                ++j;
            }
            ++i;
        }
    }
}

