/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.imageioimpl.plugins.jpeg2000;

import com.sun.media.imageioimpl.common.ImageUtil;
import com.sun.medialib.codec.jiio.Util;
import com.sun.medialib.mlib.mediaLibImage;
import java.awt.Rectangle;
import java.awt.image.ComponentSampleModel;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferDouble;
import java.awt.image.DataBufferFloat;
import java.awt.image.DataBufferInt;
import java.awt.image.DataBufferShort;
import java.awt.image.DataBufferUShort;
import java.awt.image.Raster;
import java.awt.image.SampleModel;
import java.awt.image.WritableRaster;

public class MediaLibAccessor {
    private static final int COPY_MASK_SHIFT = 7;
    private static final int COPY_MASK_SIZE = 1;
    public static final int COPY_MASK = 128;
    public static final int UNCOPIED = 0;
    public static final int COPIED = 128;
    public static final int DATATYPE_MASK = 127;
    private static final int BINARY_MASK_SHIFT = 8;
    private static final int BINARY_MASK_SIZE = 1;
    public static final int BINARY_MASK = 256;
    public static final int NONBINARY = 0;
    public static final int BINARY = 256;
    public static final int TAG_BYTE_UNCOPIED = 0;
    public static final int TAG_USHORT_UNCOPIED = 1;
    public static final int TAG_SHORT_UNCOPIED = 2;
    public static final int TAG_INT_UNCOPIED = 3;
    public static final int TAG_FLOAT_UNCOPIED = 4;
    public static final int TAG_DOUBLE_UNCOPIED = 5;
    public static final int TAG_BYTE_COPIED = 128;
    public static final int TAG_USHORT_COPIED = 129;
    public static final int TAG_SHORT_COPIED = 130;
    public static final int TAG_INT_COPIED = 131;
    public static final int TAG_FLOAT_COPIED = 132;
    public static final int TAG_DOUBLE_COPIED = 133;
    protected Raster raster;
    protected Rectangle rect;
    protected int numBands;
    protected int[] bandOffsets;
    protected int formatTag;
    protected mediaLibImage[] mlimages = null;
    private boolean areBinaryDataPacked = false;

    public static int findCompatibleTag(Raster src) {
        SampleModel dstSM = src.getSampleModel();
        int dstDT = dstSM.getDataType();
        int defaultDataType = dstSM.getDataType();
        boolean allComponentSampleModel = dstSM instanceof ComponentSampleModel;
        boolean allBinary = ImageUtil.isBinary(dstSM);
        if (allBinary) {
            return 256;
        }
        if (!(allComponentSampleModel || defaultDataType != 0 && defaultDataType != 1 && defaultDataType != 2)) {
            defaultDataType = 3;
        }
        int tag = defaultDataType | 0x80;
        if (!allComponentSampleModel) {
            return tag;
        }
        if (MediaLibAccessor.isPixelSequential(dstSM)) {
            return dstDT | 0;
        }
        return tag;
    }

    public static boolean isPixelSequential(SampleModel sm) {
        ComponentSampleModel csm = null;
        if (!(sm instanceof ComponentSampleModel)) {
            return false;
        }
        csm = (ComponentSampleModel)sm;
        int pixelStride = csm.getPixelStride();
        int[] bandOffsets = csm.getBandOffsets();
        int[] bankIndices = csm.getBankIndices();
        if (pixelStride != bandOffsets.length) {
            return false;
        }
        if (pixelStride != sm.getNumBands()) {
            return false;
        }
        int i = 0;
        while (i < bandOffsets.length) {
            if (bandOffsets[i] >= pixelStride || bankIndices[i] != bankIndices[0]) {
                return false;
            }
            int j = i + 1;
            while (j < bandOffsets.length) {
                if (bandOffsets[i] == bandOffsets[j]) {
                    return false;
                }
                if (bandOffsets[i] != i) {
                    return false;
                }
                ++j;
            }
            ++i;
        }
        return true;
    }

    public static int getMediaLibDataType(int formatTag) {
        int dataType = formatTag & 0x7F;
        switch (dataType) {
            case 0: {
                return 1;
            }
            case 1: {
                return 6;
            }
            case 2: {
                return 2;
            }
            case 3: {
                return 3;
            }
            case 5: {
                return 5;
            }
            case 4: {
                return 4;
            }
        }
        return -1;
    }

    public MediaLibAccessor(Raster raster, Rectangle rect, int formatTag, boolean preferPacked) {
        this.areBinaryDataPacked = preferPacked;
        this.raster = raster;
        this.rect = new Rectangle(rect);
        this.formatTag = formatTag;
        if (this.isBinary()) {
            byte[] bdata;
            int scanlineStride;
            int mlibType;
            this.numBands = 1;
            this.bandOffsets = new int[]{0};
            this.mlimages = new mediaLibImage[1];
            if (this.areBinaryDataPacked) {
                mlibType = 0;
                scanlineStride = (rect.width + 7) / 8;
                bdata = ImageUtil.getPackedBinaryData(raster, rect);
                this.formatTag = bdata == ((DataBufferByte)raster.getDataBuffer()).getData() ? (this.formatTag |= 0) : (this.formatTag |= 0x80);
            } else {
                mlibType = 1;
                scanlineStride = rect.width;
                bdata = ImageUtil.getUnpackedBinaryData(raster, rect);
                this.formatTag |= 0x80;
            }
            this.mlimages[0] = new mediaLibImage(mlibType, 1, rect.width, rect.height, scanlineStride, 0, (Object)bdata);
            return;
        }
        if ((formatTag & 0x80) == 0) {
            ComponentSampleModel csm = (ComponentSampleModel)raster.getSampleModel();
            this.numBands = csm.getNumBands();
            this.bandOffsets = csm.getBandOffsets();
            int dataOffset = raster.getDataBuffer().getOffset();
            dataOffset += (rect.y - raster.getSampleModelTranslateY()) * csm.getScanlineStride() + (rect.x - raster.getSampleModelTranslateX()) * csm.getPixelStride();
            int scanlineStride = csm.getScanlineStride();
            switch (formatTag & 0x7F) {
                case 0: {
                    DataBufferByte dbb = (DataBufferByte)raster.getDataBuffer();
                    this.mlimages = new mediaLibImage[1];
                    this.mlimages[0] = new mediaLibImage(1, this.numBands, rect.width, rect.height, scanlineStride, dataOffset, (Object)dbb.getData());
                    break;
                }
                case 1: {
                    DataBufferUShort dbus = (DataBufferUShort)raster.getDataBuffer();
                    this.mlimages = new mediaLibImage[1];
                    this.mlimages[0] = new mediaLibImage(6, this.numBands, rect.width, rect.height, scanlineStride, dataOffset, (Object)dbus.getData());
                    break;
                }
                case 2: {
                    DataBufferShort dbs = (DataBufferShort)raster.getDataBuffer();
                    this.mlimages = new mediaLibImage[1];
                    this.mlimages[0] = new mediaLibImage(2, this.numBands, rect.width, rect.height, scanlineStride, dataOffset, (Object)dbs.getData());
                    break;
                }
                case 3: {
                    DataBufferInt dbi = (DataBufferInt)raster.getDataBuffer();
                    this.mlimages = new mediaLibImage[1];
                    this.mlimages[0] = new mediaLibImage(3, this.numBands, rect.width, rect.height, scanlineStride, dataOffset, (Object)dbi.getData());
                    break;
                }
                case 4: {
                    DataBufferFloat dbf = (DataBufferFloat)raster.getDataBuffer();
                    this.mlimages = new mediaLibImage[1];
                    this.mlimages[0] = new mediaLibImage(4, this.numBands, rect.width, rect.height, scanlineStride, dataOffset, (Object)dbf.getData());
                    break;
                }
                case 5: {
                    DataBufferDouble dbd = (DataBufferDouble)raster.getDataBuffer();
                    this.mlimages = new mediaLibImage[1];
                    this.mlimages[0] = new mediaLibImage(5, this.numBands, rect.width, rect.height, scanlineStride, dataOffset, (Object)dbd.getData());
                    break;
                }
                default: {
                    throw new IllegalArgumentException((formatTag & 0x7F) + "MediaLibAccessor does not recognize this datatype.");
                }
            }
        } else {
            this.numBands = raster.getNumBands();
            this.bandOffsets = new int[this.numBands];
            int i = 0;
            while (i < this.numBands) {
                this.bandOffsets[i] = i;
                ++i;
            }
            int scanlineStride = rect.width * this.numBands;
            switch (formatTag & 0x7F) {
                case 0: {
                    byte[] bdata = new byte[rect.width * rect.height * this.numBands];
                    this.mlimages = new mediaLibImage[1];
                    this.mlimages[0] = new mediaLibImage(1, this.numBands, rect.width, rect.height, scanlineStride, 0, (Object)bdata);
                    break;
                }
                case 1: {
                    short[] usdata = new short[rect.width * rect.height * this.numBands];
                    this.mlimages = new mediaLibImage[1];
                    this.mlimages[0] = new mediaLibImage(6, this.numBands, rect.width, rect.height, scanlineStride, 0, (Object)usdata);
                    break;
                }
                case 2: {
                    short[] sdata = new short[rect.width * rect.height * this.numBands];
                    this.mlimages = new mediaLibImage[1];
                    this.mlimages[0] = new mediaLibImage(2, this.numBands, rect.width, rect.height, scanlineStride, 0, (Object)sdata);
                    break;
                }
                case 3: {
                    int[] idata = new int[rect.width * rect.height * this.numBands];
                    this.mlimages = new mediaLibImage[1];
                    this.mlimages[0] = new mediaLibImage(3, this.numBands, rect.width, rect.height, scanlineStride, 0, (Object)idata);
                    break;
                }
                case 4: {
                    float[] fdata = new float[rect.width * rect.height * this.numBands];
                    this.mlimages = new mediaLibImage[1];
                    this.mlimages[0] = new mediaLibImage(4, this.numBands, rect.width, rect.height, scanlineStride, 0, (Object)fdata);
                    break;
                }
                case 5: {
                    double[] ddata = new double[rect.width * rect.height * this.numBands];
                    this.mlimages = new mediaLibImage[1];
                    this.mlimages[0] = new mediaLibImage(5, this.numBands, rect.width, rect.height, scanlineStride, 0, (Object)ddata);
                    break;
                }
                default: {
                    throw new IllegalArgumentException((formatTag & 0x7F) + "MediaLibAccessor does not recognize this datatype.");
                }
            }
            this.copyDataFromRaster();
        }
    }

    public boolean isBinary() {
        return (this.formatTag & 0x100) == 256;
    }

    public mediaLibImage[] getMediaLibImages() {
        return this.mlimages;
    }

    public int getDataType() {
        return this.formatTag & 0x7F;
    }

    public boolean isDataCopy() {
        return (this.formatTag & 0x80) == 128;
    }

    public int[] getBandOffsets() {
        return this.bandOffsets;
    }

    public int[] getIntParameters(int band, int[] params) {
        int[] returnParams = new int[this.numBands];
        int i = 0;
        while (i < this.numBands) {
            returnParams[i] = params[this.bandOffsets[i + band]];
            ++i;
        }
        return returnParams;
    }

    public int[][] getIntArrayParameters(int band, int[][] params) {
        int[][] returnParams = new int[this.numBands][];
        int i = 0;
        while (i < this.numBands) {
            returnParams[i] = params[this.bandOffsets[i + band]];
            ++i;
        }
        return returnParams;
    }

    public double[] getDoubleParameters(int band, double[] params) {
        double[] returnParams = new double[this.numBands];
        int i = 0;
        while (i < this.numBands) {
            returnParams[i] = params[this.bandOffsets[i + band]];
            ++i;
        }
        return returnParams;
    }

    private void copyDataFromRaster() {
        if (this.raster.getSampleModel() instanceof ComponentSampleModel) {
            int i;
            ComponentSampleModel csm = (ComponentSampleModel)this.raster.getSampleModel();
            int rasScanlineStride = csm.getScanlineStride();
            int rasPixelStride = csm.getPixelStride();
            int subRasterOffset = (this.rect.y - this.raster.getSampleModelTranslateY()) * rasScanlineStride + (this.rect.x - this.raster.getSampleModelTranslateX()) * rasPixelStride;
            int[] rasBankIndices = csm.getBankIndices();
            int[] rasBandOffsets = csm.getBandOffsets();
            int[] rasDataOffsets = this.raster.getDataBuffer().getOffsets();
            if (rasDataOffsets.length == 1) {
                i = 0;
                while (i < this.numBands) {
                    int n = i++;
                    rasBandOffsets[n] = rasBandOffsets[n] + (rasDataOffsets[0] + subRasterOffset);
                }
            } else if (rasDataOffsets.length == rasBandOffsets.length) {
                i = 0;
                while (i < this.numBands) {
                    int n = i;
                    rasBandOffsets[n] = rasBandOffsets[n] + (rasDataOffsets[i] + subRasterOffset);
                    ++i;
                }
            }
            Object mlibDataArray = null;
            switch (this.getDataType()) {
                case 0: {
                    byte[][] bArray = new byte[this.numBands][];
                    int i2 = 0;
                    while (i2 < this.numBands) {
                        bArray[i2] = this.mlimages[0].getByteData();
                        ++i2;
                    }
                    mlibDataArray = bArray;
                    break;
                }
                case 1: {
                    short[][] usArray = new short[this.numBands][];
                    int i3 = 0;
                    while (i3 < this.numBands) {
                        usArray[i3] = this.mlimages[0].getUShortData();
                        ++i3;
                    }
                    mlibDataArray = usArray;
                    break;
                }
                case 2: {
                    short[][] sArray = new short[this.numBands][];
                    int i4 = 0;
                    while (i4 < this.numBands) {
                        sArray[i4] = this.mlimages[0].getShortData();
                        ++i4;
                    }
                    mlibDataArray = sArray;
                    break;
                }
                case 3: {
                    int[][] iArray = new int[this.numBands][];
                    int i5 = 0;
                    while (i5 < this.numBands) {
                        iArray[i5] = this.mlimages[0].getIntData();
                        ++i5;
                    }
                    mlibDataArray = iArray;
                    break;
                }
                case 4: {
                    float[][] fArray = new float[this.numBands][];
                    int i6 = 0;
                    while (i6 < this.numBands) {
                        fArray[i6] = this.mlimages[0].getFloatData();
                        ++i6;
                    }
                    mlibDataArray = fArray;
                    break;
                }
                case 5: {
                    double[][] dArray = new double[this.numBands][];
                    int i7 = 0;
                    while (i7 < this.numBands) {
                        dArray[i7] = this.mlimages[0].getDoubleData();
                        ++i7;
                    }
                    mlibDataArray = dArray;
                }
            }
            Object rasDataArray = null;
            switch (csm.getDataType()) {
                case 0: {
                    DataBufferByte dbb = (DataBufferByte)this.raster.getDataBuffer();
                    byte[][] rasByteDataArray = new byte[this.numBands][];
                    int i8 = 0;
                    while (i8 < this.numBands) {
                        rasByteDataArray[i8] = dbb.getData(rasBankIndices[i8]);
                        ++i8;
                    }
                    rasDataArray = rasByteDataArray;
                    break;
                }
                case 1: {
                    DataBufferUShort dbus = (DataBufferUShort)this.raster.getDataBuffer();
                    short[][] rasUShortDataArray = new short[this.numBands][];
                    int i9 = 0;
                    while (i9 < this.numBands) {
                        rasUShortDataArray[i9] = dbus.getData(rasBankIndices[i9]);
                        ++i9;
                    }
                    rasDataArray = rasUShortDataArray;
                    break;
                }
                case 2: {
                    DataBufferShort dbs = (DataBufferShort)this.raster.getDataBuffer();
                    short[][] rasShortDataArray = new short[this.numBands][];
                    int i10 = 0;
                    while (i10 < this.numBands) {
                        rasShortDataArray[i10] = dbs.getData(rasBankIndices[i10]);
                        ++i10;
                    }
                    rasDataArray = rasShortDataArray;
                    break;
                }
                case 3: {
                    DataBufferInt dbi = (DataBufferInt)this.raster.getDataBuffer();
                    int[][] rasIntDataArray = new int[this.numBands][];
                    int i11 = 0;
                    while (i11 < this.numBands) {
                        rasIntDataArray[i11] = dbi.getData(rasBankIndices[i11]);
                        ++i11;
                    }
                    rasDataArray = rasIntDataArray;
                    break;
                }
                case 4: {
                    DataBufferFloat dbf = (DataBufferFloat)this.raster.getDataBuffer();
                    float[][] rasFloatDataArray = new float[this.numBands][];
                    int i12 = 0;
                    while (i12 < this.numBands) {
                        rasFloatDataArray[i12] = dbf.getData(rasBankIndices[i12]);
                        ++i12;
                    }
                    rasDataArray = rasFloatDataArray;
                    break;
                }
                case 5: {
                    DataBufferDouble dbd = (DataBufferDouble)this.raster.getDataBuffer();
                    double[][] rasDoubleDataArray = new double[this.numBands][];
                    int i13 = 0;
                    while (i13 < this.numBands) {
                        rasDoubleDataArray[i13] = dbd.getData(rasBankIndices[i13]);
                        ++i13;
                    }
                    rasDataArray = rasDoubleDataArray;
                }
            }
            Util.Reformat((Object)mlibDataArray, (Object)rasDataArray, (int)this.numBands, (int)this.rect.width, (int)this.rect.height, (int)MediaLibAccessor.getMediaLibDataType(this.getDataType()), (int[])this.bandOffsets, (int)(this.rect.width * this.numBands), (int)this.numBands, (int)MediaLibAccessor.getMediaLibDataType(csm.getDataType()), (int[])rasBandOffsets, (int)rasScanlineStride, (int)rasPixelStride);
        } else {
            switch (this.getDataType()) {
                case 3: {
                    this.raster.getPixels(this.rect.x, this.rect.y, this.rect.width, this.rect.height, this.mlimages[0].getIntData());
                    break;
                }
                case 4: {
                    this.raster.getPixels(this.rect.x, this.rect.y, this.rect.width, this.rect.height, this.mlimages[0].getFloatData());
                    break;
                }
                case 5: {
                    this.raster.getPixels(this.rect.x, this.rect.y, this.rect.width, this.rect.height, this.mlimages[0].getDoubleData());
                }
            }
        }
    }

    public void copyDataToRaster(int[] channelMap) {
        if (this.isDataCopy()) {
            if (this.isBinary()) {
                if (this.areBinaryDataPacked) {
                    ImageUtil.setPackedBinaryData(this.mlimages[0].getBitData(), (WritableRaster)this.raster, this.rect);
                } else {
                    ImageUtil.setUnpackedBinaryData(this.mlimages[0].getByteData(), (WritableRaster)this.raster, this.rect);
                }
                return;
            }
            WritableRaster wr = (WritableRaster)this.raster;
            if (wr.getSampleModel() instanceof ComponentSampleModel) {
                int i;
                ComponentSampleModel csm = (ComponentSampleModel)wr.getSampleModel();
                int rasScanlineStride = csm.getScanlineStride();
                int rasPixelStride = csm.getPixelStride();
                int subRasterOffset = (this.rect.y - this.raster.getSampleModelTranslateY()) * rasScanlineStride + (this.rect.x - this.raster.getSampleModelTranslateX()) * rasPixelStride;
                int[] rasBankIndices = csm.getBankIndices();
                int[] rasBandOffsets = csm.getBandOffsets();
                int[] rasDataOffsets = this.raster.getDataBuffer().getOffsets();
                if (rasDataOffsets.length == 1) {
                    i = 0;
                    while (i < this.numBands) {
                        int n = i++;
                        rasBandOffsets[n] = rasBandOffsets[n] + (rasDataOffsets[0] + subRasterOffset);
                    }
                } else if (rasDataOffsets.length == rasBandOffsets.length) {
                    i = 0;
                    while (i < this.numBands) {
                        int n = i;
                        rasBandOffsets[n] = rasBandOffsets[n] + (rasDataOffsets[i] + subRasterOffset);
                        ++i;
                    }
                }
                Object mlibDataArray = null;
                switch (this.getDataType()) {
                    case 0: {
                        byte[][] bArray = new byte[this.numBands][];
                        int i2 = 0;
                        while (i2 < this.numBands) {
                            bArray[i2] = this.mlimages[0].getByteData();
                            ++i2;
                        }
                        mlibDataArray = bArray;
                        break;
                    }
                    case 1: {
                        short[][] usArray = new short[this.numBands][];
                        int i3 = 0;
                        while (i3 < this.numBands) {
                            usArray[i3] = this.mlimages[0].getUShortData();
                            ++i3;
                        }
                        mlibDataArray = usArray;
                        break;
                    }
                    case 2: {
                        short[][] sArray = new short[this.numBands][];
                        int i4 = 0;
                        while (i4 < this.numBands) {
                            sArray[i4] = this.mlimages[0].getShortData();
                            ++i4;
                        }
                        mlibDataArray = sArray;
                        break;
                    }
                    case 3: {
                        int[][] iArray = new int[this.numBands][];
                        int i5 = 0;
                        while (i5 < this.numBands) {
                            iArray[i5] = this.mlimages[0].getIntData();
                            ++i5;
                        }
                        mlibDataArray = iArray;
                        break;
                    }
                    case 4: {
                        float[][] fArray = new float[this.numBands][];
                        int i6 = 0;
                        while (i6 < this.numBands) {
                            fArray[i6] = this.mlimages[0].getFloatData();
                            ++i6;
                        }
                        mlibDataArray = fArray;
                        break;
                    }
                    case 5: {
                        double[][] dArray = new double[this.numBands][];
                        int i7 = 0;
                        while (i7 < this.numBands) {
                            dArray[i7] = this.mlimages[0].getDoubleData();
                            ++i7;
                        }
                        mlibDataArray = dArray;
                    }
                }
                byte[] tmpDataArray = null;
                Object rasDataArray = null;
                switch (csm.getDataType()) {
                    case 0: {
                        DataBufferByte dbb = (DataBufferByte)this.raster.getDataBuffer();
                        byte[][] rasByteDataArray = new byte[this.numBands][];
                        int i8 = 0;
                        while (i8 < this.numBands) {
                            rasByteDataArray[i8] = dbb.getData(rasBankIndices[i8]);
                            ++i8;
                        }
                        tmpDataArray = rasByteDataArray[0];
                        rasDataArray = rasByteDataArray;
                        break;
                    }
                    case 1: {
                        DataBufferUShort dbus = (DataBufferUShort)this.raster.getDataBuffer();
                        short[][] rasUShortDataArray = new short[this.numBands][];
                        int i8 = 0;
                        while (i8 < this.numBands) {
                            rasUShortDataArray[i8] = dbus.getData(rasBankIndices[i8]);
                            ++i8;
                        }
                        rasDataArray = rasUShortDataArray;
                        break;
                    }
                    case 2: {
                        DataBufferShort dbs = (DataBufferShort)this.raster.getDataBuffer();
                        short[][] rasShortDataArray = new short[this.numBands][];
                        int i8 = 0;
                        while (i8 < this.numBands) {
                            rasShortDataArray[i8] = dbs.getData(rasBankIndices[i8]);
                            ++i8;
                        }
                        rasDataArray = rasShortDataArray;
                        break;
                    }
                    case 3: {
                        DataBufferInt dbi = (DataBufferInt)this.raster.getDataBuffer();
                        int[][] rasIntDataArray = new int[this.numBands][];
                        int i8 = 0;
                        while (i8 < this.numBands) {
                            rasIntDataArray[i8] = dbi.getData(rasBankIndices[i8]);
                            ++i8;
                        }
                        rasDataArray = rasIntDataArray;
                        break;
                    }
                    case 4: {
                        DataBufferFloat dbf = (DataBufferFloat)this.raster.getDataBuffer();
                        float[][] rasFloatDataArray = new float[this.numBands][];
                        int i8 = 0;
                        while (i8 < this.numBands) {
                            rasFloatDataArray[i8] = dbf.getData(rasBankIndices[i8]);
                            ++i8;
                        }
                        rasDataArray = rasFloatDataArray;
                        break;
                    }
                    case 5: {
                        DataBufferDouble dbd = (DataBufferDouble)this.raster.getDataBuffer();
                        double[][] rasDoubleDataArray = new double[this.numBands][];
                        int i8 = 0;
                        while (i8 < this.numBands) {
                            rasDoubleDataArray[i8] = dbd.getData(rasBankIndices[i8]);
                            ++i8;
                        }
                        rasDataArray = rasDoubleDataArray;
                    }
                }
                int[] bandOffsetCopy = (int[])this.bandOffsets.clone();
                if (channelMap != null) {
                    int i9 = 0;
                    while (i9 < bandOffsetCopy.length) {
                        bandOffsetCopy[i9] = channelMap[bandOffsetCopy[i9]];
                        ++i9;
                    }
                }
                Util.Reformat((Object)rasDataArray, (Object)mlibDataArray, (int)this.numBands, (int)this.rect.width, (int)this.rect.height, (int)MediaLibAccessor.getMediaLibDataType(csm.getDataType()), (int[])rasBandOffsets, (int)rasScanlineStride, (int)rasPixelStride, (int)MediaLibAccessor.getMediaLibDataType(this.getDataType()), (int[])bandOffsetCopy, (int)(this.rect.width * this.numBands), (int)this.numBands);
            } else {
                switch (this.getDataType()) {
                    case 3: {
                        wr.setPixels(this.rect.x, this.rect.y, this.rect.width, this.rect.height, this.mlimages[0].getIntData());
                        break;
                    }
                    case 4: {
                        wr.setPixels(this.rect.x, this.rect.y, this.rect.width, this.rect.height, this.mlimages[0].getFloatData());
                        break;
                    }
                    case 5: {
                        wr.setPixels(this.rect.x, this.rect.y, this.rect.width, this.rect.height, this.mlimages[0].getDoubleData());
                    }
                }
            }
        }
    }

    public void clampDataArrays() {
        if (!this.isDataCopy()) {
            return;
        }
        if (this.raster.getSampleModel() instanceof ComponentSampleModel) {
            return;
        }
        int[] bits = this.raster.getSampleModel().getSampleSize();
        boolean needClamp = false;
        boolean uniformBitSize = true;
        int i = 0;
        while (i < bits.length) {
            int bitSize = bits[0];
            if (bits[i] < 32) {
                needClamp = true;
            }
            if (bits[i] != bitSize) {
                uniformBitSize = false;
            }
            ++i;
        }
        if (!needClamp) {
            return;
        }
        int dataType = this.raster.getDataBuffer().getDataType();
        double[] hiVals = new double[bits.length];
        double[] loVals = new double[bits.length];
        if (dataType == 1 && uniformBitSize && bits[0] == 16) {
            int i2 = 0;
            while (i2 < bits.length) {
                hiVals[i2] = 65535.0;
                loVals[i2] = 0.0;
                ++i2;
            }
        } else if (dataType == 2 && uniformBitSize && bits[0] == 16) {
            int i3 = 0;
            while (i3 < bits.length) {
                hiVals[i3] = 32767.0;
                loVals[i3] = -32768.0;
                ++i3;
            }
        } else if (dataType == 3 && uniformBitSize && bits[0] == 32) {
            int i4 = 0;
            while (i4 < bits.length) {
                hiVals[i4] = 2.147483647E9;
                loVals[i4] = -2.147483648E9;
                ++i4;
            }
        } else {
            int i5 = 0;
            while (i5 < bits.length) {
                hiVals[i5] = (1 << bits[i5]) - 1;
                loVals[i5] = 0.0;
                ++i5;
            }
        }
        this.clampDataArray(hiVals, loVals);
    }

    private void clampDataArray(double[] hiVals, double[] loVals) {
        switch (this.getDataType()) {
            case 3: {
                this.clampIntArrays(this.toIntArray(hiVals), this.toIntArray(loVals));
                break;
            }
            case 4: {
                this.clampFloatArrays(this.toFloatArray(hiVals), this.toFloatArray(loVals));
                break;
            }
            case 5: {
                this.clampDoubleArrays(hiVals, loVals);
            }
        }
    }

    private int[] toIntArray(double[] vals) {
        int[] returnVals = new int[vals.length];
        int i = 0;
        while (i < vals.length) {
            returnVals[i] = (int)vals[i];
            ++i;
        }
        return returnVals;
    }

    private float[] toFloatArray(double[] vals) {
        float[] returnVals = new float[vals.length];
        int i = 0;
        while (i < vals.length) {
            returnVals[i] = (float)vals[i];
            ++i;
        }
        return returnVals;
    }

    private void clampIntArrays(int[] hiVals, int[] loVals) {
        int width = this.rect.width;
        int height = this.rect.height;
        int scanlineStride = this.numBands * width;
        int k = 0;
        while (k < this.numBands) {
            int[] data = this.mlimages[0].getIntData();
            int scanlineOffset = k;
            int hiVal = hiVals[k];
            int loVal = loVals[k];
            int j = 0;
            while (j < height) {
                int pixelOffset = scanlineOffset;
                int i = 0;
                while (i < width) {
                    int tmp = data[pixelOffset];
                    if (tmp < loVal) {
                        data[pixelOffset] = loVal;
                    } else if (tmp > hiVal) {
                        data[pixelOffset] = hiVal;
                    }
                    pixelOffset += this.numBands;
                    ++i;
                }
                scanlineOffset += scanlineStride;
                ++j;
            }
            ++k;
        }
    }

    private void clampFloatArrays(float[] hiVals, float[] loVals) {
        int width = this.rect.width;
        int height = this.rect.height;
        int scanlineStride = this.numBands * width;
        int k = 0;
        while (k < this.numBands) {
            float[] data = this.mlimages[0].getFloatData();
            int scanlineOffset = k;
            float hiVal = hiVals[k];
            float loVal = loVals[k];
            int j = 0;
            while (j < height) {
                int pixelOffset = scanlineOffset;
                int i = 0;
                while (i < width) {
                    float tmp = data[pixelOffset];
                    if (tmp < loVal) {
                        data[pixelOffset] = loVal;
                    } else if (tmp > hiVal) {
                        data[pixelOffset] = hiVal;
                    }
                    pixelOffset += this.numBands;
                    ++i;
                }
                scanlineOffset += scanlineStride;
                ++j;
            }
            ++k;
        }
    }

    private void clampDoubleArrays(double[] hiVals, double[] loVals) {
        int width = this.rect.width;
        int height = this.rect.height;
        int scanlineStride = this.numBands * width;
        int k = 0;
        while (k < this.numBands) {
            double[] data = this.mlimages[0].getDoubleData();
            int scanlineOffset = k;
            double hiVal = hiVals[k];
            double loVal = loVals[k];
            int j = 0;
            while (j < height) {
                int pixelOffset = scanlineOffset;
                int i = 0;
                while (i < width) {
                    double tmp = data[pixelOffset];
                    if (tmp < loVal) {
                        data[pixelOffset] = loVal;
                    } else if (tmp > hiVal) {
                        data[pixelOffset] = hiVal;
                    }
                    pixelOffset += this.numBands;
                    ++i;
                }
                scanlineOffset += scanlineStride;
                ++j;
            }
            ++k;
        }
    }

    static {
        COPY_MASK_SHIFT = 7;
        COPY_MASK_SIZE = 1;
        COPY_MASK = 128;
        UNCOPIED = 0;
        COPIED = 128;
        DATATYPE_MASK = 127;
        BINARY_MASK_SHIFT = 8;
        BINARY_MASK_SIZE = 1;
        BINARY_MASK = 256;
        NONBINARY = 0;
        BINARY = 256;
        TAG_BYTE_UNCOPIED = 0;
        TAG_USHORT_UNCOPIED = 1;
        TAG_SHORT_UNCOPIED = 2;
        TAG_INT_UNCOPIED = 3;
        TAG_FLOAT_UNCOPIED = 4;
        TAG_DOUBLE_UNCOPIED = 5;
        TAG_BYTE_COPIED = 128;
        TAG_USHORT_COPIED = 129;
        TAG_SHORT_COPIED = 130;
        TAG_INT_COPIED = 131;
        TAG_FLOAT_COPIED = 132;
        TAG_DOUBLE_COPIED = 133;
    }
}

