/*
    sayclubprotocol.cpp - Kopete Sayclub Protocol

    Copyright (c) 2006      by Park J. K.		 <nemesis@planetmono.org>
    Kopete    (c) 2002-2003 by the Kopete developers <kopete-devel@kde.org>

    *************************************************************************
    *                                                                       *
    * This library is free software; you can redistribute it and/or         *
    * modify it under the terms of the GNU General Public                   *
    * License as published by the Free Software Foundation; either          *
    * version 2 of the License, or (at your option) any later version.      *
    *                                                                       *
    *************************************************************************
*/
#include <kgenericfactory.h>
#include <kdebug.h>

#include <kopeteglobal.h>
#include <kopeteaccountmanager.h>

#include "sayclubprotocol.h"
#include "sayclubaccount.h"
#include "sayclubcontact.h"
#include "sayclubaddcontactpage.h"
#include "sayclubeditaccountwidget.h"

typedef KGenericFactory<SayclubProtocol> SayclubProtocolFactory;
K_EXPORT_COMPONENT_FACTORY( kopete_sayclub, SayclubProtocolFactory( "kopete_sayclub" )  )

SayclubProtocol *SayclubProtocol::s_protocol = 0L;

SayclubProtocol::SayclubProtocol( QObject* parent, const char *name, const QStringList &/*args*/ )
	: Kopete::Protocol( SayclubProtocolFactory::instance(), parent, name ),
	sayclubOnline( Kopete::OnlineStatus::Online, 25, this, 0, QString::null, QString::fromUtf8( "온라인" ), QString::fromUtf8( "온라인(&O)" ) ),
	sayclubAway( Kopete::OnlineStatus::Away, 23, this, 1, "sayclub_away", QString::fromUtf8( "자리 비움" ), QString::fromUtf8( "자리 비움(&A)" ) ),
	sayclubBusy( Kopete::OnlineStatus::Away, 21, this, 2, "sayclub_busy", QString::fromUtf8( "다른 용무중" ), QString::fromUtf8( "다른 용무중(&B)" ) ),
	sayclubOffline( Kopete::OnlineStatus::Offline, 19, this, 3, QString::null, QString::fromUtf8( "오프라인" ), QString::fromUtf8( "오프라인(&F)" ) ),
	statConnecting( Kopete::OnlineStatus::Connecting, 2, this, 4, "sayclub_connecting", QString::fromUtf8( "접속중" ) ),
	propMsrl( "msrl", QString::fromUtf8( "일련 번호" ), QString::null, true ),
	propMyDesc( "mydesc", QString::fromUtf8( "메모" ), QString::null, true, false, true ),
	propReversed( "reversed", QString::fromUtf8( "등록여부" ), QString::null, true ),
	propPersonalMessage( Kopete::Global::Properties::self()->awayMessage() )
{
	kdDebug( 14210 ) << k_funcinfo << endl;
	
	s_protocol = this;
	setCapabilities( Kopete::Protocol::CanSendOffline );
	addAddressBookField("messaging/sayclub", Kopete::Plugin::MakeIndexField);
}

SayclubProtocol::~SayclubProtocol()
{
}

Kopete::Contact *SayclubProtocol::deserializeContact( Kopete::MetaContact *metaContact, const QMap<QString, QString> &serializedData, const QMap<QString, QString> &/* addressBookData */ )
{
	QString contactId = serializedData[ "contactId" ];
	QString accountId = serializedData[ "accountId" ];
	QString displayName = serializedData[ "displayName" ];
	
	QDict<Kopete::Account> accounts = Kopete::AccountManager::self()->accounts( this );
	
	Kopete::Account *account = accounts[ accountId ];
	if ( !account )
	{
		kdDebug(14210) << "Account doesn't exist, skipping" << endl;
		return 0;
	}

	return new SayclubContact(account, contactId, metaContact);
}

AddContactPage * SayclubProtocol::createAddContactWidget( QWidget *parent, Kopete::Account * /* account */ )
{
	kdDebug( 14210 ) << "Creating Add Contact Page" << endl;
	
	return new SayclubAddContactPage( parent );
}

KopeteEditAccountWidget * SayclubProtocol::createEditAccountWidget( Kopete::Account *account, QWidget *parent )
{
	kdDebug(14210) << "Creating Edit Account Page" << endl;
	
	return new SayclubEditAccountWidget( parent, account );
}

Kopete::Account *SayclubProtocol::createNewAccount( const QString &accountId )
{
	kdDebug(14210) << k_funcinfo << endl;
	
	return new SayclubAccount( this, accountId );
}

SayclubProtocol *SayclubProtocol::protocol()
{
	return s_protocol;
}



#include "sayclubprotocol.moc"
