/*
    sayclubcontact.cpp - Kopete Sayclub Protocol

    Copyright (c) 2006      by Park J. K.		 <nemesis@planetmono.org>
    Kopete    (c) 2002-2003 by the Kopete developers <kopete-devel@kde.org>

    *************************************************************************
    *                                                                       *
    * This library is free software; you can redistribute it and/or         *
    * modify it under the terms of the GNU General Public                   *
    * License as published by the Free Software Foundation; either          *
    * version 2 of the License, or (at your option) any later version.      *
    *                                                                       *
    *************************************************************************
*/

#ifndef SAYCLUBCONTACT_H
#define SAYCLUBCONTACT_H

#include <qmap.h>
#include "kopetecontact.h"
#include "kopetemessage.h"

class KAction;
class KActionCollection;

class SayclubAccount;

namespace Kopete
{
	class Account; 
	class ChatSession;
	class MetaContact;
}

class SayclubContact : public Kopete::Contact
{
	Q_OBJECT
	
public:
	SayclubContact( Kopete::Account *account, const QString &uniqueName, Kopete::MetaContact *parent );
	~SayclubContact();
	
	bool isDeleted() const;
	void setDeleted( bool d );
	
	virtual bool isReachable();
	virtual void serialize(QMap<QString, QString>& serializedData, QMap<QString, QString>& addressBookData);
	virtual QPtrList<KAction> *customContextMenuActions();
	
	virtual Kopete::ChatSession *manager( CanCreateFlags canCreate = CannotCreate );
	
public slots:
	void sendMessage( Kopete::Message &message, Kopete::ChatSession *session );
	
protected slots:
	void showContactSettings();
	void slotChatSessionDestroyed();
	
protected:
	Kopete::ChatSession *m_session;
	KActionCollection *m_actionCollection;
	SayclubAccount *m_account;
	KAction *m_actionPrefs;
	
private:
	bool m_deleted;
};

#endif
