/*
 * DO NOT EDIT THIS FILE - it is generated by Glade.
 */

#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif
#include <stdio.h>
#include <string.h>
#include <libgen.h>
#include <sys/vfs.h>
#include <sys/stat.h>
#include <sys/types.h>

#include <gdk/gdkkeysyms.h>
#include <gtk/gtk.h>

#include "callbacks.h"
#include "interface.h"
#include "support.h"

#define GLADE_HOOKUP_OBJECT(component,widget,name) \
  g_object_set_data_full (G_OBJECT (component), name, \
    gtk_widget_ref (widget), (GDestroyNotify) gtk_widget_unref)

#define GLADE_HOOKUP_OBJECT_NO_REF(component,widget,name) \
  g_object_set_data (G_OBJECT (component), name, widget)



const char *MMOUNT = "/proc/mounts";
static float percent;
static int ptimer = 0;
int pstat = TRUE;
extern GtkWidget *wnddf;

// usb //
struct f_size
{
    long blocks;
    long avail; 
};

typedef struct
{
	char dev_name[80];
	char mountdir[80];
	long blocks;
	long avail;
	long used;
} MYUSB;

MYUSB my_usb;

typedef struct _mountinfo 
{
    FILE *fp;                // 파일 스트림 포인터    
    char devname[80];        // 장치 이름
    char mountdir[80];        // 마운트 디렉토리 이름
    char fstype[12];        // 파일 시스템 타입
    struct f_size size;        // 파일 시스템의 총크기/사용율 
} MOUNTP;

MOUNTP *dfopen()
{
    MOUNTP *MP;

    // /proc/mounts 파일을 연다.
    MP = (MOUNTP *)malloc(sizeof(MOUNTP));
    if(!(MP->fp = fopen(MMOUNT, "r")))
    {
        return NULL;
    }
    else
        return MP;
}

MOUNTP *dfget(MOUNTP *MP)
{
    char buf[256];
    char *bname;
    char null[16];
    struct statfs lstatfs;
    struct stat lstat; 
    int is_root = 0;

    // /proc/mounts로 부터 마운트된 파티션의 정보를 얻어온다.
    while(fgets(buf, 255, MP->fp))
    {

        sscanf(buf, "%s%s%s",MP->devname, MP->mountdir, MP->fstype);
                // 파일시스템의 총 할당된 크기와 사용량을 구한다.        
                statfs(MP->mountdir, &lstatfs);
                MP->size.blocks = lstatfs.f_blocks * (lstatfs.f_bsize/1024); 
                MP->size.avail  = lstatfs.f_bavail * (lstatfs.f_bsize/1024); 
                return MP;

    }
    rewind(MP->fp);
    return NULL;
}



int dfclose(MOUNTP *MP)
{
    fclose(MP->fp);
}

// usb useage & blocks //
int usb_dev ()
{
	MOUNTP *MP;
    if ((MP=dfopen()) == NULL)
    {
        perror("error");
        return 1;
    }
     	
        while(dfget(MP))
        {
			if (strcmp(MP->mountdir,"/mnt/usb")==0)				
				
			{
                
				my_usb.blocks = MP->size.blocks;
				my_usb.avail = MP->size.avail;
				my_usb.used = MP->size.blocks - MP->size.avail;
				

                printf("%-14s%-20s%10lu%10lu\n", MP->mountdir, MP->devname, 
                                MP->size.blocks,
                                MP->size.avail);

			}
		
		}
	
	return 0;
	
}


gboolean Drawrect1(GtkWidget *Area) {
  GdkColor Color;
  GdkColormap *ColorMap;
  GdkGC *Gc;

  ColorMap = gdk_window_get_colormap(Area->window);

  Gc = gdk_gc_new(Area->window);
  Color.red = 18176;
  Color.green = 15616;
  Color.blue = 52992;
  gdk_color_alloc(ColorMap, &Color);
  gdk_gc_set_foreground(Gc, &Color);
  gdk_gc_set_line_attributes(Gc, 1, GDK_LINE_SOLID, GDK_CAP_BUTT, GDK_JOIN_MITER);
  gdk_draw_rectangle(Area->window, Gc, TRUE, 10, 10, 30, 30);
  gdk_gc_destroy(Gc);

  return TRUE;
}

/* Rose rectangle for free space */
gboolean Drawrect2(GtkWidget *Area) {
  GdkColor Color;
  GdkColormap *ColorMap;
  GdkGC *Gc;

  ColorMap = gdk_window_get_colormap(Area->window);

  Gc = gdk_gc_new(Area->window);
  Color.red = 61440;
  Color.green = 7168;
  Color.blue = 61440;
  gdk_color_alloc(ColorMap, &Color);
  gdk_gc_set_foreground(Gc, &Color);
  gdk_draw_rectangle(Area->window, Gc, TRUE, 10, 10, 30, 30);
  gdk_gc_destroy(Gc);

  return TRUE;
}
gboolean Drawarc(GtkWidget *Area) {
  GdkColor Color;
  GdkColormap *ColorMap;
  GdkGC *Gc;
  
  float reste;

  percent = (my_usb.used*100.0) / (my_usb.used + my_usb.avail);
  reste = 100 - percent;

  ColorMap = gdk_window_get_colormap(Area->window);

  Gc = gdk_gc_new(Area->window);
  Color.red = 18176;
  Color.green = 15616;
  Color.blue = 52992;
  gdk_color_alloc(ColorMap, &Color);
  gdk_gc_set_foreground(Gc, &Color);
  gdk_gc_set_line_attributes(Gc, 1, GDK_LINE_SOLID, GDK_CAP_BUTT, GDK_JOIN_MITER);
  gdk_draw_arc(Area->window, Gc, TRUE, 10,10 , 130, 50, 0, 64*3.6*percent);
  gdk_gc_destroy(Gc);

  Gc = gdk_gc_new(Area->window);
  Color.red = 61440;
  Color.green = 7168;
  Color.blue = 61440;
  gdk_color_alloc(ColorMap, &Color);
  gdk_gc_set_foreground(Gc, &Color);
  gdk_draw_arc(Area->window, Gc, TRUE, 10, 10, 130, 50, 64*3.6*percent, 64*3.6*reste);
  gdk_gc_destroy(Gc);

  
  gdk_gc_set_line_attributes(Gc, 1, GDK_LINE_SOLID, GDK_CAP_BUTT, GDK_JOIN_MITER);
  gdk_draw_arc(Area->window, Gc, FALSE, 0, 0, 130, 150, 0, 64*3.6*percent);
  gdk_draw_arc(Area->window, Gc, FALSE, 0, 0, 130, 150, 64*3.6*percent, 64*3.6*reste);

  gdk_gc_destroy(Gc);

  return TRUE;
}

gint progress (gpointer data)
{
	gfloat pvalue;
	
	
	pstat = TRUE;
	
	
	pvalue = (percent/100);
	gtk_progress_bar_update (GTK_PROGRESS_BAR (data), pvalue);
	return TRUE;
}
gint progress_destroy(gpointer data)
{
	gtk_timeout_remove (ptimer);
        my_usb.blocks = 0;
	my_usb.avail = 0;
	my_usb.used = 0;
}


GtkWidget*
create_UM_main (void)
{
  GtkWidget *UM_main;
  GdkPixbuf *UM_main_icon_pixbuf;
  GtkWidget *dialog_vbox1;
  GtkWidget *notebook1;
  GtkWidget *hbox3;
  GtkWidget *frame6;
  GtkWidget *vbox7;
  GtkWidget *label16;
  GtkWidget *hbox4;
  GtkWidget *label17;
  GtkWidget *hbox5;
  GtkWidget *drawingarea2;
  GtkWidget *label18;
  GtkWidget *hbox6;
  GtkWidget *drawingarea3;
  GtkWidget *label19;
  GtkWidget *label12;
  GtkWidget *vbox2;
  GtkWidget *frame7;
  GtkWidget *vbox3;
  GtkWidget *vbox4;
  GtkWidget *label14;
  GtkWidget *drawingarea1;
  GtkWidget *vbox5;
  GtkWidget *label15;
  GtkWidget *vbox6;
  GtkWidget *progressbar1;
  GtkWidget *label13;
  GtkWidget *label1;
  GtkWidget *vbox1;
  GtkWidget *frame1;
  GtkWidget *hbox1;
  GtkWidget *table1;
  GtkWidget *image1;
  GtkWidget *label7;
  GtkWidget *button1;
  GtkWidget *label4;
  GtkWidget *frame2;
  GtkWidget *hbox2;
  GtkWidget *table2;
  GtkWidget *image2;
  GtkWidget *label8;
  GtkWidget *button2;
  GtkWidget *label5;
  GtkWidget *frame3;
  GtkWidget *table3;
  GtkWidget *image3;
  GtkWidget *label9;
  GtkWidget *button3;
  GtkWidget *label6;
  GtkWidget *label2;
  GtkWidget *scrolledwindow1;
  GtkWidget *textview1;
  GtkWidget *label3;
  GtkWidget *dialog_action_area1;
  GtkWidget *okbutton1;
  GtkWidget *Alig;
  char buffer[32];
  char buffer1[32];
  char buffer2[32];
  float tmp;
  
  usb_dev();
  
  UM_main = gtk_dialog_new ();
  gtk_widget_set_name (UM_main, "UM_main");
  gtk_widget_set_size_request (UM_main, 373, 387);
  gtk_window_set_title (GTK_WINDOW (UM_main), _("USB-MANAGER"));
  gtk_window_set_position (GTK_WINDOW (UM_main), GTK_WIN_POS_CENTER);
  gtk_window_set_resizable (GTK_WINDOW (UM_main), FALSE);
  gtk_window_set_destroy_with_parent (GTK_WINDOW (UM_main), TRUE);
  UM_main_icon_pixbuf = create_pixbuf ("../pixmaps/usb.png");
  if (UM_main_icon_pixbuf)
    {
      gtk_window_set_icon (GTK_WINDOW (UM_main), UM_main_icon_pixbuf);
      gdk_pixbuf_unref (UM_main_icon_pixbuf);
    }

  dialog_vbox1 = GTK_DIALOG (UM_main)->vbox;
  gtk_widget_set_name (dialog_vbox1, "dialog_vbox1");
  gtk_widget_show (dialog_vbox1);
  
  gtk_signal_connect(GTK_OBJECT(UM_main), "destroy", GTK_SIGNAL_FUNC(gtk_widget_destroyed), &UM_main);
  gtk_signal_connect(GTK_OBJECT(UM_main), "delete_event", (GtkSignalFunc)gtk_widget_destroy, NULL);

  notebook1 = gtk_notebook_new ();
  gtk_widget_set_name (notebook1, "notebook1");
  gtk_widget_show (notebook1);
  gtk_box_pack_start (GTK_BOX (dialog_vbox1), notebook1, TRUE, TRUE, 0);

  hbox3 = gtk_hbox_new (FALSE, 0);
  gtk_widget_set_name (hbox3, "hbox3");
  gtk_widget_show (hbox3);
  gtk_container_add (GTK_CONTAINER (notebook1), hbox3);

  frame6 = gtk_frame_new (NULL);
  gtk_widget_set_name (frame6, "frame6");
  gtk_widget_show (frame6);
  gtk_box_pack_start (GTK_BOX (hbox3), frame6, TRUE, TRUE, 0);

  vbox7 = gtk_vbox_new (FALSE, 0);
  gtk_widget_set_name (vbox7, "vbox7");
  gtk_widget_show (vbox7);
  gtk_container_add (GTK_CONTAINER (frame6), vbox7);

  label16 = gtk_label_new (_("\354\234\204\354\271\230 : /mnt/usb"));
  gtk_widget_set_name (label16, "label16");
  gtk_widget_show (label16);
  gtk_box_pack_start (GTK_BOX (vbox7), label16, FALSE, FALSE, 15);
  gtk_label_set_justify (GTK_LABEL (label16), GTK_JUSTIFY_LEFT);

  hbox4 = gtk_hbox_new (FALSE, 0);
  gtk_widget_set_name (hbox4, "hbox4");
  gtk_widget_show (hbox4);
  gtk_box_pack_start (GTK_BOX (vbox7), hbox4, TRUE, TRUE, 0);
  
  //total label //
  
  if ((tmp = my_usb.blocks / 1024) >= 1000)
    sprintf(buffer, "   Total : %.1f G", tmp / 1024);
  else
    sprintf(buffer, "   Total : %.f M", tmp);
  
  label17 = gtk_label_new (buffer);
  //gtk_widget_set_name (label17, " total : ");
  gtk_widget_show (label17);
  gtk_box_pack_start (GTK_BOX (hbox4), label17, FALSE, FALSE, 0);
  gtk_label_set_justify (GTK_LABEL (label17), GTK_JUSTIFY_LEFT);
  
  hbox5 = gtk_hbox_new (FALSE, 0);
  gtk_widget_set_name (hbox5, "hbox5");
  gtk_widget_show (hbox5);
  gtk_box_pack_start (GTK_BOX (vbox7), hbox5, TRUE, TRUE, 0);
  
  // blue box //
  drawingarea2 = gtk_drawing_area_new ();
  gtk_widget_set_name (drawingarea2, "drawingarea2");
  gtk_drawing_area_size(GTK_DRAWING_AREA(drawingarea2), 30, 30);
  gtk_signal_connect(GTK_OBJECT(drawingarea2), "expose-event", (GtkSignalFunc)Drawrect1, NULL);
  gtk_widget_show (drawingarea2);
  gtk_box_pack_start (GTK_BOX (hbox5), drawingarea2, FALSE, TRUE, 0);
  
  //use label // 
  if ((tmp = (my_usb.blocks-my_usb.avail) / 1024) >= 1000)
    sprintf(buffer1, "   Use : %.1f G", tmp / 1024);
  else
    sprintf(buffer1, "   Use : %.f M", tmp);
  label18 = gtk_label_new (buffer1);
  //gtk_widget_set_name (label18, "label18");
  gtk_widget_show (label18);
  gtk_box_pack_start (GTK_BOX (hbox5), label18, FALSE, FALSE, 0);
  gtk_label_set_justify (GTK_LABEL (label18), GTK_JUSTIFY_LEFT);

  hbox6 = gtk_hbox_new (FALSE, 0);
  gtk_widget_set_name (hbox6, "hbox6");
  gtk_widget_show (hbox6);
  gtk_box_pack_start (GTK_BOX (vbox7), hbox6, TRUE, TRUE, 0);
  
  // red box // 
  drawingarea3 = gtk_drawing_area_new ();
  gtk_widget_set_name (drawingarea3, "drawingarea3");
  gtk_drawing_area_size(GTK_DRAWING_AREA(drawingarea3), 30, 30);
  gtk_signal_connect(GTK_OBJECT(drawingarea3), "expose-event", (GtkSignalFunc)Drawrect2, NULL);
  gtk_widget_show (drawingarea3);
  gtk_box_pack_start (GTK_BOX (hbox6), drawingarea3, FALSE, TRUE, 0);
  
  // free label //
   if ((tmp = my_usb.avail / 1024) >= 1000)
    sprintf(buffer2, "   Free : %.1f G", tmp / 1024);
  else
    sprintf(buffer2, "   Free : %.f M", tmp);
  label19 = gtk_label_new (buffer2);
  //gtk_widget_set_name (label19, "label19");
  gtk_widget_show (label19);
  gtk_box_pack_start (GTK_BOX (hbox6), label19, FALSE, FALSE, 0);
  gtk_label_set_justify (GTK_LABEL (label19), GTK_JUSTIFY_LEFT);

  label12 = gtk_label_new (_("\353\224\224\354\212\244\355\201\254\354\240\225\353\263\264"));
  gtk_widget_set_name (label12, "label12");
  gtk_widget_show (label12);
  gtk_frame_set_label_widget (GTK_FRAME (frame6), label12);
  gtk_label_set_justify (GTK_LABEL (label12), GTK_JUSTIFY_LEFT);

  vbox2 = gtk_vbox_new (FALSE, 0);
  gtk_widget_set_name (vbox2, "vbox2");
  gtk_widget_show (vbox2);
  gtk_box_pack_start (GTK_BOX (hbox3), vbox2, TRUE, TRUE, 0);

  frame7 = gtk_frame_new (NULL);
  gtk_widget_set_name (frame7, "frame7");
  gtk_widget_show (frame7);
  gtk_box_pack_start (GTK_BOX (vbox2), frame7, TRUE, TRUE, 0);

  vbox3 = gtk_vbox_new (FALSE, 0);
  gtk_widget_set_name (vbox3, "vbox3");
  gtk_widget_show (vbox3);
  gtk_container_add (GTK_CONTAINER (frame7), vbox3);

  vbox4 = gtk_vbox_new (FALSE, 0);
  gtk_widget_set_name (vbox4, "vbox4");
  gtk_widget_show (vbox4);
  gtk_box_pack_start (GTK_BOX (vbox3), vbox4, TRUE, TRUE, 0);

  label14 = gtk_label_new (_("\354\233\220\355\230\225\n"));
  gtk_widget_set_name (label14, "label14");
  gtk_widget_show (label14);
  gtk_box_pack_start (GTK_BOX (vbox4), label14, FALSE, FALSE, 0);
  gtk_label_set_justify (GTK_LABEL (label14), GTK_JUSTIFY_LEFT);
  
  // total drawing box// 
  drawingarea1 = gtk_drawing_area_new ();
  gtk_widget_set_name (drawingarea1, "drawingarea1");
  gtk_drawing_area_size(GTK_DRAWING_AREA(drawingarea1), 90, 51);
  gtk_signal_connect(GTK_OBJECT(drawingarea1), "expose-event", (GtkSignalFunc)Drawarc, NULL);
  gtk_widget_show (drawingarea1);
  gtk_box_pack_start (GTK_BOX (vbox4), drawingarea1, TRUE, TRUE, 0);

  vbox5 = gtk_vbox_new (FALSE, 0);
  gtk_widget_set_name (vbox5, "vbox5");
  gtk_widget_show (vbox5);
  gtk_box_pack_start (GTK_BOX (vbox3), vbox5, TRUE, TRUE, 0);

  label15 = gtk_label_new (_("\353\247\211\353\214\200"));
  gtk_widget_set_name (label15, "label15");
  gtk_widget_show (label15);
  gtk_box_pack_start (GTK_BOX (vbox5), label15, FALSE, FALSE, 0);
  gtk_label_set_justify (GTK_LABEL (label15), GTK_JUSTIFY_LEFT);

  vbox6 = gtk_vbox_new (FALSE, 0);
  gtk_widget_set_name (vbox6, "vbox6");
  gtk_widget_show (vbox6);
  gtk_box_pack_start (GTK_BOX (vbox5), vbox6, TRUE, TRUE, 0);
  
  //progress create//
  
  progressbar1 = gtk_progress_bar_new ();
  gtk_widget_set_name (progressbar1, "progressbar1");
  ptimer = gtk_timeout_add (100, progress, progressbar1);
  gtk_widget_show (progressbar1);
  gtk_box_pack_start (GTK_BOX (vbox6), progressbar1, TRUE, FALSE, 7);
  //gtk_widget_set_size_request (progressbar1, 86, 20);
  gtk_progress_bar_set_text (GTK_PROGRESS_BAR (progressbar1), _("%p%%"));

  label13 = gtk_label_new (_("\352\267\270\353\236\230\355\224\204"));
  gtk_widget_set_name (label13, "label13");
  gtk_widget_show (label13);
  gtk_frame_set_label_widget (GTK_FRAME (frame7), label13);
  gtk_label_set_justify (GTK_LABEL (label13), GTK_JUSTIFY_LEFT);

  label1 = gtk_label_new (_("\354\235\274\353\260\230"));
  gtk_widget_set_name (label1, "label1");
  gtk_widget_show (label1);
  gtk_notebook_set_tab_label (GTK_NOTEBOOK (notebook1), gtk_notebook_get_nth_page (GTK_NOTEBOOK (notebook1), 0), label1);
  gtk_label_set_justify (GTK_LABEL (label1), GTK_JUSTIFY_LEFT);

  vbox1 = gtk_vbox_new (FALSE, 0);
  gtk_widget_set_name (vbox1, "vbox1");
  gtk_widget_show (vbox1);
  gtk_container_add (GTK_CONTAINER (notebook1), vbox1);

  frame1 = gtk_frame_new (NULL);
  gtk_widget_set_name (frame1, "frame1");
  gtk_widget_show (frame1);
  gtk_box_pack_start (GTK_BOX (vbox1), frame1, FALSE, FALSE, 0);

  hbox1 = gtk_hbox_new (FALSE, 0);
  gtk_widget_set_name (hbox1, "hbox1");
  gtk_widget_show (hbox1);
  gtk_container_add (GTK_CONTAINER (frame1), hbox1);

  table1 = gtk_table_new (2, 3, FALSE);
  gtk_widget_set_name (table1, "table1");
  gtk_widget_show (table1);
  gtk_box_pack_start (GTK_BOX (hbox1), table1, TRUE, TRUE, 0);

  image1 = gtk_image_new_from_stock ("gtk-add", GTK_ICON_SIZE_DND);
  gtk_widget_set_name (image1, "image1");
  gtk_widget_show (image1);
  gtk_table_attach (GTK_TABLE (table1), image1, 0, 1, 0, 1,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (GTK_FILL), 0, 0);

  label7 = gtk_label_new (_("usb \354\240\200\354\236\245\354\236\245\354\271\230\353\245\274 \354\227\260\352\262\260\355\225\251\353\213\210\353\213\244."));
  gtk_widget_set_name (label7, "label7");
  gtk_widget_show (label7);
  gtk_table_attach (GTK_TABLE (table1), label7, 1, 2, 0, 1,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_label_set_justify (GTK_LABEL (label7), GTK_JUSTIFY_LEFT);
  gtk_misc_set_alignment (GTK_MISC (label7), 0, 0.5);

  button1 = gtk_button_new_with_mnemonic (_("\353\247\210\354\232\264\355\212\270"));
  gtk_widget_set_name (button1, "button1");
  gtk_widget_show (button1);
  gtk_table_attach (GTK_TABLE (table1), button1, 2, 3, 1, 2,
                    (GtkAttachOptions) (0),
                    (GtkAttachOptions) (0), 54, 4);
  gtk_widget_set_size_request (button1, 60, 34);

  label4 = gtk_label_new (_("\353\247\210\354\232\264\355\212\270 "));
  gtk_widget_set_name (label4, "label4");
  gtk_widget_show (label4);
  gtk_frame_set_label_widget (GTK_FRAME (frame1), label4);
  gtk_label_set_justify (GTK_LABEL (label4), GTK_JUSTIFY_LEFT);

  frame2 = gtk_frame_new (NULL);
  gtk_widget_set_name (frame2, "frame2");
  gtk_widget_show (frame2);
  gtk_box_pack_start (GTK_BOX (vbox1), frame2, FALSE, FALSE, 0);
  gtk_widget_set_size_request (frame2, 463, -2);

  hbox2 = gtk_hbox_new (FALSE, 0);
  gtk_widget_set_name (hbox2, "hbox2");
  gtk_widget_show (hbox2);
  gtk_container_add (GTK_CONTAINER (frame2), hbox2);

  table2 = gtk_table_new (2, 3, FALSE);
  gtk_widget_set_name (table2, "table2");
  gtk_widget_show (table2);
  gtk_box_pack_start (GTK_BOX (hbox2), table2, TRUE, TRUE, 0);

  image2 = gtk_image_new_from_stock ("gtk-close", GTK_ICON_SIZE_DND);
  gtk_widget_set_name (image2, "image2");
  gtk_widget_show (image2);
  gtk_table_attach (GTK_TABLE (table2), image2, 0, 1, 0, 1,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (GTK_FILL), 0, 0);

  label8 = gtk_label_new (_("usb \354\240\200\354\236\245\354\236\245\354\271\230 \354\227\260\352\262\260\354\235\204 \355\225\264\354\240\234 \355\225\251\353\213\210\353\213\244."));
  gtk_widget_set_name (label8, "label8");
  gtk_widget_show (label8);
  gtk_table_attach (GTK_TABLE (table2), label8, 1, 2, 0, 1,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_label_set_justify (GTK_LABEL (label8), GTK_JUSTIFY_LEFT);
  gtk_misc_set_alignment (GTK_MISC (label8), 0, 0.5);

  button2 = gtk_button_new_with_mnemonic (_("\354\226\270 \353\247\210\354\232\264\355\212\270"));
  gtk_widget_set_name (button2, "button2");
  gtk_widget_show (button2);
  gtk_table_attach (GTK_TABLE (table2), button2, 2, 3, 1, 2,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 20, 4);
  gtk_widget_set_size_request (button2, 60, 34);

  label5 = gtk_label_new (_("\354\226\270\353\247\210\354\232\264\355\212\270"));
  gtk_widget_set_name (label5, "label5");
  gtk_widget_show (label5);
  gtk_frame_set_label_widget (GTK_FRAME (frame2), label5);
  gtk_label_set_justify (GTK_LABEL (label5), GTK_JUSTIFY_LEFT);

  frame3 = gtk_frame_new (NULL);
  gtk_widget_set_name (frame3, "frame3");
  gtk_widget_show (frame3);
  gtk_box_pack_start (GTK_BOX (vbox1), frame3, FALSE, FALSE, 0);

  table3 = gtk_table_new (2, 3, FALSE);
  gtk_widget_set_name (table3, "table3");
  gtk_widget_show (table3);
  gtk_container_add (GTK_CONTAINER (frame3), table3);

  image3 = gtk_image_new_from_stock ("gtk-dialog-warning", GTK_ICON_SIZE_DND);
  gtk_widget_set_name (image3, "image3");
  gtk_widget_show (image3);
  gtk_table_attach (GTK_TABLE (table3), image3, 0, 1, 0, 1,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (GTK_FILL), 0, 0);

  label9 = gtk_label_new (_("\354\240\200\354\236\245 \354\236\245\354\271\230\354\235\230 \353\202\264\354\232\251\354\235\204 \354\240\204\353\266\200 \354\247\200\354\233\201\353\213\210\353\213\244."));
  gtk_widget_set_name (label9, "label9");
  gtk_widget_show (label9);
  gtk_table_attach (GTK_TABLE (table3), label9, 1, 2, 0, 1,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_label_set_justify (GTK_LABEL (label9), GTK_JUSTIFY_LEFT);
  gtk_misc_set_alignment (GTK_MISC (label9), 0, 0.5);

  button3 = gtk_button_new_with_mnemonic (_("\355\217\264\353\215\224\n\354\247\200\354\232\260\352\270\260"));
  gtk_widget_set_name (button3, "button3");
  gtk_widget_show (button3);
  gtk_table_attach (GTK_TABLE (table3), button3, 2, 3, 1, 2,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 18, 4);
  gtk_widget_set_size_request (button3, 60, 34);

  label6 = gtk_label_new (_("\355\217\264\353\215\224 \354\247\200\354\232\260\352\270\260"));
  gtk_widget_set_name (label6, "label6");
  gtk_widget_show (label6);
  gtk_frame_set_label_widget (GTK_FRAME (frame3), label6);
  gtk_label_set_justify (GTK_LABEL (label6), GTK_JUSTIFY_LEFT);

  label2 = gtk_label_new (_("\353\217\204\352\265\254"));
  gtk_widget_set_name (label2, "label2");
  gtk_widget_show (label2);
  gtk_notebook_set_tab_label (GTK_NOTEBOOK (notebook1), gtk_notebook_get_nth_page (GTK_NOTEBOOK (notebook1), 1), label2);
  gtk_label_set_justify (GTK_LABEL (label2), GTK_JUSTIFY_LEFT);

  scrolledwindow1 = gtk_scrolled_window_new (NULL, NULL);
  gtk_widget_set_name (scrolledwindow1, "scrolledwindow1");
  gtk_widget_show (scrolledwindow1);
  gtk_container_add (GTK_CONTAINER (notebook1), scrolledwindow1);

  textview1 = gtk_text_view_new ();
  gtk_widget_set_name (textview1, "textview1");
  gtk_widget_show (textview1);
  gtk_container_add (GTK_CONTAINER (scrolledwindow1), textview1);
  gtk_text_view_set_editable (GTK_TEXT_VIEW (textview1), FALSE);
  gtk_text_view_set_cursor_visible (GTK_TEXT_VIEW (textview1), FALSE);
  gtk_text_buffer_set_text (gtk_text_view_get_buffer (GTK_TEXT_VIEW (textview1)),
   _("\n\n\353\263\270 \355\224\204\353\241\234\352\267\270\353\236\250\354\235\200 \352\264\221\354\243\274 \354\240\225\353\263\264\353\254\270\355\231\224 \354\202\260\354\227\205\354\262\264 \352\263\265\352\260\234 S/W\354\235\270\353\240\245 \n\354\226\221\354\204\261 \354\202\254\354\227\205\354\234\274\353\241\234\354\215\250 GUI\352\270\260\353\260\230\354\235\230 \354\231\270\354\236\245\355\230\225 H/W\354\204\244\353\262\231 \353\260\217 \352\264\200\353\246\254 \n\354\227\220\354\235\264\354\240\204\355\212\270 \355\224\204\353\241\234\354\240\235\355\212\270 \352\270\260\353\260\230\354\234\274\353\241\234 \352\260\234\353\260\234\353\220\230\354\227\210\354\212\265\353\213\210\353\213\244. \n\353\263\270 \355\224\204\353\241\234\352\267\270\353\236\250\354\235\200 GPL\354\227\220 \353\224\260\353\245\264\353\251\260 \354\206\214\354\212\244\353\212\224 \352\263\265\352\260\234\353\245\274 \354\233\220\354\271\231\354\234\274\353\241\234 \355\225\251\353\213\210\353\213\244. \n\n\355\224\204\353\241\234\352\267\270\353\236\250 \352\260\234\353\260\234 : \352\264\221\354\243\274\353\214\200\355\225\231\352\265\220 \352\263\240\354\206\215\355\206\265\354\213\240\353\247\235 \354\213\244\355\227\230\354\213\244 \354\235\270\354\233\220 \n                  \354\231\270 \354\264\235 10\353\252\205 \n\354\260\270\354\227\254 \354\227\205\354\262\264 : \355\230\204\353\204\244\355\212\270\354\233\214\355\201\254 (\354\243\274) \353\251\224\353\213\210\354\240\200\353\250\274\355\212\270 \353\245\230\353\217\231\354\243\274 \n\355\231\210\355\216\230\354\235\264\354\247\200 : http://hsn.gwangju.ac.kr\n\353\213\244\354\232\264\353\241\234\353\223\234 : http://hsn.gwangju.ac.kr\n "), -1);                                                                                                                                                             

  label3 = gtk_label_new (_("\354\240\225\353\263\264"));
  gtk_widget_set_name (label3, "label3");
  gtk_widget_show (label3);
  gtk_notebook_set_tab_label (GTK_NOTEBOOK (notebook1), gtk_notebook_get_nth_page (GTK_NOTEBOOK (notebook1), 2), label3);
  gtk_label_set_justify (GTK_LABEL (label3), GTK_JUSTIFY_LEFT);

  dialog_action_area1 = GTK_DIALOG (UM_main)->action_area;
  gtk_widget_set_name (dialog_action_area1, "dialog_action_area1");
  gtk_widget_show (dialog_action_area1);
  gtk_button_box_set_layout (GTK_BUTTON_BOX (dialog_action_area1), GTK_BUTTONBOX_END);

  okbutton1 = gtk_button_new_from_stock ("gtk-ok");
  gtk_widget_set_name (okbutton1, "okbutton1");
  gtk_widget_show (okbutton1);
  gtk_dialog_add_action_widget (GTK_DIALOG (UM_main), okbutton1, GTK_RESPONSE_OK);
   GTK_WIDGET_SET_FLAGS (okbutton1, GTK_CAN_DEFAULT);

   
   gtk_signal_connect(GTK_OBJECT(okbutton1), "clicked", GTK_SIGNAL_FUNC (progress_destroy),NULL);
   gtk_signal_connect_object(GTK_OBJECT(okbutton1), "clicked", (GtkSignalFunc)gtk_widget_destroy,GTK_OBJECT(UM_main));
  /* Store pointers to all widgets, for use by lookup_widget(). */
  GLADE_HOOKUP_OBJECT_NO_REF (UM_main, UM_main, "UM_main");
  GLADE_HOOKUP_OBJECT_NO_REF (UM_main, dialog_vbox1, "dialog_vbox1");
  GLADE_HOOKUP_OBJECT (UM_main, notebook1, "notebook1");
  GLADE_HOOKUP_OBJECT (UM_main, hbox3, "hbox3");
  GLADE_HOOKUP_OBJECT (UM_main, frame6, "frame6");
  GLADE_HOOKUP_OBJECT (UM_main, vbox7, "vbox7");
  GLADE_HOOKUP_OBJECT (UM_main, label16, "label16");
  GLADE_HOOKUP_OBJECT (UM_main, hbox4, "hbox4");
  GLADE_HOOKUP_OBJECT (UM_main, label17, "label17");
  GLADE_HOOKUP_OBJECT (UM_main, hbox5, "hbox5");
  GLADE_HOOKUP_OBJECT (UM_main, drawingarea2, "drawingarea2");
  GLADE_HOOKUP_OBJECT (UM_main, label18, "label18");
  GLADE_HOOKUP_OBJECT (UM_main, hbox6, "hbox6");
  GLADE_HOOKUP_OBJECT (UM_main, drawingarea3, "drawingarea3");
  GLADE_HOOKUP_OBJECT (UM_main, label19, "label19");
  GLADE_HOOKUP_OBJECT (UM_main, label12, "label12");
  GLADE_HOOKUP_OBJECT (UM_main, vbox2, "vbox2");
  GLADE_HOOKUP_OBJECT (UM_main, frame7, "frame7");
  GLADE_HOOKUP_OBJECT (UM_main, vbox3, "vbox3");
  GLADE_HOOKUP_OBJECT (UM_main, vbox4, "vbox4");
  GLADE_HOOKUP_OBJECT (UM_main, label14, "label14");
  GLADE_HOOKUP_OBJECT (UM_main, drawingarea1, "drawingarea1");
  GLADE_HOOKUP_OBJECT (UM_main, vbox5, "vbox5");
  GLADE_HOOKUP_OBJECT (UM_main, label15, "label15");
  GLADE_HOOKUP_OBJECT (UM_main, vbox6, "vbox6");
  GLADE_HOOKUP_OBJECT (UM_main, progressbar1, "progressbar1");
  GLADE_HOOKUP_OBJECT (UM_main, label13, "label13");
  GLADE_HOOKUP_OBJECT (UM_main, label1, "label1");
  GLADE_HOOKUP_OBJECT (UM_main, vbox1, "vbox1");
  GLADE_HOOKUP_OBJECT (UM_main, frame1, "frame1");
  GLADE_HOOKUP_OBJECT (UM_main, hbox1, "hbox1");
  GLADE_HOOKUP_OBJECT (UM_main, table1, "table1");
  GLADE_HOOKUP_OBJECT (UM_main, image1, "image1");
  GLADE_HOOKUP_OBJECT (UM_main, label7, "label7");
  GLADE_HOOKUP_OBJECT (UM_main, button1, "button1");
  GLADE_HOOKUP_OBJECT (UM_main, label4, "label4");
  GLADE_HOOKUP_OBJECT (UM_main, frame2, "frame2");
  GLADE_HOOKUP_OBJECT (UM_main, hbox2, "hbox2");
  GLADE_HOOKUP_OBJECT (UM_main, table2, "table2");
  GLADE_HOOKUP_OBJECT (UM_main, image2, "image2");
  GLADE_HOOKUP_OBJECT (UM_main, label8, "label8");
  GLADE_HOOKUP_OBJECT (UM_main, button2, "button2");
  GLADE_HOOKUP_OBJECT (UM_main, label5, "label5");
  GLADE_HOOKUP_OBJECT (UM_main, frame3, "frame3");
  GLADE_HOOKUP_OBJECT (UM_main, table3, "table3");
  GLADE_HOOKUP_OBJECT (UM_main, image3, "image3");
  GLADE_HOOKUP_OBJECT (UM_main, label9, "label9");
  GLADE_HOOKUP_OBJECT (UM_main, button3, "button3");
  GLADE_HOOKUP_OBJECT (UM_main, label6, "label6");
  GLADE_HOOKUP_OBJECT (UM_main, label2, "label2");
  GLADE_HOOKUP_OBJECT (UM_main, scrolledwindow1, "scrolledwindow1");
  GLADE_HOOKUP_OBJECT (UM_main, textview1, "textview1");
  GLADE_HOOKUP_OBJECT (UM_main, label3, "label3");
  GLADE_HOOKUP_OBJECT_NO_REF (UM_main, dialog_action_area1, "dialog_action_area1");
  GLADE_HOOKUP_OBJECT (UM_main, okbutton1, "okbutton1");

  return UM_main;
}
