<?php
/**
 * 위치별 플러그인 설정 스크립트
 *
 * 본 스크립트는 articles 플러그인의 설정 스크립트(또는 복사된)이다.
 * 본 스크립트는 설정의 작업 처리를 위한 표준적인 방법을 제시한다. 따라서 설정 스크립트를 작성할 때에는
 * 본 스크릡트를 참조하는 것이 도움이 될 것이다.
 *
 * 현제 위치에 해당하는 현제 플러그인의 설정을 한다.
 * HTML FORM 을 submit 하면 config_submit.php 에 의해서 설정 내용이 저장이될 것이다.
 * 대부분의 경우 config_submit.php 는 변경을 하지 않아도된다.
 * config.php 에서만 수정을 하고 사용하면된다.
 *
 *
 */
//
/**
 * 라이브러리 로드
 ******************************/

lib('plugin');


/**
 * 플러그인 정보
 ******************************/

$pd = dirRoot."/plugin/$ui[dir]";
include $pd."/info.php";
$cfg = config(cfgfile());





/**
 * 초기값 체크
 ******************************/
if ( !isset($cfg['header'])  ) $cfg['header'] = NULL;
if ( !isset($cfg['v1'])  ) $cfg['v1'] = NULL;
if ( !isset($cfg['v2'])  ) $cfg['v2'] = NULL;
if ( !isset($cfg['v3'])  ) $cfg['v3'] = NULL;
if ( !isset($cfg['v4'])  ) $cfg['v4'] = NULL;
if ( !isset($cfg['v5'])  ) $cfg['v5'] = NULL;
if ( !isset($cfg['v1color'])  ) $cfg['v1color'] = NULL;
if ( !isset($cfg['v2color'])  ) $cfg['v2color'] = NULL;
if ( !isset($cfg['v3color'])  ) $cfg['v3color'] = NULL;
if ( !isset($cfg['v4color'])  ) $cfg['v4color'] = NULL;
if ( !isset($cfg['v5color'])  ) $cfg['v5color'] = NULL;


if ( !isset($cfg['retry'])  ) $cfg['retry'] = 7;




$hide_checked = NULL;
if ( isset($cfg['hide']) && $cfg['hide'] == 'checked' ) $hide_checked = "checked";


if ( !isset($cfg['cache']) ) $cfg['cache'] = "0";





/**
 * 캐쉬 정보를 저장할 경우, 캐쉬 옵션이 0 이면, 기존의 캐쉬 파일을 여기서 지운다.
 *******************************/

if ( empty($cfg['cache']) )
{
	$cache_file = tmp_repository . "/cache/plugin.$ui[areaname].php";
	@unlink($cache_file);
}












?>

<? include "etc/res/php/plugin_config_header.php" ?>


<!------------------------------------------------//-->
<form action="?" method="post" style="display:inline;">
<input type="hidden" name="cate" value="plugin">
<input type="hidden" name="mode" value="plugin">
<input type="hidden" name="action" value="config_submit">
<input type="hidden" name="dir" value="<?=$ui['dir']?>">
<input type="hidden" name="areaname" value="<?=$ui['areaname']?>">


<table>

	<tr valign=top>
		<td width=70><div id="name">제목</div></td><td><input class="in" name="header" size=30 value="<?=$cfg['header']?>">
		<div id="comment">설문 조사 헤더(제목)을 입력하세요. 예) 본 사이트의 로딩 속도에 만족하십니까?</div>
		</td>
	</tr>

	<tr>
		<td><div id="name">문항1</div></td>
		<td>
			<input class="in" name="v1" size=20 value="<?=$cfg['v1']?>">
			색깔 <input class="in" name="v1color" size=6 value="<?=$cfg['v1color']?>">
		</td>
	</tr>
	<tr>
		<td><div id="name">문항2</div></td>
		<td>
			<input class="in" name="v2" size=20 value="<?=$cfg['v2']?>">
			색깔 <input class="in" name="v2color" size=6 value="<?=$cfg['v2color']?>">
		</td>
	</tr>
	<tr>
		<td><div id="name">문항3</div></td>
		<td>
			<input class="in" name="v3" size=20 value="<?=$cfg['v3']?>">
			색깔 <input class="in" name="v3color" size=6 value="<?=$cfg['v3color']?>">
		</td>
	</tr>
	<tr>
		<td><div id="name">문항4</div></td>
		<td>
			<input class="in" name="v4" size=20 value="<?=$cfg['v4']?>">
			색깔 <input class="in" name="v4color" size=6 value="<?=$cfg['v4color']?>">
		</td>
	</tr>
	<tr>
		<td><div id="name">문항5</div></td>
		<td>
			<input class="in" name="v5" size=20 value="<?=$cfg['v5']?>">
			색깔 <input class="in" name="v5color" size=6 value="<?=$cfg['v5color']?>">
		</td>
	</tr>

	<tr valign=top>
		<td width=70><div id="name">재시도</div></td><td><input class="in" name="retry" size=3 value="<?=$cfg['retry']?>"> 일 후 다시 투표 가능
		<div id="comment">한 번 투표 후, 다시 투표를 못하게 하려면 30일 정도 입력을 하면됩니다.</div>
		</td>
	</tr>
	
	<tr>
		<td><div id="name">숨기기</div></td><td><input class="in" type="checkbox" name="hide" value="checked" <?=$hide_checked?>> 화면에 나타내지 않기</td>
	</tr>
	
	<tr>
		<td><div id="name">스킨</div></td>
		<td>
			<select name='skin'>
			<?
				$dirs = getdirs($pd."/skin");
				foreach( $dirs as $dir )
				{
					echo "<option value='$dir'";
					if ( isset($cfg['skin']) && $cfg['skin'] == $dir ) echo " selected";
					echo ">$dir</option>";
				}
			?>
			</select>
		</td>
	</tr>

	<tr>
		<td></td><td><input class="button_blue" type="submit" value=" 적 용 [저장] "></td>
	</tr>
</table>


</form>
<!------------------eo//-->



<script>window.resizeTo(500,700);</script>








<br><div id="key">미리보기</div><div id="value">위의 저장(변경)된 내용이 아래 바로 적용이됩니다.</div><br>
<?plugin($ui['areaname'])?>



</body>
</html>

