<?php
/**
 * 사용자 로그인
 *
 * $ui[nextpage] 에 값이 있으면 그 페이지로 이동을 한다.
 */


/**
 * User has submitted wrong information.
 */
if ( empty($ui['id']) || empty($ui['password']) )
{
	goBack(wrongID, "user::login_submit you have omitted id or password.");
}


/**
 * get user's data.
 */
lib('user');
$user = userData($ui['id']);


/**
 * The id given does not exists.
 */
if ( empty($user) )
{
	goBack(wrongID, "user::login_submit");
}

/**
 * check user password.
 */
if ( ! checkPassword($ui['password'], $user['password'], $user['password_type']) )
	{
	/**
	 * password does not match.
	 */
	goBack(wrongPassword, "user::login_submit");
}

/** user login okay */


/**
 * autologin, remember user's information.
 */
if ( isset($ui['autologin']) && !empty($ui['autologin']) )
{
	if ( !isset($system['login_session_last']) || empty($system['login_session_last']) ) $last = 0;
	else $last = time() + $system['login_session_last'] * 60 * 60 * 24;
	
	
}
else $last = 0;


/**
 * make user's webbrowser as logged.
 */
doLogin($user, $last);

{
	/**
	 * update user information
	 */
	$update['idx']									= $user['idx'];
	$update['ip_lastlogin']					= $_SERVER['REMOTE_ADDR'];
	$update['dateTime_lastlogin']		= dateTime();
	$update['login_count']					= $user['login_count'] + 1;
	
	$rc = updateUser($update);
	if ( faultcode($rc) ) goBack();
}

set_user_session($user,$last);


/**
 * 로그인 후, 이동할 위치가 지정되어 있으면 그 위치로 이동. 아니면, 스킨 출력.
 * 스킨에서 referer 를 보고 로그인 위치로 이동할 수 있도록 하면된다.
 */
if ( isset($ui['nextpage']) && !empty($ui['nextpage']) )
{
	go($ui['nextpage']);
}

?>
