<?php
/**
 * 사용자 모듈
 *
 * @since 2007/02/15 권한 체크는 각 스크립트에서 진행한다.
 * - check the authority.
 *
 *
 */

lib('user');
return;

admin() or checkUserAuthority();



/**
 * check user's authority
 *
 * @since 2007/01/12 moved from lib/user.php to module/user/begin.php
 */
function checkUserAuthority()
{
	global $cate, $mode, $ui, $user, $lang;
	
	switch( $mode )
	{
		case 'read'						:
		case 'modify'					:
		case 'modify_submit'	:
		case 'leave'					:
		case 'logout'					:
		case 'logout_submit'	:
			! login() and goBack(accessDenied, $lang['accessDenied']);
			break;
		/** no need to check permission */
		case 'password'				:
		case 'password_q'			:
		case 'password_a'			:
		case 'login'					:
		case 'login_submit'		:
		case 'signup'					:
		case 'signup_submit'	: break;

		default								:
			goBack(accessDenied, $lang['accessDenied']);
	}
	return ok;
}


?>
