<?php
/**
 * 플러그인의 스크립트 포함
 *
 * 
 * 플러그인 디렉토리에 존재하는 admin.php, config.php 등과 같은 스크립트는 자체적으로 실행을 할 수 있는 방법이 없다.
 *
 * 이 스크립트는 plugin 모듈에서 각 플러그인 디렉토리에 존재하는 admin.php, config.php 와 같은 스크립트를
 * 실행하기 위해서 준비를 한다.
 *
 * "?cate=plugin&mode=plugin&plugin_name=example&action=스크립트이름" 과 같이 호출하면된다.
 *
 *
 * @note 필수 입력 값.
 *	cate, mode 외에 아래의 입력값이 필요하다. 아래의 입력값은 include 되는 스크립트에서 그대로 사용이 가능하다.
 *	- $ui['dir']							플러그인 디렉토리 이름
 *	- $ui['action']						인클루드할 스킨
 *
 * @note 그외 입력값
 *	- $ui['area_name']				스킨에서 위치 이름
 */

/**
 * @since 2007/03/30 플러그인 모듈은 열려있어야, 플러그인의 특정 스크립트를 실행할 수 있다.
 * 
 */
///admin('plugin') or goBack(accessDenied, "you don't have permission for this");
include dirRoot."/plugin/$ui[dir]/$ui[action].php";

return noskin()
?>
