<?php
/**
 * 플러그인 스킨 적용
 *
 * 스킨에 플러그인을 적용할 수 있도록 해 주는 페이지.
 *
 * 표현 형식대로 값을 지정해야한다.
 *
 * @note 표현 형식: 플러그인이름 (디렉토리이름)
 *
 * @see BUILDGUIDE
 *
 */

/**
 * 권한 인증
 */
admin('plugin') or goBack(accessDenied, "you don't have permission for this");

include script('plugins');

?>
<html>
<head>
	<link rel="stylesheet" type="text/css" href="skin/default/default.css">
	<meta http-equiv=Content-Type content='text/html;charset=utf-8'>
	<style>
	body {margin:10;}
	</style>
</head>

<div id="title">플러그인 관리</div>
<div id="note">
	시스템에 추가된 플러그인에 대해서 관리를 합니다.
</div>


<ul>
<?foreach($plugins as $plugin){?>

	<li>
		<a href="?cate=plugin&mode=plugin&dir=<?=$plugin['dirname']?>&action=admin">
			<?=$plugin['name']?> (<?=$plugin['dirname']?>)
		</a>
	</li>

<?}?>
</ul>

<?return noskin()?>
